"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var hub_1 = require("@sentry/hub");
var logger_1 = require("@sentry/utils/logger");
/**
 * Internal function to create a new SDK client instance. The client is
 * installed and then bound to the current scope.
 *
 * @param clientClass The client class to instanciate.
 * @param options Options to pass to the client.
 * @returns The installed and bound client instance.
 */
function initAndBind(clientClass, options) {
    if (options.debug === true) {
        logger_1.logger.enable();
    }
    var client = new clientClass(options);
    hub_1.getCurrentHub().bindClient(client);
    client.install();
}
exports.initAndBind = initAndBind;
//# sourceMappingURL=sdk.js.map