"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@sentry/core");
const sdk_1 = require("../sdk");
const backend_1 = require("./backend");
const context_1 = require("./context");
const normalize_1 = require("./normalize");
/** SDK version used in every event. */
// tslint:disable-next-line
exports.SDK_VERSION = require('../../package.json').version;
/** Frontend implementation for Electron renderer backends. */
class MainClient extends core_1.BaseClient {
    /**
     * Creates a new Electron SDK instance.
     * @param options Configuration options for this SDK.
     */
    constructor(options) {
        super(backend_1.MainBackend, options);
    }
    /**
     * @inheritDoc
     */
    prepareEvent(event, scope, hint) {
        const _super = Object.create(null, {
            prepareEvent: { get: () => super.prepareEvent }
        });
        return __awaiter(this, void 0, void 0, function* () {
            event.platform = event.platform || 'node';
            event.sdk = Object.assign({}, event.sdk, { name: sdk_1.SDK_NAME, packages: [
                    ...((event.sdk && event.sdk.packages) || []),
                    {
                        name: 'npm:@sentry/electron',
                        version: exports.SDK_VERSION,
                    },
                ], version: exports.SDK_VERSION });
            // We need to load the options here and set release from options
            // Otherwise addEventDefaults will add default values there
            const { environment, release, dist } = this.getOptions();
            const prepared = Object.assign({}, event);
            if (prepared.environment === undefined && environment !== undefined) {
                prepared.environment = environment;
            }
            if (prepared.release === undefined && release !== undefined) {
                prepared.release = release;
            }
            if (prepared.dist === undefined && dist !== undefined) {
                prepared.dist = dist;
            }
            return _super.prepareEvent.call(this, normalize_1.normalizeEvent(yield context_1.addEventDefaults(prepared)), scope, hint);
        });
    }
    /**
     * Uploads a native crash dump (Minidump) to Sentry.
     *
     * @param path The relative or absolute path to the minidump.
     * @param event Optional event payload to attach to the minidump.
     * @param scope Optional SDK scope used to upload.
     */
    captureMinidump(path, event = {}, scope) {
        return __awaiter(this, void 0, void 0, function* () {
            event.tags = Object.assign({ event_type: 'native' }, event.tags);
            yield this.processEvent(event, (finalEvent) => __awaiter(this, void 0, void 0, function* () { return this.getBackend().uploadMinidump(path, finalEvent); }), {}, scope);
        });
    }
    /**
     * @inheritDoc
     */
    captureEvent(event, hint, scope) {
        const _super = Object.create(null, {
            captureEvent: { get: () => super.captureEvent }
        });
        return __awaiter(this, void 0, void 0, function* () {
            event.tags = Object.assign({ event_type: 'javascript' }, event.tags);
            return _super.captureEvent.call(this, event, hint, scope);
        });
    }
    /**
     * @inheritDoc
     */
    addBreadcrumb(breadcrumb, hint, scope) {
        super.addBreadcrumb(breadcrumb, hint, scope);
    }
    /**
     * Does nothing in main/node
     */
    showReportDialog(_) {
        // noop
    }
}
exports.MainClient = MainClient;
//# sourceMappingURL=client.js.map