"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// tslint:disable-next-line
require('util.promisify/shim')();
const core_1 = require("@sentry/core");
const node_1 = require("@sentry/node");
const client_1 = require("./client");
const integrations_1 = require("./integrations");
const net_1 = require("./transports/net");
var client_2 = require("./client");
exports.MainClient = client_2.MainClient;
var backend_1 = require("./backend");
exports.MainBackend = backend_1.MainBackend;
var node_2 = require("@sentry/node");
exports.NodeIntegrations = node_2.Integrations;
// tslint:disable-next-line:variable-name
exports.ElectronIntegrations = { Electron: integrations_1.Electron, OnUncaughtException: integrations_1.OnUncaughtException };
/**
 * Init call to node, if no transport is set, we use net of electron
 * @param options ElectronOptions
 */
function init(options) {
    const electronIntegrations = node_1.defaultIntegrations.filter(integration => integration.name !== 'OnUncaughtException');
    if (options.defaultIntegrations === undefined) {
        options.defaultIntegrations = [
            ...electronIntegrations,
            // tslint:disable-next-line:no-unbound-method
            new integrations_1.OnUncaughtException({ onFatalError: options.onFatalError }),
            new integrations_1.Electron(),
        ];
    }
    core_1.initAndBind(client_1.MainClient, Object.assign({ transport: net_1.NetTransport }, options));
}
exports.init = init;
//# sourceMappingURL=index.js.map