import { ReportDialogOptions } from '@sentry/browser';
import { BaseClient, Scope } from '@sentry/core';
import { Breadcrumb, SentryBreadcrumbHint, SentryEvent, SentryEventHint } from '@sentry/types';
import { CommonClient, ElectronOptions } from '../common';
import { RendererBackend } from './backend';
/** Frontend implementation for Electron renderer backends. */
export declare class RendererClient extends BaseClient<RendererBackend, ElectronOptions> implements CommonClient {
    /**
     * Internal used browser client
     */
    private readonly inner;
    /**
     * Creates a new Electron SDK instance.
     * @param options Configuration options for this SDK.
     */
    constructor(options: ElectronOptions);
    /**
     * @inheritDoc
     */
    protected prepareEvent(event: SentryEvent, scope?: Scope, hint?: SentryEventHint): Promise<SentryEvent | null>;
    /**
     * Uploads a native crash dump (Minidump) to Sentry.
     *
     * @param path The relative or absolute path to the minidump.
     * @param event Optional event payload to attach to the minidump.
     * @param scope The SDK scope used to upload.
     */
    captureMinidump(_path: string, _event: SentryEvent, _scope?: Scope): Promise<void>;
    /**
     * @inheritDoc
     */
    addBreadcrumb(breadcrumb: Breadcrumb, _hint?: SentryBreadcrumbHint, _scope?: Scope): Promise<void>;
    /**
     * Basically calling {@link BrowserClient.showReportDialog}
     * @inheritdoc
     */
    showReportDialog(options?: ReportDialogOptions): void;
}
