export { Breadcrumb, Request, SdkInfo, SentryEvent, SentryException, SentryResponse, Severity, StackFrame, Stacktrace, Status, Thread, User, } from '@sentry/types';
export { addGlobalEventProcessor, addBreadcrumb, captureException, captureEvent, captureMessage, configureScope, getCurrentHub, getHubFromCarrier, Hub, Scope, withScope, } from '@sentry/core';
export { NodeBackend, NodeOptions } from './backend';
export { NodeClient } from './client';
export { defaultIntegrations, init, flush, close } from './sdk';
export { SDK_NAME, SDK_VERSION } from './version';
import { Integrations as CoreIntegrations } from '@sentry/core';
import * as Handlers from './handlers';
import * as NodeIntegrations from './integrations';
import * as Parsers from './parsers';
import * as Transports from './transports';
declare const INTEGRATIONS: {
    Console: typeof NodeIntegrations.Console;
    Http: typeof NodeIntegrations.Http;
    OnUncaughtException: typeof NodeIntegrations.OnUncaughtException;
    OnUnhandledRejection: typeof NodeIntegrations.OnUnhandledRejection;
    LinkedErrors: typeof NodeIntegrations.LinkedErrors;
    Modules: typeof NodeIntegrations.Modules;
    Transaction: typeof NodeIntegrations.Transaction;
    Dedupe: typeof CoreIntegrations.Dedupe;
    FunctionToString: typeof CoreIntegrations.FunctionToString;
    SDKInformation: typeof CoreIntegrations.SDKInformation;
    InboundFilters: typeof CoreIntegrations.InboundFilters;
    ExtraErrorData: typeof CoreIntegrations.ExtraErrorData;
    Debug: typeof CoreIntegrations.Debug;
    RewriteFrames: typeof CoreIntegrations.RewriteFrames;
};
export { INTEGRATIONS as Integrations, Transports, Parsers, Handlers };
