(function(RongIM, dependencies, components) {
    'use strict';
    var Http = RongIM.dataModel._Http;
    var common = RongIM.common;
    var utils = RongIM.utils;
    var $ = dependencies.jQuery;
    // var orgExpand = false;
    // 缓存根节点信息切换时不重新获取
    var cacheRootList = null;

    components.dialogTreeList = function(resolve, reject) {
        var im = RongIM.instance;
        var dataModel = im.dataModel;
        var groupApi = dataModel.Group;
        var dialog = RongIM.dialog;
        var publicTreeView = RongIM.treeView;
        window.showAddFriendDialog = function() {
            dialog.addFriend();
        }

        // 模块化屏蔽入口 
        // 好友
        var modules = im.config.modules;
        var orgApi = dataModel.Organization;
        var options = {
            name: 'dialog-tree-list',
            template: '#dialog-tree-list',
            data: function() {
                return {
                    treeList: [],
                    utilTreeParams: {
                        text: RongIM.locale.zh.blish.orgContact,
                        icon: 'my',
                        root: true,
                        id: RongIM.instance.auth.id,
                        rootType: 'myOrganization',
                        selectable: false,
                        state: {
                            checked: false,
                            disabled: false,
                            expanded: true,
                            selected: false
                        },
                        tree: 'dialog',
                        newGroup: false, //是否有新的通讯组
                        chatGroupList: [],
                    }
                }
            },
            props: {
                selectedTab: {
                    type: Object,
                    default () {
                        return {
                            name: RongIM.locale.zh.blish.orgContact,
                            id: 'org'
                        }
                    }
                },
                // dialog 入口区分
                entryType: {
                    type: String,
                    default: ""
                }
            },
            watch: {},
            computed: {
                treeTitle() {
                    this.initTreeParams(this.selectedTab.id);
                    return this.selectedTab.name
                },

            },
            components: {
                'tree-view': components.treeView
            },
            created: function() {},
            mounted: function() {
                // this.getMyOrganization();

            },
            methods: {
                initTreeParams(type) {
                    let that = this,
                        treeViewData = publicTreeView.treeViewData;
                    switch (type) {
                        case "org":
                            that.treeList = publicTreeView.setTreeViewJson([that.utilTreeParams]);
                            that.getMyOrganization();
                            break;
                        case "follow":
                            // let followTree = Object.assign({}, treeViewData.myFollowTree);
                            // let followDept = Object.assign({}, treeViewData.followDept);
                            // let followOrganization = Object.assign({}, treeViewData.followOrganization);
                            // let followWorkingGroup = Object.assign({}, treeViewData.followWorkingGroup);
                            // followTree.nodes = [
                            //     followOrganization,
                            //     followDept,
                            //     followWorkingGroup
                            // ]
                            // followTree.id = RongIM.instance.auth.id;
                            // followTree.tree = "dialog";
                            // this.$nextTick(function() {
                            //     that.treeList = publicTreeView.setTreeViewJson([followTree]);
                            //     that.$set(that.treeList[0].nodes[0], 'nodes',[])
                            //     that.$set(that.treeList[0].nodes[1], 'nodes',[])
                            //     that.$set(that.treeList[0].nodes[2], 'nodes',[])
                            //     that.getMyFollow()
                            // })
                            // that.treeList = publicTreeView.setTreeViewJson([followTree]);
                            // this.$set(that.treeList[0].nodes[0], 'nodes',[])
                            // this.$set(that.treeList[0].nodes[1], 'nodes',[])
                            // this.$set(that.treeList[0].nodes[2], 'nodes',[])


                            let followTree = Object.assign({}, treeViewData.myFollowTree);
                            let followDept = Object.assign({}, treeViewData.followDept);
                            let followOrganization = Object.assign({}, treeViewData.followOrganization);
                            let followWorkingGroup = Object.assign({}, treeViewData.followWorkingGroup);
                            let treeList = followTree;
                            treeList.nodes = [];
                            treeList.nodes = [
                                followOrganization,
                                followDept,
                                followWorkingGroup
                            ];
                            treeList.tree = "dialog";

                            for (let i of treeList.nodes) {
                                i.tree = "dialog"
                            }
                            this.$nextTick(function() {
                                that.treeList = publicTreeView.setTreeViewJson([followTree]);
                                that.$set(that.treeList[0].nodes[0], 'nodes',[])
                                that.$set(that.treeList[0].nodes[1], 'nodes',[])
                                that.$set(that.treeList[0].nodes[2], 'nodes',[])
                                that.getMyFollow()
                            })
                            break;
                        case "recentContacts":
                            let newRecentTrees = Object.assign({}, treeViewData.newRecentTree);
                            let recentContactss = Object.assign({}, treeViewData.recentContacts);
                            recentContactss.nodes = [];
                            recentContactss.tree = "dialog";
                            newRecentTrees.tree = "dialog";
                            newRecentTrees.isDefaultSele = true;
                            recentContactss.nodes = [newRecentTrees];
                            this.$nextTick(function() {
                                that.treeList = publicTreeView.setTreeViewJson([recentContactss]);
                            });
                        case "phone":
                            let phoneTree = Object.assign({}, treeViewData.myMailListTree);
                            let datSayGroupTree = Object.assign({}, treeViewData.datSayGroupTree);
                            let distributionGroupTree = Object.assign({}, treeViewData.distributionGroupTree);
                            let dayContactTree = Object.assign({}, treeViewData.dayContactTree);
                            let specialContactTree = Object.assign({}, treeViewData.specialContactTree);
                            let newRecentTree = Object.assign({}, treeViewData.newRecentTree);
                            let recentContacts = Object.assign({}, treeViewData.recentContacts);
                            let treeViews = type == "recentContacts" ? recentContacts : phoneTree;
                            if (type == "recentContacts") newRecentTree.isDefaultSele = true;
                            treeViews.nodes = [];
                            if (type != "recentContacts") {
                                treeViews.nodes = [
                                    distributionGroupTree,
                                    datSayGroupTree,
                                    specialContactTree,
                                    dayContactTree
                                ];
                            }
                            treeViews.tree = "dialog";

                            // this.entryType == "card" if中加入这个判断，发送个人卡片时不显示通讯组
                            if (this.entryType == "created" && !distributionGroupTree) {
                                treeViews.nodes.shift()
                            }
                             else if (this.entryType == "forward" && type === "recentContacts") { // 20240117转发消息时去掉最近联系人
                                treeViews.nodes.push(newRecentTree)
                            }
                            for (let i of treeViews.nodes) {
                                i.tree = "dialog"
                            }
                            this.$nextTick(function() {
                                that.treeList = publicTreeView.setTreeViewJson([treeViews]);
                                that.$set(that.treeList[0].nodes[0], 'nodes', []);
                            })
                            break;
                        default:
                    }

                },
                /**
                 * treeView节点添加nodes
                 * @param {*} data Array 需要添加的数组集合
                 * @param {*} rootType   tree区分 type
                 */
                itemTreeAddNodes(data, rootType) {
                    let arr = data.map((item, index) => {
                        if (rootType == 'distributionGroup') {
                            return publicTreeView.addItemNodes(item, rootType, "left")
                        } else {
                            return publicTreeView.addItemNodes(item, rootType, "dialog")
                        }

                    })
                    return arr;
                },
                // 获取我的组织第一层列表
                getMyOrganization(type) {
                    let that = this,
                        arr = [],
                        params = {
                            orgtype: '0,1,3',
                        };
                    orgApi.getMyOrganization(RongIM.instance.auth.id, params, function(res) {
                        if (res.count > 0) {
                            arr = that.itemTreeAddNodes(res.data, "myOrganization");
                            if (that.selectedTab.id == 'org') {
                                that.$set(that.treeList[0], 'nodes', arr);
                            }
                        } else {
                            delete that.treeList[0].nodes;
                        }
                    })
                },
                //获取我的关注
                getMyFollow(type) {
                    let that = this,
                        params = {
                            focustate: '0',
                            // orgtype: this.selectId,
                        },

                        arr = [];
                    // if (type != undefined) {
                    //     params.orgtype = type
                    // }
                    orgApi.getMyfollow(RongIM.instance.auth.id, params, function(result) {
                        console.log(result, that.treeList[0])
                        if (result.count > 0) {
                            arr = that.itemTreeAddNodes(result.data, "myFollow");
                            if (that.selectedTab.id == "follow") {
                                // that.$set(that.treeList[0], 'nodes', arr);
                                arr.forEach(item=>{
                                    switch(item.vchar_p3){
                                        case '0':
                                            that.treeList[0].nodes[1].nodes.push(item);
                                            break;
                                        case '1':
                                            that.treeList[0].nodes[2].nodes.push(item);
                                            break;
                                        default:
                                            that.treeList[0].nodes[0].nodes.push(item);
                                    }
                                })
                                console.log('jdsajfsadjfhjsakdfhjksad-----',that.treeList)
                            }
                        } else {
                            delete that.treeList[0].nodes;
                        }
                    })
                },
                /**
                 * 子组件通知当前点击的每一项
                 * @param {Object} item 当前点击项
                 * @param {Function} callback 回调函数
                 */
                itemActive(item, target, callback) {
                    console.log(item, target)
                    let that = this;
                    let tree = $('#treeView');
                    let nodeid = $(target.target).attr('data-nodeid');
                    let nodes = tree.treeview('getNode', nodeid);
                    let $seleList = $('#rong-selected-box-member-list');
                    // if ($seleList.is(':visible')) $seleList.hide();
                    that.$emit('item-nodes-active', nodes, target);
                    switch (nodes.rootType) {
                        case ('myOrganization'):
                            if (nodes.nodes && nodes.nodes.length == 0 && nodes.node_count > 0) {
                                that.getMyOrganizationMembers(nodes, callback);
                            } else {
                                callback(item.nodes)
                            }
                            break;
                        case 'myFollow':
                            if (nodes.nodes && nodes.nodes.length == 0 && nodes.node_count > 0) {
                                that.getMyFollowChild(nodes, callback);
                                // callback(item.nodes)
                            } else {
                                callback(item.nodes)

                            }
                            break;
                        case 'myMailList':
                            if (nodes.root && nodes.rootType == "myMailList") {
                                callback(item.nodes)
                            }
                            break;
                        case 'distributionGroup':
                            if (nodes.nodes && nodes.nodes.length == 0) {
                                that.getMyMailList(nodes, callback)
                            } else {
                                callback(item.nodes)
                            }
                            break;
                        default:
                    }
                },
                /**
                 * 获取组织成员数据
                 * @param {Object} item 当前点击项
                 * @param {Function} callback 回调函数
                 */
                getMyOrganizationMembers(item, callback) {
                    let that = this,
                        params = {
                            type: 'depart',
                            state: 0,
                            // orgtype:'0,1,3',
                        },
                        arr = [];
                    // if (item && item.vchar_p3 != null) {
                    //     params.orgtype = item.vchar_p3 == 1 ? '1' : '0,1,3';
                    // }
                    orgApi.getMembers(item.id, params, function(result) {
                        if (result.count > 0) {
                            arr = that.itemTreeAddNodes(result.data, "myOrganization");
                        }
                        callback(arr);
                    });
                },
                /**获取我的通讯录-----通讯录列表*/
                getMyMailList(i, callback) {
                    let that = this;
                    return orgApi.getPinGroups('', res => {
                        if (!res.total_count) return;
                        that.chatGroupList = res.data.map(obj => {
                            return {
                                ...obj,
                                name: obj.name + '(' + obj.count + '人)',
                                root: false
                            }
                        });
                        if (that.chatGroupList.length > 0) {
                            let arr = that.itemTreeAddNodes(that.chatGroupList, "distributionGroup");
                            let list = arr.map(obj => {
                                return {
                                    ...obj,
                                    nodeType: 'distributionGroup'
                                }
                            })
                            if (callback) callback(list);
                        }

                    })
                },
                //获取我的关注子级
                getMyFollowChild(item, callback) {
                    let that = this,
                        company = [],
                        params = {
                            type: 'depart',
                            state: 0,
                        };
                    // if (item && item.vchar_p3 != null) {
                    //     params.orgtype = item.vchar_p3 == 1 ? '1' : '0,1,3';
                    // }
                    orgApi.getMembers(item.id, params, function(result) {
                        if (result.count > 0) {
                            company = that.itemTreeAddNodes(result.data, item.rootType);
                            callback(company);
                        }
                    })
                },
            },
        };
        utils.asyncComponent(options, resolve, reject);
    };
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));