(function (RongIM, dependencies, components) {
'use strict';

var common = RongIM.common;
var utils = RongIM.utils;
var $ = dependencies.jQuery;
// var orgExpand = false;
// 缓存根节点信息切换时不重新获取
var cacheRootList = null;

function getList(resolve, reject) {
    var im = RongIM.instance;
    var dataModel = im.dataModel;
    var groupApi = dataModel.Group;
    var dialog = RongIM.dialog;
    window.showAddFriendDialog = function () {
        dialog.addFriend();
    }

    // 模块化屏蔽入口
    // 好友
    var modules = im.config.modules;
    var orgApi = dataModel.Organization;
    var options = {
        name: 'contact-list',
        template: '#rong-template-contact-list',
        data: function () {
            return {
                companyList: [],
                myDept: null,
                selfOrgInfoList: [],
                bound: {
                    width: {
                        min: 0,
                        max: 0
                    }
                }
            };
        },
        watch: {
            $route: function () {
                common.resizeNavNode(this, im);
            },
            companyId: function (newVal) {
                if (newVal && cacheRootList) {
                    common.sortByMydeptAndMajorCompany(cacheRootList, newVal);
                }
            }
        },
        computed: {
            enabledFriend: function () {
                return modules.friend;
            },
            // 星标联系人
            enabledStar: function () {
                return modules.star;
            },
            auth: function () {
                return im.auth;
            },
            isStaff: function () {
                return im.auth.isStaff;
            },
            companyId: function () {
                return this.auth.companyId;
            },
            myDeptId: function () {
                return this.auth.deptId || 'root';
            },
            requestUnReadCount: function () {
                return im.requestUnReadCount;
            },
            approveUnReadCount: function () {
                return im.approveUnReadCount;
            },
            width: function () {
                var node = im.resizeNode.rongList;
                return node.width;
            },
            showRequestContact: function () {
                return im.requestUnReadCount > 0 ||
                    this.$route.path === '/contact/friends' ||
                    this.$route.path === '/contact/request-friend';
            },
            showApproveContact: function () {
                return im.approveUnReadCount > 0 ||
                    this.$route.path === '/contact/group' ||
                    this.$route.path === '/contact/approve';
            }
        },
        components: {
            imageLoader: components.getImageLoader,
            search: components.getSearch
        },
        created: function () {
            if (this.isStaff) {
                getCompany(this, orgApi);
            }
        },
        mounted: function () {
            common.resizeNavNode(this, im);
            watchApproveRequest(groupApi, this, im);
        },
        methods: {
            setComanyList: function (companies) {
                this.companyList = companies;
                this.myDept = companies[0].myDept;
            }, 
            toggleList: function (company) {
                if (company.myDept) {
                    this.myDept = company.myDept;
                }
                toggleList(company);
            },
            getResizeDirection: function () {
                var direction = common.getResizeDirection({
                    range: this.width,
                    bound: this.bound.width,
                    directions: ['left', 'right']
                });
                im.resizeDirection.temp = direction;
                return direction;
            },
            memberCount: function (item) {
                var format = this.locale.contact.person;
                if (item.member_count === 1) {
                    format = this.locale.contact.personSingle;
                }
                return this.localeFormat(format, item.member_count);
            },
            /*getDeptRoute: function (coId, item) {
                return {
                    name: 'organization',
                    params: {
                        coId: coId,
                        orgId: item.id,
                        type: item.type
                    }
                };
            },*/
            getMyDeptRoute: function (myDeptInfo) {
                return {
                    name: 'mydept',
                    params: {
                        coId: myDeptInfo.companyId,
                        orgId: myDeptInfo.deptId,
                        type: myDeptInfo.deptType
                    }
                };
            }
        },
        destroyed: function () {
            // orgExpand = null;
            cacheRootList = null;
            groupApi.unwatch(this.setApproveUnread);
        }
    };
    utils.asyncComponent(options, resolve, reject);
}

function getCompany(context, orgApi) {
    if (cacheRootList) {
        context.setComanyList(cacheRootList);
        return;
    }
    orgApi.getAutocephalyCompanyWithMydept(function (error, companyList) {
        cacheRootList = [].concat(companyList);
        common.sortByMydeptAndMajorCompany(cacheRootList, context.companyId);
        /*var companyCount = cacheRootList.length;
        cacheRootList.forEach(function (company) {
            orgApi.getBranch(company.id, function (errorCode, result) {
                if (errorCode) {
                    common.toastError(errorCode);
                } else {
                    company.depts = result.depts;
                }
                if (--companyCount == 0) {
                    context.setComanyList(cacheRootList);
                }
            });
        });*/
        context.setComanyList(cacheRootList);
    });
}

function toggleList(company) {
    Vue.set(company, 'expand', !company.expand);
}

function watchApproveRequest(groupApi, context, im) {
    setApproveUnReadCount(groupApi, im);
    context.setApproveUnread = function (message) {
        var messageType = message.messageType;
        var isGroupVerifyNotify = messageType === 'GroupVerifyNotifyMessage';
        if (isGroupVerifyNotify) {
            setApproveUnReadCount(groupApi, im);
        }
    };
    groupApi.watch(context.setApproveUnread);
}

function setApproveUnReadCount(groupApi, im) {
    groupApi.getApproveUnread(function (err, count) {
        if (!err) {
            im.approveUnReadCount = count;
        }
    });
}

$.extend(true, components, {
    contact: {
        getList: getList
    }
});
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));
