/*
说明：群组消息已读回执确认详情（已读成员，未读成员）
*/
(function (RongIM, components) {
'use strict';

var common = RongIM.common;
var dialog = RongIM.dialog;
var pageNum = RongIM.config.ack.pageNum;

/*
说明：群组消息已读回执确认详情弹框
参数：
    @param {array<object>}    memberList    成员信息
    @param {array<string>}    readIdList    已读成员Id
    @param {string}           messageId     消息Id （用于监听消息已读成员变化）
    @param {string}           groupId       群组Id （用于获取成员的群昵称）
*/
RongIM.dialog.ack = function (memberList, readIdList, messageId, groupId) {
    var im = RongIM.instance;
    var options = {
        name: 'ack',
        template: 'templates/conversation/ack.html',
        data: function () {
            return {
                show: true,
                memberList: [],
                readIdList: [],
                tab: 'unread',
                style: '',
                pageNum: pageNum,
                currentPage: 1
            };
        },
        components: {
            avatar: components.getAvatar
        },
        computed: {
            allReadMember: function () {
                var context = this;
                return context.memberList.filter(function (item) {
                    return context.readIdList.indexOf(item.id) !== -1;
                });
            },
            readMember: function () {
                var context = this;
                var _list = context.memberList.filter(function (item) {
                    return context.readIdList.indexOf(item.id) !== -1;
                });
                var end = context.currentPage * context.pageNum;
                return _list.slice(0, end);
            },
            allUnreadMember: function () {
                var context = this;
                return context.memberList.filter(function (item) {
                    return context.readIdList.indexOf(item.id) === -1;
                });
            },
            unreadMember: function () {
                var context = this;
                var _list = context.memberList.filter(function (item) {
                    return context.readIdList.indexOf(item.id) === -1;
                });
                var end = context.currentPage * context.pageNum;
                return _list.slice(0, end);
            }
        },
        watch: {
            tab: function () {
                this.currentPage = 1;
                $(this.$refs.readList).scrollTop(0);
                $(this.$refs.unreadList).scrollTop(0);
            }
        },
        mounted: function () {
            var context = this;
            context.memberList = memberList;
            context.readIdList = readIdList;
            // 监听消息的已读人数变化及时更新
            context.watchUnRead = function (data) {
                context.memberList = data.memberList.filter(function (item) {
                    return item.id !== RongIM.instance.auth.id;
                });
                context.readIdList = data.readIdList.filter(function (item) {
                    return item !== RongIM.instance.auth.id;
                });
            };
            im.$on('messageUnRead' + messageId, context.watchUnRead);
            // 页面跳转时 1.关闭弹出框 2.清除监听
            var unwatch = im.$watch('$route', function () {
                context.close();
                unwatch();
            });
        },
        destroyed: function () {
            im.$off('messageUnRead' + messageId, this.watchUnRead);
        },
        methods: {
            close: function () {
                this.show = false;
            },
            getUsername: function (item) {
                item = item || {};
                return common.getGroupUsername(item, groupId);
            },
            showUserInfo: function (user) {
                dialog.user(user.id);
            },
            loadMoreRead: function () {
                loadMore(this, 'read');
            },
            loadMoreUnread: function () {
                loadMore(this, 'unread');
            }
        }
    };

    common.mountDialog(options, function (instance) {
        // 调试使用
        RongIM._ack = instance;
    });
};

function loadMore(context, isRead) {
    var end = context.currentPage * context.pageNum;
    var list;
    if (isRead === 'read') {
        list = context.allReadMember;
    } else {
        list = context.allUnreadMember;
    }
    if (list && list.length > end) {
        context.currentPage += 1;
    }
}
}(RongIM, RongIM.components));
