/*
说明：设置 - 主框架
功能：
    1. 切换设置页显示内容
*/
(function (RongIM, dependencies, components) {
'use strict';

var common = RongIM.common;
var utils = RongIM.utils;
var domtoimage = dependencies.domtoimage;

RongIM.dialog.groupQRCode = function (group) {
    var im = RongIM.instance;
    var options = {
        name: 'group-qrcode',
        template: '#rong-template-group-qrcode',
        data: function () {
            return {
                busy: true,
                show: true,
                base64: ''
            };
        },
        components: {
            avatar: components.getAvatar
        },
        created: function () {
            this.group = group;
            var groupApi = RongIM.dataModel.Group;
            var context = this;
            Vue.nextTick(function () {
                var qrcodeDom = context.$refs.qrcode;
                var qrcodeImgDom = context.$refs.qrcodeImg;
                groupApi.createQRCode(qrcodeDom, im.auth.id, group.id, { width: 207, height: 209 });
                groupApi.createQRCode(qrcodeImgDom, im.auth.id, group.id, { width: 400, height: 400 });
                setTimeout(function () {
                    // domtoimage 库 生成图片奔溃 ，这里修改库为html2canvas
                    html2canvas(context.$refs.saveImg, {useCORS: true, logging: true}).then(canvas => {
                        context.base64 = canvas.toDataURL().split(',')[1];
                        context.busy = false;
                    });
                //     domtoimage.toPng(context.$refs.saveImg)
                //         .then(function (dataUrl) {
                //             context.base64 = dataUrl;
                //             context.busy = false;
                //         })
                //         .catch(function (error) {
                //             console.error('oops, something went wrong!', error);
                //         });
                }, 0);
            });
        },
        computed: {
            loadingTip: function () {
                return im.locale.tips.loading
            }
        },
        methods: {
            getHtmlGroupName: common.getHtmlGroupName,
            memberCount: function (item) {
                var format = this.locale.contact.person;
                if (item.member_count === 1) {
                    format = this.locale.contact.personSingle;
                }
                return this.localeFormat(format, item.member_count);
            },
            getGroupName: function () {
                return common.getGroupName(group);
            },
            save: function () {
                var downloadTag = document.createElement('a');
                downloadTag.href = this.base64;
                downloadTag.download = new Date().getTime() + '.png';
                downloadTag.click();
            },
            forward: function () {
                var message = {};
                var base64 = utils.Base64.replace(this.base64);
                message.content = {
                    content: base64,
                    messageName: utils.messageType.ImageMessage,
                    thumbnailPath: '',
                    isForwaed: true
                };
                // RongIM.dialog.forward(message);
                // RongIM.dialog.newForward(message);
                RongIM.dialog.forwardDialog(message,"forward");
                this.close();
            },
            close: function () {
                this.show = false;
            }
        }
    };

    common.mountDialog(options, function (dialog) {
        im.$watch('$route', function () {
            dialog.show = false;
        });
    });
};
}(RongIM, {
    domtoimage: domtoimage
}, RongIM.components));
