(function (RongIM, dependencies, components) {
    'use strict';

    var common = RongIM.common;
    var utils = RongIM.utils;
    var dialog = RongIM.dialog;
    var pageNum = RongIM.config.groupSetting.pageNum;
    var orgazApi = RongIM.dataModel.Organization;

    /*
    说明： 群设置包括成员增删，修改群名称，修改群昵称等
    */
    components.getGroupSetting = function (resolve, reject) {
        var im = RongIM.instance;
        var dataModel = im.dataModel;

        var options = {
            name: 'group-setting',
            template: '#rong-template-group-setting',
            props: ['group', 'members'],
            data: function () {
                var params = im.$route.params;
                return {
                    nameEditable: false,
                    aliasEditable: false,
                    alias: '',
                    isSearch: false,
                    searchName: null,
                    groupNameField: '',
                    aliasField: '',
                    conversation: {
                        conversationType: params.conversationType,
                        targetId: params.targetId,
                        group: {}
                    },
                    needJoinPermit: '',
                    saveGroup: false,
                    inviteMember: '',
                    publishGroupNotice: '',
                    pageNum: pageNum,
                    currentPage: 1,
                    arr: [],
                    showGroup: false,
                    pinGroupList: [],
                    allGroups: [], //所有通讯组
                    selectGroup: {
                        id: ''
                    },
                    groupName: '', //新增组名称
                };
            },
            components: {
                avatar: components.getAvatar
            },
            mounted: function () {
                var api = {
                    user: dataModel.User,
                    group: dataModel.Group,
                    conversation: dataModel.Conversation
                };
                mounted(this, api, im);
            },
            watch: {
                aliasField: function (newVal) {
                    var context = this;
                    if (newVal.length > 10) {
                        context.aliasField = context.aliasField.substring(0, 10);
                    }
                }
            },
            computed: getComputed(dataModel),
            directives: {
                focus: {
                    inserted: function (el) {
                        el.focus();
                    }
                }
            },
            methods: getMethods(im)
        };
        utils.asyncComponent(options, resolve, reject);
    };

    function mounted(context, api, im) {
        im.$on('imclick', function (event) {
            close(context, event);
        });
        // 获取群设置相关的信息
        var group = context.group;
        var groupApi = api.group;
        var conversationApi = api.conversation;
        conversationApi.getOne(context.conversation.conversationType, context.conversation.targetId, function (errorCode, conversation) {
            context.conversation = conversation;
            groupApi.getList(function (error, groupList) {
                if (error) {
                    common.toastError(error);
                    return;
                }
                var idList = groupList.map(function (item) {
                    return item.id;
                });
                context.saveGroup = idList.indexOf(group.id) >= 0;
                // Vue.set(context.conversation.group, 'saved', idList.indexOf(group.id) >= 0);
            });
        });
        groupApi.getNewGroup(group.id, function (errorCode, _group) {
            if (errorCode) {
                common.toastError(errorCode);
                return;
            }
            context.needJoinPermit = _group.need_join_permit;
            context.inviteMember = _group.invite_member;
            context.publishGroupNotice = _group.publish_group_notice;
            context.alias = getSelfAliasName(group, im);
        });
    }

    /*
    说明： 获取自己在当前群组中的群昵称
    */
    function getSelfAliasName(group, im) {
        var loginUser = im.loginUser;
        var groupId = group.id;
        var user = loginUser || {};
        var groupCache = RongIM.dataModel._Cache.group[groupId] || {};
        var members = groupCache.members || [];
        var alias = user.alias || '';
        for (var i = 0; i < members.length; i += 1) {
            var item = members[i];
            if (item.id === user.id) {
                alias = item.groupAlias || item.alias || alias;
                break;
            }
        }
        return alias;
    }

    function getComputed(dataModel) {
        var conversationApi = dataModel.Conversation;
        var groupApi = dataModel.Group;
        var groupPermission = utils.groupPermission;
        return {
            // 双向绑定会话是否置顶
            isTop: {
                get: function () {
                    return this.conversation.isTop;
                },
                set: function (checked) {
                    var context = this;
                    var action = checked ? 'top' : 'untop';
                    var conversation = this.conversation;
                    conversation.isTop = checked;
                    setTimeout(function () {
                        conversationApi[action](conversation.conversationType, conversation.targetId, function (errorCode) {
                            if (errorCode) {
                                common.toastError(errorCode);
                                return;
                            }
                            context.$emit('set-property', 'isTop', checked);
                        });
                    }, 400);
                }
            },
            // 双向绑定会话是否面打扰
            isMute: {
                get: function () {
                    return this.conversation.notificationStatus;
                },
                set: function (checked) {
                    var context = this;
                    var action = checked ? 'mute' : 'unmute';
                    var conversation = context.conversation;
                    conversation.notificationStatus = checked;
                    setTimeout(function () {
                        conversationApi[action](conversation.conversationType, conversation.targetId, function (errorCode) {
                            if (errorCode) {
                                common.toastError(errorCode);
                                return;
                            }
                            context.$emit('set-property', 'notificationStatus', checked);
                        });
                    }, 400);
                }
            },
            // 双向绑定是否保存当前群组（保存到通讯录）
            isSaved: {
                get: function () {
                    return this.saveGroup;
                },
                set: function (checked) {
                    var context = this;
                    var action = checked ? 'addToFav' : 'removeFromFav';
                    var groupId = context.conversation.group.id;
                    groupApi[action]([groupId], function (errorCode) {
                        if (errorCode) {
                            common.toastError(errorCode);
                            return;
                        }
                        context.saveGroup = checked;
                    });
                }
            },
            // 双向绑定是否需要入群验证
            isAprrove: {
                get: function () {
                    return this.needJoinPermit;
                },
                set: function (checked) {
                    var context = this;
                    var group = this.conversation.group;
                    var needJoinPermit = checked ? 1 : 0;
                    var params = {
                        need_join_permit: needJoinPermit
                    };
                    context.needJoinPermit = needJoinPermit;
                    // 设置成功后更新缓存信息
                    setPermission(context, params, groupApi, function (err) {
                        if (err) {
                            return;
                        }
                        var cache = dataModel._Cache || {};
                        var groupCache = cache.group;
                        var groupLocale = groupCache[group.id] || {};
                        groupLocale.need_join_permit = needJoinPermit;
                    });
                }
            },
            // 自建群
            isCustomGroup: function () {
                return this.group && this.group.type === 0;
            },
            // 1 部门 2 公司 4 全员
            // isEntGroup: function () {
            //     return this.group.type === 1 || this.group.type === 2;
            // },
            filterMembers: function () {
                var _list = getFilterMembers(this);
                var end = this.currentPage * this.pageNum;
                if (_list.length > end) {
                    if (this.showAdd) {
                        end -= 1;
                    }
                    if (this.showRemove) {
                        end -= 1;
                    }
                }
                return _list.slice(0, end);
            },
            // 部门公司全员群默认保存到通讯录，只有自建群需要展示保存按钮
            showSave: function () {
                return this.isCustomGroup;
            },
            // 只有自建群可以自行增加删除成员，部门公司全员群的成员和组织机构绑定。
            showAdd: function () {
                return !this.searchName && this.isCustomGroup && this.ownerManageCondition;
            },
            showRemove: function () {
                return !this.searchName && this.group.is_creator && this.isCustomGroup;
            },
            showQuit: function () {
                return this.isCustomGroup;
            },
            showEdit: function () {
                return this.group.is_creator && this.isCustomGroup && !this.isSpecialGroup;
            },
            isManager: function () {
                var im = RongIM.instance;
                var auth = im.auth || {};
                var loginId = auth.id;
                return this.group.manager_id === loginId && !this.isSpecialGroup;
            },
            isSpecialGroup: function () {
                var group = this.conversation.group || {};
                var type = common.getGroupType(group.type);
                return !!type;
            },
            // 仅群主可管理
            isOwnerManage: {
                get: function () {
                    // var group = this.conversation.group;
                    return this.inviteMember === groupPermission.Owner && this.publishGroupNotice === groupPermission.Owner;
                },
                set: function (checked) {
                    var context = this;
                    var group = this.conversation.group;
                    var inviteMember = checked ? groupPermission.Owner : groupPermission.All;
                    var publishGroupNotice = checked ? groupPermission.Owner : groupPermission.All;
                    var params = {
                        invite_member: inviteMember,
                        publish_group_notice: publishGroupNotice
                    };
                    context.inviteMember = inviteMember;
                    context.publishGroupNotice = publishGroupNotice;

                    // 设置成功后更新缓存信息
                    var callback = function (err) {
                        if (err) {
                            return;
                        }
                        var cache = dataModel._Cache || {};
                        var groupCache = cache.group;
                        var groupLocale = groupCache[group.id] || {};
                        groupLocale.invite_member = inviteMember;
                        groupLocale.publish_group_notice = publishGroupNotice;
                    };
                    setPermission(context, params, groupApi, callback);
                }
            },
            ownerManageCondition: function () {
                return (this.isOwnerManage && this.group.is_creator) || !this.isOwnerManage;
            },
            showQRCode: function () {
                return this.isCustomGroup && this.ownerManageCondition;
            },
            //是否显示超长提示
            showErrorText: function () {
                return this.groupName.length > 15
            }
        };
    }


    function getMethods(im) {
        var dataModel = im.dataModel;
        var conversationApi = dataModel.Conversation;
        return {
            getGroupName: function () {
                return common.getGroupName(this.group);
            },
            /*
            说明： 开始编辑群名称
            */
            setEditable: function () {
                this.groupNameField = this.getGroupName();
                this.nameEditable = true;
            },
            /*
            说明： 开始编辑自己的群昵称
            */
            setAliasEditable: function (editable) {
                this.aliasEditable = editable;
                this.aliasField = this.alias || '';
            },
            saveName: function () {
                saveName(this, dataModel.Group, this.group);
            },
            removeEditable: function () {
                this.nameEditable = false;
            },
            // 开查找群成员
            setIsSearch: function () {
                this.isSearch = true;
            },
            setShowGroup: function () {
                this.showGroup = true
                getPinGroups(this)
            },
            clearSearch: function () {
                this.searchName = '';
                this.isSearch = false;
            },
            searchFocus: function () {
                var field = this.$refs.searchName;
                if (this.isSearch) field.focus();
            },
            delConversation: function () {
                delConversation(this, {
                    id: this.group.id,
                    type: utils.conversationType.GROUP
                }, conversationApi);
            },
            clearMessages: function () {
              let messageApi = dataModel.Message;
              messageApi.clearMessages({
                conversationType: utils.conversationType.GROUP,
                targetId: this.group.id,
              });
            },
            // 退出群组
            quitGroup: function (callback) {
                var groupId = this.group.id;
                dataModel.Group.quit(groupId, callback);
            },
            // 解散群组
            dismissGroup: function () {
                var context = this;
                var locale = context.locale;
                common.messagebox({
                    type: 'confirm',
                    message: locale.dismissMemo,
                    submitText: locale.tips.confirm,
                    isAlignLeft: true,
                    callback: function () {
                        dataModel.Group.dismiss(context.group.id, function () {
                            RongIM.system.appLogger('info', '解散群组成功 ' + context.group.id);
                            delConversation(context, {
                                id: context.group.id,
                                type: utils.conversationType.GROUP
                            }, conversationApi);
                        });
                    }
                });
            },
            delAndQuit: function () {
                var context = this;
                var locale = context.locale;
                common.messagebox({
                    type: 'confirm',
                    message: locale.quitMemo,
                    submitText: locale.tips.confirm,
                    callback: function () {
                        delAndQuit(context, im.$router);
                    }
                });
            },
            // 打开添加群成员面板
            addMember: function () {
                // dialog.createGroup(this.group, this.members);
                // dialog.blishGroup(this.group, this.members,true,'groupAdd');
                dialog.newDialogBox(this.group, this.members, "created");
            },
            // 打开删除群成员面板
            removeMembers: function () {
                dialog.groupRemoveMembers(this.group.id);
            },
            close: function () {
                this.$emit('hidepanel');
                im.$off('imclick', this.close);
            },
            userProfile: dialog.user,
            // 打开群禁言设置面板
            banned: function () {
                var group = this.group;
                dialog.groupBanned(group, this.members);
            },
            // 打开转让管理员面板
            transfer: function () {
                var group = this.group;
                dialog.groupTransfer(group, this.members);
            },
            modifyMemberAlias: function () {
                modifyMemberAlias(this, dataModel.Group, im);
            },
            checkManage: function (user) {
                return this.group.admin_id === user.id;
            },
            openQRCode: function () {
                dialog.groupQRCode(this.group);
            },
            loadMore: function () {
                loadMore(this);
            },
            isExis: function (item) {
                let arr = this.pinGroupList.filter(obj => obj.name == item.name)
                if (arr.length > 0) {
                    return true
                } else {
                    return false
                }
            },
            //删除元素
            delItem: function (index) {
                this.pinGroupList.splice(index, 1);
            },
            //点击空格键添加到所属通讯组
            saveGrou() {
                if(this.groupName.length > 15){
                    this.$refs.groupName.focus()
                    return;
                }
                let obj = {
                    name: this.groupName
                }
                //输入的通讯组名称已存在
                if (this.groupName == '') {
                    return;
                }
                if (this.checkOnly()) {
                    this.allGroups.forEach((item, index) => {
                        if (item.name == this.groupName) {
                            this.pinGroupList.push(item)
                        }
                    })

                } else {
                    this.pinGroupList.push(obj)
                }

                this.groupName = ''
            },
            toastError: function (errorCode) {
                var el = null;
                if (this.$el) {
                    el = this.$el.firstChild;
                }
                common.toastError(errorCode, el);
            },
            //检验输入的通讯组名是否存在
            checkOnly() {
                let arr = this.allGroups.filter(obj => obj.name == this.groupName)
                return arr.length > 0
            },
            //保存通讯组
            savePinGroup() {
                let that = this
                let login_id = im.loginUser.id;
                let receiver_ids = that.filterMembers.map(obj => obj.id).filter(res =>res != login_id)
                
                let receiver_names = that.pinGroupList.map(obj=>obj.name)
                im.dataModel.Group.changePersonalGroup({
                    receiver_ids: receiver_ids.filter(obj=>item != login_id),
                    receiver_names: receiver_names
                }, function (errorcode, res) {
                    if (errorcode) {
                        return;
                    }
                    common.messageToast({
                        type: 'success',
                        message: '添加成功'
                    });
                    that.showGroup = false
                    let str = ''
                    that.pinGroupList.forEach(obj => {
                        str += obj.name + '、'
                    })
                    that.pinGroup = str.substring(0, str.length - 1)
                    that.pinGroupList = []
                })
            },
            openPinGroup:function(){
                let that = this
                if(that.pinGroupList.length == 0){
                    that.showGroup=false;
                    return false;
                }
                common.messagebox({
                    type: 'confirm',
                    message: that.locale.btns.saveThis,
                    callback: function () {
                        that.savePinGroup()
                    },
                    closeCallback: function () {
                        that.showGroup=false;
                        that.pinGroupList = []
                    },
                    hashchangeClose: false
                });
            },
            selectObj: function (obj) {
                let flag = this.pinGroupList.filter(res =>res.id ==obj.id )
                if(flag.length >0){
                    this.pinGroupList.splice(this.pinGroupList.findIndex(item => item.id === obj.id), 1)
                    return;
                }
                this.selectGroup = obj
                let list = this.pinGroupList;
                list.push(obj)
                this.pinGroupList = this.unique(list)

            },
            unique(arr) {
                const res = new Map();
                return arr.filter((arr) => !res.has(arr.name) && res.set(arr.name, 1));
            },

        };
    }
    //获取所有的通讯组
    function getPinGroups(context) {
        orgazApi.getPinGroups('', res => {
            if (!res.count) return;
            context.allGroups = res.data

        })
    }

    function loadMore(context) {
        var end = context.currentPage * context.pageNum;
        var list = getFilterMembers(context);
        if (list && list.length > end) {
            context.currentPage += 1;
        }
    }

    /*
    说明： 删除会话并清除未读消息
    */
    function delConversation(context, params, conversationApi) {
        var conversationType = params.type;
        var groupId = params.id;
        conversationApi.clearUnReadCount(conversationType, groupId);
        conversationApi.remove(conversationType, groupId);
    }

    /*
    说明： 修改自己在当前群的昵称
    */
    function modifyMemberAlias(context, groupApi, im) {
        var loginUser = im.loginUser || {};
        var userId = loginUser.id;
        var name = context.aliasField;
        var groupId = context.group.id;
        if (name === '') {
            name = loginUser.name;
        }
        groupApi.modifyMemberAlias(groupId, userId, name, function (errorCode) {
            context.aliasEditable = false;
            if (errorCode) {
                context.aliasEditable = false;
                return;
            }
            RongIM.syncdata.groupById([groupId], function () {
                context.alias = name;
                // 修改成员列表里群昵称
                var _list = getFilterMembers(context);
                var member = getMemberById(_list, userId);
                member.alias = member.htmlAlias = name;
            });
        });
    }

    function getMemberById(members, id) {
        var member;
        for (var i = 0; i < members.length; i += 1) {
            var item = members[i];
            if (item.id === id) {
                member = members[i];
                break;
            }
        }
        return member;
    }

    /*
    说明： 根据关键字搜索群成员
    */
    function getFilterMembers(context) {
        var keyword = context.searchName;
        var members = context.members.concat([]);
        
        members = members.reverse();
        if (utils.isEmpty(keyword)) {
          for (var i = 0; i < members.length; i += 1) {
            var item = members[i];
            if (item.id === context.group.admin_id) {
              var memberTemp = members[i];
              members[i] = members[0];
              members[0] = memberTemp;
              break;
            }
          }
            return members;
        }
        return members.filter(function (member) {
            return utils.searchName([member.name, member.alias], keyword);
        });
    }

    /*
    说明： 修改群名称
    */
    function saveName(context, groupApi, group) {
        var MAX_LENGTH = 16;
        var newGroupName = utils.slice(context.groupNameField, MAX_LENGTH);
        var changed = newGroupName !== context.group.name && !utils.isEmpty(newGroupName);
        if (context.nameEditable && changed) {
            var oldName = group.name;
            group.name = newGroupName;
            groupApi.rename(group.id, newGroupName, function (errorCode) {
                if (errorCode) {
                    group.name = oldName;
                    common.toastError(errorCode);
                }
            });
        }
        context.removeEditable();
    }

    function close(context, event) {
        var $target = $(event.target);
        var wrap = '.rong-dialog, .rong-group-create, .rong-group-remove';
        var inBody = $target.closest('body').length > 0;
        var inWrap = $target.closest(wrap).length < 1;
        var isOuter = inBody && inWrap;
        if (isOuter) context.close();
    }

    /*
    说明： 退出群组并退出当前会话
    */
    function delAndQuit(context, router) {
        context.quitGroup(function (errorCode /* , result */ ) {
            if (errorCode) {
                RongIM.system.appLogger('error', '退出群组失败 ' + JSON.stringify(errorCode));
                common.toastError(errorCode);
                return;
            }
            context.delConversation();
            context.clearMessages();
            RongIM.system.appLogger('info', '退出群组，群组 id： ' + context.group.id);
            router.push({
                name: 'conversation',
                query: {
                    force: 1
                }
            });
            common.messageToast({
                message: common.getErrorMessage('contact-5')
            });
        });
    }

    function setPermission(context, params, groupApi, callback) {
        callback = callback || $.noop;
        groupApi.setPermission(context.group.id, params, function (err) {
            if (err) {
                utils.console.log('set permission error: ', err);
            }
            callback(err);
        });
    }
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));