(function (RongIM, dependencies, components) {
    'use strict';
    var utils = RongIM.utils;
    var common = RongIM.common;
    components.createToast = function (resolve, reject) {
        var im = RongIM.instance;
        var dataModel = im.dataModel;
        var userApi = dataModel.User;
        var options = {
            name: 'create-toast',
            template: '#create-toast',
            props: {
                title: String,
                content: String,
                // 是否允许点击蒙版隐藏
                isClickMue: false
            },
            data: function () {
                return {
                    isShow: false
                };
            },
            computed: {},
            filters: {},
            watch: {},
            created(){ },
            mounted: function () {},

            methods: {
                show() {
                    this.isShow = true;
                },

                hide() {
                    this.isShow = false;
                }
            },
            destroyed: function () {}
        };
        utils.asyncComponent(options, resolve, reject);
    };
    }(RongIM, null, RongIM.components));
    
