/**
 * 在邮件中验证成功 有server端发起
 */

(function (RongIM, dependencies) {
    'use strict';
    
    var $ = dependencies.jQuery;
    var RongIMClient = dependencies.RongIMClient;
    var RongIMLib = dependencies.RongIMLib;
    var Http = RongIM.dataModel._Http;
    var Cache = RongIM.dataModel._Cache;
    var ObserverList = RongIM.dataModel._ObserverList;
    
    var Bind = {
        observerList: new ObserverList()
    };
    var pinObserverList = Bind.observerList;
    
    Cache.Bind = {
        attach: {}
    };
    
    Bind.cleanCache = function () {
        Cache.Bind = {
            attach: {}
        };
    };
    
    Bind.loadApi = function () {
        userApi = RongIM.dataModel.User;
        utils = RongIM.utils;
    };
    
    Bind.registerMessage = function () {
    
        // 邮箱验证成功
        var messageName = 'BindEmailMessage';
        var objectName = 'RCE:EmailConfirm';
        var messageTag = new RongIMLib.MessageTag(false, false);
        var properties = ['staffUid'];
        RongIMClient.registerMessageType(messageName, objectName, messageTag, properties);
    };

    Bind.getUnReadCount = function (callback) {
        var url = '/pins/unreadcommentcount';
        Http.get(url)
            .then(function (result) {
                callback(null, result);
            }).fail(callback);
    };

    Bind.getUnConfirmCount = function (callback) {
        var url = '/pins/unconfirmedcount';
        Http.get(url)
            .then(function (result) {
                callback(null, result);
            }).fail(callback);
    };
    
    function notifyPin(message) {
        pinObserverList.notify(message);
    }
    
    Bind.messageCtrol = {
        BindEmailMessage: function (message) {
            notifyPin(message);
        },
    };
    
    Bind.watch = function (listener) {
        pinObserverList.add(listener);
    };
    
    Bind.unwatch = function (listener) {
        pinObserverList.remove(listener);
    };
    
    Bind.MessageType = {
        BindEmailMessage: 'BindEmailMessage'
    };
    
    RongIM.dataModel.Bind = Bind;
    }(RongIM, {
        win: window,
        jQuery: jQuery,
        UploadClient: UploadClient,
        RongIMClient: RongIMClient,
        RongIMLib: RongIMLib
    }));
    