/* 收藏 */
(function (RongIM) {
    'use strict';

    var Http = RongIM.dataModel._Http;
    var ObserverList = RongIM.dataModel._ObserverList;
    var Collect = {
        observerList: new ObserverList()
    };
    var collectObserverList = Collect.observerList;
    var userApi = RongIM.dataModel.User;
    var conversationApi = RongIM.dataModel.Conversation;
    var groupApi = RongIM.dataModel.Group;
    Collect.add = function (params, callback) {
        Http.post('/fav', params, function (errorcode, result) {
            if (errorcode) {
                callback(errorcode);
            }
            callback(errorcode, result);
            // collectObserverList.notify();
        }, true);
    };
    Collect.remove = function (uid, callback) {
        Http.del('/fav', { ids: [uid] }, function (errorcode, result) {
            if (errorcode) {
                callback(errorcode);
            }
            callback(errorcode, result);
        });
    };
    Collect.getList = function (params, callback) {
        Http.post('/fav/all', params, function (errorCode, result) {
            if (errorCode) {
                callback(errorCode);
                return;
            }
            var list = [];
            result.fav_contents.forEach(function (item) {
                var collect = {};
                var test = item.fav_content.content && JSON.parse(item.fav_content.content);
                collect.content = test;
                collect.messageType = reSetType(item.type);
                collect.messageName = reSetType(item.type);
                collect.messageUId = item.uid;
                collect.objectName = item.type;
                collect.sentTime = item.update_dt;
                collect.messageId = item.fav_content.content_id;
                collect.content_id = item.fav_content.content_id;
                collect.uid = item.uid;
                collect.targetId = item.fav_content.target_id;
                collect.sourceType = item.fav_content.source_type;
                collect.senderId = item.fav_content.sender_id;
                collect.user = {};
                if (+item.fav_content.source_type === 3) {
                    conversationApi.getOne(7, item.fav_content.sender_id, function (errorcode1, result1) {
                        if (!errorcode1) {
                            result1 = result1 || {};
                            collect.user = {
                                name: result1.user.name
                            };
                        }
                    });
                } else if (+item.fav_content.source_type === 1) {
                    groupApi.getOne(item.fav_content.target_id, function (errorcode, user) {
                        if (!errorcode) {
                            user = user || {};
                            collect.user = {
                                name: user.name
                            };
                        }
                    });
                } else {
                    userApi.get(item.fav_content.sender_id, function (errorcode, user) {
                        if (!errorcode) {
                            user = user || {};
                            collect.user = {
                                name: user.name
                            };
                        }
                    });
                }
                list.push(collect);
            });
            callback(errorCode, list);
        });
    };
    Collect.getIdList = function (params, callback) {
        Http.post('/fav/ids', params, function (errorCode, data) {
            if (errorCode || data.length === 0) {
                return;
            }
            var list = [];
            data.fav_contents.forEach(function (item) {
                var collect = {};
                var test = JSON.parse(item.fav_content.content);
                collect.content = test;
                collect.messageType = reSetType(item.type);
                collect.messageUId = item.uid;
                collect.objectName = item.type;
                collect.sentTime = item.update_dt;
                collect.messageId = item.fav_content.content_id;
                collect.content_id = item.fav_content.content_id;
                collect.uid = item.uid;
                collect.targetId = item.fav_content.target_id;
                collect.sourceType = item.fav_content.source_type;
                collect.senderId = item.fav_content.sender_id;
                collect.user = {};
                if (+item.fav_content.source_type === 3) {
                    conversationApi.getOne(7, item.fav_content.target_id, function (errorcode, result) {
                        if (!errorcode) {
                            result = result || {};
                            collect.user = {
                                name: result.user.name
                            };
                        }
                    });
                } else if (+item.fav_content.source_type === 1) {
                    groupApi.getOne(item.fav_content.target_id, function (errorcode, user) {
                        if (!errorcode) {
                            user = user || {};
                            collect.user = {
                                name: user.name
                            };
                        }
                    });
                } else {
                    userApi.get(item.fav_content.sender_id, function (errorcode, user) {
                        if (!errorcode) {
                            user = user || {};
                            collect.user = {
                                name: user.name
                            };
                        }
                    });
                }
                list.push(collect);
            });
            callback(errorCode, list);
        });
    };
    Collect.search = function (params, callback) {
        Http.post('/fav/search', params, function (errorcode, result) {
            var ids = result.map(function (item) {
                return item.uid;
            });
            callback(errorcode, ids);
        });
    };
    Collect.watch = function (listener) {
        collectObserverList.add(listener);
    };
    Collect.unwatch = function (listener) {
        collectObserverList.remove(listener);
    };
    Collect.typeList = [];
    function reSetType(type) {
        switch (type) {
            case 'RC:TxtMsg':
                type = 'TextMessage'; break;
            case 'RC:ImgMsg':
                type = 'ImageMessage'; break;
            case 'RC:VcMsg':
                type = 'VoiceMessage'; break;
            case 'RC:LBSMsg':
                type = 'LocationMessage'; break;
            /* case 'RC:ImgMsg' :
        type='SightMessage';break; */
            case 'RC:FileMsg':
                type = 'FileMessage'; break;
            case 'RC:ImgTextMsg':
                type = 'RichContentMessage'; break;
            case 'RC:SightMsg':
                type = 'SightMessage'; break;
            default:
                break;
        }
        return type;
    }
    RongIM.dataModel.Collect = Collect;
}(RongIM));
