function cast_ajax(url, method, data, callback) {
    if (method.toLowerCase() !== 'get') {
        data = $.isEmptyObject(data) ? null : JSON.stringify(data);
    }

    var options = {
        url: cast_getFullURL(url),
        method: method,
        data: data,
        xhrFields: {
            withCredentials: true
        },
        dataType: 'json'
    };

    if (method !== 'GET') {
        options.contentType = 'application/json;charset=UTF-8';
    }

    $.ajax(options).then(function (response) {
        var errorCode = getErrorCode(response.code);
        if (errorCode) {
            callback(errorCode, response);
        } else {
            var result = response.result;
            callback(null, result);
        }
    }, function () {
        callback('request-failed');
    });
}

function cast_getFullURL(path) {
    return "https://111.203.146.82/api" + path;
}

function cast_request(url, method, data, callback, fromServer) {
    callback = callback || $.noop;
    /*
    data is optional

    request(url, method, data, callback)
    request(url, method, callback)
    */
    if ($.isFunction(data)) {
        callback = data;
        data = null;
    }
    var defer = $.Deferred();
    // 从 server 获取数据
    cast_ajax(url, method, data, function (errorCode, result) {
        callback(errorCode, result);
        if (errorCode) {
            defer.reject(errorCode, result);
            return;
        }
        defer.resolve(result);
    });
    return defer.promise();
}

function cast_getServerRoot(callback) {
    cast_request("/user/login", "POST", {
        "username": "18611924492",
        "password": "123qwe",
        "agent": {
            "platform": "web",
            "device_id": "2cf37242d77ef009d3bff7"
        },
        "extra": "{\"loginType\":\"1\"}",
        "status": "online",
        "isRememberMe": false,
        "device_info": {
            "app_version": "1.6.9",
            "timezone": "UTC+08:00",
            "network": "WIFI"
        }
    }, function (loginErr, loginRes) {
        if (loginRes) {
            cast_request("/organization/root", "GET", null, function(rootErr, rootRes) {
                callback(rootRes, rootErr);
            });
        } else {
            callback(null, loginErr);
        }
    });
}
