(function (RongIM) {
'use strict';

function createFav(unReadCount) {
    var size = 32;
    var longer = 20;
    var canvas = document.createElement('canvas');
    canvas.width = size;
    canvas.height = size;

    var context = canvas.getContext('2d');

    // 绘制icon
    // context.drawImage(img, longer, 0, size, size);

    // 绘制红色圆
    var r;
    var x;
    var y;
    r = x = y = longer / 2;
    context.strokeStyle = '#f45349';
    context.fillStyle = '#f45349';
    context.beginPath();
    context.arc(x + 5, y + 5, r * 1.5, 0, Math.PI * 2, false);
    // arc(x, y, radius, startAngle, endAngle, anticlockwise)

    context.closePath();
    context.stroke();
    context.fill();

    // 绘制未读数
    var number = 0;
    if (unReadCount < 10) {
        number = ' ' + unReadCount;
    } else if (unReadCount < 100) {
        number = '' + unReadCount;
    } else {
        // number = '…';
        number = '⋯';
    }
    context.font = size * 0.6 + 'px Arial';
    context.textBaseline = 'top';

    context.fillStyle = '#ffffff';

    context.fillText(number, 5, 4);

    // 返回fav图标
    return canvas.toDataURL('image/png');
}

RongIM.updateFav = function (fav) {
    var im = RongIM.instance;
    var auth = im.auth;
    var normalUnReadCount = im.unReadCount;
    var pinUnReadCount = im.pinUnReadCount.unConfirm;
    var value = fav || normalUnReadCount + pinUnReadCount;
    var $fav = $('link[rel=icon]');
    var defaultValue = $fav.data('default-value') || $fav.attr('href');
    $fav.data('default-value', defaultValue);
    var href = value > 0 && auth ? createFav(value) : defaultValue;
    $fav.attr('href', href);
};
}(RongIM));
