(function (RongIM, dependencies, components) {
    'use strict';

    var common = RongIM.common;
    var utils = RongIM.utils;
    var pageNum = RongIM.config.profile.pageNum;

    /*
    说明：已经存在的群，群设置中移除群组成员
    参数：
        @param {sring}            targetId       群组 ID
        @param {boolean}            isTxz       是否为通讯组
        @param {Array}            txzMemberList   通讯组成员列表
        callback  回调函数
         
    */
    RongIM.dialog.groupRemoveMembers = function (targetId, isTxz, txzMemberList, callback) {
        var im = RongIM.instance;
        var options = {
            name: 'group-removemembers',
            template: 'templates/group/removemembers.html',
            data: function () {
                return {
                    show: true,
                    members: [],
                    showList: [],
                    keyword: '',
                    selected: [],
                    pageNum: pageNum,
                    currentPage: 1,
                    currentRemovePage: 1,
                    loadingNextPage: false,
                    loadingRemoveNextPage: false,
                    isPinGroup:isTxz,
                    userList:txzMemberList
                };
            },
            components: {
                avatar: components.getAvatar
            },
            mounted: function () {
                //如果是通讯组
                let that = this;
                if (isTxz) {
                    that.members = txzMemberList.filter(function (item /* , index, arr */ ) {
                        return item.id !== im.auth.id;
                    });
                    that.showList = that.members;
                } else {
                    this.getGroupMembers();
                }

            },
            computed: {
                filterList: function () {
                    var context = this;
                    var _list = context.showList;
                    var end = context.currentPage * context.pageNum;
                    return _list.slice(0, end);
                },
                selectedList: function () {
                    var context = this;
                    var _list = this.selected;
                    var end = context.currentRemovePage * context.pageNum;
                    return _list.slice(0, end);
                },
                checkedAll: {
                    get: function () {
                        return getCheckedAll(this);
                    },
                    set: function (value) {
                        setCheckedAll(this, value);
                    }
                },
                indeterminate: function () {
                    return (typeof this.checkedAll) !== 'boolean';
                }
            },
            watch: {
                keyword: function () {
                    this.showList = getFilterList(this);
                    $(this.$refs.list).scrollTop(0);
                    this.currentPage = 1;
                }
            },
            methods: getMethods(im, targetId,callback)
        };

        common.mountDialog(options);
    };

    /*
    功能： 根据搜索关键词以及群组成员，获取需要展示到面板上的成员列表
    说明： 如果搜索关键词为空，则直接返回群组所有成员列表，如果搜索关键词不为空，则筛选并返回满足条件的群组成员
    */
    function getFilterList(context) {
        var keyword = context.keyword;
        var filterList;
        if (utils.isEmpty(keyword)) {
            filterList = context.members;
        } else {
            filterList = context.members.filter(function (item) {
                var list = [item.name, item.alias];
                return utils.searchName(list, keyword);
            });
        }
        return filterList;
    }

    /*
    说明：获取是否 全选 群成员
    */
    function getCheckedAll(context) {
        var selected = [];
        var selectedIdList = context.selected.map(function (item) {
            return item.id;
        });
        context.filterList.forEach(function (item) {
            var existed = selectedIdList.indexOf(item.id) >= 0;
            if (existed) selected.push(item);
        });
        var length = selected.length;
        var result;
        if (length > 0) {
            var isAll = length === context.filterList.length;
            result = isAll ? true : null;
        } else {
            result = false;
        }
        return result;
    }

    /*
    说明：将全部群成员选中
    参数：
        @param {boolean}      value       是否全选
    */
    function setCheckedAll(context, value) {
        var _list = context.showList;
        if (value) {
            context.selected = [].concat(_list, context.selected);
        } else {
            context.selected = common.without(context.selected, _list);
        }
    }

    function getMethods(im, groupId,callback) {
        return {
            toastError: function (errorCode) {
                var el = null;
                if (this.$el) {
                    el = this.$el.firstChild;
                }
                common.toastError(errorCode, el);
            },
            getUsername: common.getUsername,
            getGroupMembers: function () {
                var params = {
                    groupId: groupId,
                    authId: im.auth.id
                };
                getGroupMembers(this, im.dataModel.Group, params);
            },
            remove: function (index) {
                this.selected.splice(index, 1);
            },
            clear: function () {
                this.keyword = null;
            },
            removeMembers: function () {
                if(this.isPinGroup){
                    if(this.showList.length == 1){
                        common.messagebox({
                            message: '通讯组人员不能少于1人',
                        });
                        return;
                    }
                    if(this.showList.length == this.selected.length){
                        common.messagebox({
                            message: '通讯组人员不能少于1人',
                        });
                        return;
                    }
                    callback(this.selected)
                    this.close();
                }else{
                    removeMembers(this, im.dataModel.Group, groupId);
                }
            },
            close: function () {
                this.show = false;
            },
            loadMoreOrigin: function () {
                loadMore(this);
            },
            loadMoreSelected: function () {
                loadMore(this, 'remove');
            }
        };
    }

    function loadMore(context, type) {
        var isLoading;
        var current;
        var list;
        if (type === 'remove') {
            isLoading = context.loadingRemoveNextPage;
            current = context.currentRemovePage;
            list = context.selected;
        } else {
            isLoading = context.loadingNextPage;
            current = context.currentPage;
            list = context.showList;
        }
        if (!isLoading) {
            var end = current * context.pageNum;
            if (list && list.length > end) {
                if (type === 'remove') {
                    context.loadingRemoveNextPage = true;
                    setTimeout(function () {
                        context.currentRemovePage += 1;
                        context.loadingRemoveNextPage = false;
                    }, 200);
                } else {
                    context.loadingNextPage = true;
                    setTimeout(function () {
                        context.currentPage += 1;
                        context.loadingNextPage = false;
                    }, 200);
                }
            }
        }
    }

    /*
    说明：获取 群组成员的数组列表
    参数：
        @param {object}      params     (groupId、 authId) 群组 ID、 用户 ID
    */
    function getGroupMembers(context, groupApi, params) {
        groupApi.getAllMembers(params.groupId, function (errorCode, members) {
            if (errorCode) {
                context.toastError(errorCode);
                return;
            }
            context.members = members.filter(function (item /* , index, arr */ ) {
                return item.id !== params.authId;
            });
            context.showList = context.members;
        });
    }

    // function selectAll(val, context) {
    //     var arrSelect = [];
    //     var arrMembers = $.extend(true, [], context.members);
    //     arrMembers.forEach(function (member, index, arr) {
    //         if(val){
    //             arrSelect.push(member.id);
    //         }
    //     });
    //     context.selected = arrSelect;
    //     context.members = arrMembers;
    //     context.isSelectAll = val;
    // }

    /*
    说明：确定移除群组中已选择的成员
    参数：
        @param {string}      groupId       群组 ID
    */
    function removeMembers(context, groupApi, groupId) {
        if (context.selected.length < 1) {
            common.messagebox({
                message: context.locale.selectNone
            });
            return;
        }
        var memberIdList = context.selected.map(function (item) {
            return item.id;
        });
        groupApi.removeMembers(groupId, memberIdList, function (errorCode) {
            if (errorCode) {
                context.toastError(errorCode);
                return;
            }
            context.close();
        });
    }
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));