(function (RongIM, dependencies, components) {
'use strict';

var utils = RongIM.utils;

/*
说明： 图片加载器 默认显示 default slot 图片加载成功显示 success slot
*/
components.getImageLoader = function (resolve, reject) {
    var options = {
        name: 'portrait-loader',
        template: '#rong-template-image-loader',
        props: ['url'],
        data: function () {
            return {
                success: false
            };
        },
        watch: {
            url: {
                handler: function (newVal) {
                    var context = this;
                    if (!newVal) {
                        context.success = false;
                        return;
                    }
                    var img = new Image();
                    img.onload = function () {
                        context.success = true;
                    };
                    img.onerror = function () {
                        context.success = false;
                    };
                    img.src = context.url;
                },
                immediate: true
            }
        }
    };
    utils.asyncComponent(options, resolve, reject);
};
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));
