/*
说明：文件消息
功能：
    1. 消息列表中的文件消息
    2. 历史消息中的文件消息
*/
(function (RongIM, dependencies, components) {
    'use strict';

    var common = RongIM.common;
    var utils = RongIM.utils;
    var moment = dependencies.moment;
    var dialog = RongIM.dialog;
    var $ = dependencies.jQuery;
    // var uploadKeyTmp = 'rong-upload-default-{{path}}-{{size}}-{{modifytime}}-{{uploadid}}';
    var keyNS = 'rong-upload-';
    var uploadKeyTmp = '{{0}}-{{1}}-{{2}}-{{3}}';
    var fileApi = RongIM.dataModel.File;
    var debounceResume = utils.debounce(resumeUpload, 300);
    var debounceDownload = utils.debounce(download, 300);

    components.getFileMessage = function (resolve, reject) {
        var im = RongIM.instance;
        var options = {
            name: 'file-message',
            props: ['message', 'keyword', 'collect', 'sendCollect'],
            template: '#rong-template-file',
            data: function () {
                return {
                    size: 0,
                    filename: '',
                    basename: '',
                    extname: '',
                    extnameWidth: 0,
                    sentStatus: utils.sentStatus,
                    downloadStatus: '',
                    downloadProgress: 0,
                    fileTimer: null,
                    showMeu: false
                };
            },
            computed: {
                support: function () {
                    return im.config.support;
                },
                canceled: function () {
                    return this.message.content.status === 0;
                },
                fileUrl: function () {
                    var str = this.message.content.fileUrl;
                    return common.encodeUrl(str);
                },
                isUpload: function () {
                    // console.log('todo: 此处判断应改进');
                    // 用来判断当前是下载还是上传
                    // 产品需求,只有接收的文件下载才显示已接收
                    return this.message.messageType === RongIMClient.MessageType.LocalFileMessage || this.message.messageDirection === RongIMLib.MessageDirection.SEND;
                },
                isOverLength: function () {
                    var stateLen = utils.getLength(this.fileState);
                    if (this.size.length > 8 && stateLen > 5) {
                        return true;
                    }
                    return false;
                },
                fileState: function () {
                    var state = '';
                    var message = this.message;
                    if (this.isUpload) {
                        switch (message.uploadStatus) {
                            case utils.uploadStatus.READY:
                                break;
                            case utils.uploadStatus.UPLOADING:
                                state = this.locale.sendingState;
                                break;
                            case utils.uploadStatus.SUCCESS:
                                if (message.messageDirection === RongIMLib.MessageDirection.SEND) {
                                    state = this.locale.sentState;
                                }
                                break;
                            case utils.uploadStatus.FAIL:
                                state = this.locale.cancelState;
                                break;
                            case utils.uploadStatus.CANCELLED:
                                state = this.locale.cancelState;
                                break;
                            // 失效  24小时内不操作继续发送，则该文件发送状态置为已失效
                            case utils.uploadStatus.EXPIRED:
                                state = this.locale.expiredState;
                                break;
                            default:
                                state = this.locale.sentState;
                                break;
                        }
                        return state;
                    }
                    switch (this.downloadStatus) {
                        case 'READY':
                            break;
                        case 'DOWNLOADING':
                            state = this.locale.downloadState;
                            break;
                        case 'DOWNLOADED':
                            if (message.messageDirection === RongIMLib.MessageDirection.RECEIVE) {
                                state = this.locale.receiveState;
                            }
                            break;
                        case 'CANCELLED':
                            state = this.locale.cancelState;
                            break;
                        default:
                            $.noop();
                            break;
                    }
                    return state;
                },
                status: function () {
                    return im.status;
                },
                isWeb: function () {
                    var platform = utils.getPlatform();
                    console.log("platform======>", platform);
                    var isWeb = platform.indexOf('web') !== -1;
                    console.log("isWeb=======>", isWeb);
                    return isWeb;
                }
            },
            watch: {
                'message.uploadStatus': function (newValue) {
                    var message = this.message;
                    message.uploadStatus = newValue;
                    if (newValue === utils.uploadStatus.SUCCESS && this.downloadStatus !== 'DOWNLOADED') {
                        this.downloadStatus = 'READY';
                    }
                    if (this.isWeb) {
                        if (newValue === utils.uploadStatus.UPLOADING) {
                            message.content.status = 1;
                        } else if (newValue === RongIM.utils.uploadStatus.SUCCESS) {
                            message.content.status = null;
                        } else {
                            message.content.status = 0;
                            message.sentStatus = -1;
                        }
                        return;
                    }
                    var fileTimer = this.fileTimer;
                    if (fileTimer) clearInterval(fileTimer);
                    if (newValue === utils.uploadStatus.UPLOADING) {
                        this.watchFile();
                        message.content.status = 1;
                        // 更新会话列表中消息发送状态
                        // im.$emit('uploadStatusChange', message, 1);
                    } else if (newValue === RongIM.utils.uploadStatus.SUCCESS) {
                        message.content.status = null;
                    } else {
                        message.content.status = 0;
                        // im.$emit('uploadStatusChange', message, 0);
                    }
                },
                status: function (newValue) {
                    var isConnect = newValue === utils.status.CONNECTED;
                    var isUploading = this.message.uploadStatus === utils.uploadStatus.UPLOADING;
                    if (!isConnect && isUploading) {
                        this.cancelUpload();
                    }
                }
                // 断网恢复时保证能继续发送
                /* status: function(newValue) {
                    var message = this.message;
                    var isUploading = message.uploadStatus === utils.uploadStatus.UPLOADING;
                    var isSuspend = message.isSuspend;
                    var isConnect = newValue === utils.status.CONNECTED;
    
                    if(!isConnect && isUploading){
                        this.suspendUpload();
                        this.message.isSuspend = true;
                        return;
                    }
                    if(isConnect && isSuspend){
                        // 继续发送
                        this.resumeUpload(message);
                    }
                } */
            },
            created: function () {
                created(this);
            },
            // 正在上传或正在下载的状态做记录,切换会话时能继续保持原来的状态
            destroyed: function () {
                var fileTimer = this.fileTimer;
                if (fileTimer) clearInterval(fileTimer);
            },
            methods: {
                getUsername: common.getUsername,
                clipboard: function (text, event) {
                    let that = this;
                    const clipboard = new ClipboardJS(event.target, {
                        text: () => text
                    })
                    clipboard.on('success', (e) => {
                        clipboard.destroy()
                        common.messageToast({
                            type: 'success',
                            message: that.locale.copyFileUrl.success
                        });
                    })
                    clipboard.on('error', (e) => {
                        clipboard.destroy()
                        common.messageToast({
                            type: 'error',
                            message: that.locale.copyFileUrl.error
                        });
                    })
                    clipboard.onClick(event)
                },

                // click copy content
                copyFileUrl: function (url, event, message) {
                    // let code = utils.encryptCode(url);
                    // url = "https://work.cast.org.cn/modules/redirect.html?down=" + encodeURIComponent(code) + '&type=' + message.content.type;
                    // // url = "http://localhost/redirect.html?down=" + encodeURIComponent(code) + '&type=' + message.content.type
                    // this.clipboard(url, event);
                    let code = utils.encryptCode(url);
                    // url = "https://work.cast.org.cn/modules/redirect.html?down=" + encodeURIComponent(code)
                    this.clipboard(url, event);
                },
                dateFormat: function (timestamp, format) {
                    return moment(timestamp).format(format);
                },
                highlight: function (text) {
                    var str = common.highlight(text, this.keyword);
                    return common.filterMark(str);
                },
                getFileIconClass: function (message) {
                    var isExpired = message.uploadStatus === utils.uploadStatus.EXPIRED;
                    var prefix = 'rong-file-';
                    var suffix = '';
                    if (isExpired) {
                        suffix = '-expired';
                    }
                    return prefix + message.content.type + suffix;
                },
                pauseDownload: function () {
                    if (this.downloader) {
                        this.downloadStatus = 'CANCELLED';
                        this.downloader.pause();
                    }
                },
                resumeDownload: function () {
                    if (this.downloader) {
                        this.downloadStatus = 'DOWNLOADING';
                        this.downloader.resume();
                    } else {
                        this.download(this.message, true);
                    }
                },
                isSupportOpenFile: function () {
                    // 正在下载中的文件,不应该做处理
                    var support = this.support.openFile;
                    var isDownloaded = this.downloadStatus === 'DOWNLOADED';
                    if (support && (isDownloaded || this.isUpload)) {
                        return true;
                    }
                    return false;
                },
                openFile: function () {
                    var file = RongIM.file;
                    var localPath = this.message.content.localPath;
                    var fileExist = file.checkExist(localPath);
                    if (localPath && fileExist) {
                        file.open(localPath);
                    } else {
                        this.downloadStatus = 'READY';
                        if (this.message.messageDirection === RongIMLib.MessageDirection.RECEIVE) {
                            this.download(this.message);
                        } else {
                            common.toastError('file-404');
                        }
                    }
                },
                /*
                上传成功后显示,无论源文件是否删除
                下载成功后,如果文件存在则显示,否则显示下载按钮
                */
                isShowOpenFolder: function (message) {
                    var isDownloadOver = this.downloadStatus === 'DOWNLOADED';
                    var isUploadOver = message.uploadStatus === utils.uploadStatus.SUCCESS || message.messageDirection === RongIMLib.MessageDirection.SEND;
                    var isExpired = message.uploadStatus === utils.uploadStatus.EXPIRED;
                    var file = RongIM.file;
                    var localPath = message.content.localPath;
                    // console.log("localPath", localPath);
                    var fileExist = file.checkExist(localPath);
                    console.log("fileExist", fileExist);
                    // return 条件去掉fileExist
                    return this.support.openFolder && !isExpired && (isDownloadOver || isUploadOver);
                    // return isUploadOver && !isExpired || this.support.openFolder && fileExist && isDownloadOver;
                },
                openFolder: function () {
                    var file = RongIM.file;
                    var localPath = this.message.content.localPath;
                    var fileExist = file.checkExist(localPath);
                    if (localPath && fileExist) {
                        file.openDir(localPath);
                    } else {
                        common.toastError('file-404');
                        this.downloadStatus = 'READY';
                    }
                },
                isSupportDownload: function () {
                    var file = RongIM.file;
                    var message = this.message;
                    var localPath = message.content.localPath;
                    var fileExist = file.checkExist(localPath);
                    // 正在下载中的文件,不应该做处理    
                    var isUploadOver = message.uploadStatus === utils.uploadStatus.SUCCESS || message.messageDirection === RongIMLib.MessageDirection.SEND;
                    var isDownloading = this.downloadStatus === 'DOWNLOADING';
                    var isCanceled = this.downloadStatus === 'CANCELLED';
                    var isDownloaded = this.downloadStatus === 'DOWNLOADED';
                    if (isDownloading || isCanceled || (isUploadOver && fileExist) || (isDownloaded && fileExist)) {
                        return false;
                    }
                    return true;
                },
                // 新增判断路径下是否已有该文件 
                download: function (message, isResume) {
                    //替换字符串中的所有特殊字符（包含空格）
                    if (message.content.name != "") {
                        var re = /[\u4e00-\u9fa5A-Za-z0-9`~!@#$%^&*()_\-+=<>?:"{}|,.\/;'\\[\]·~！@#￥%……&*（）——\-+={}|《》？:，。‘“’”【】]/g;
                        message.content.name = Array.from(message.content.name.match(re)).join('')
                    }
                    // if (message.content.localPath != "") {
                    //     var re = /[\u4e00-\u9fa5A-Za-z0-9`~!@#$%^&*()_\-+=<>?:"{}|,.\/;'\\[\]·~！@#￥%……&*（）——\-+={}|《》？:，。‘“’”【】]/g;
                    //     message.content.localPath = Array.from(message.content.localPath.match(re)).join('')
                    // }
                    let locaPath = RongIM.downloader.getSaveFolder();
                    if (!locaPath) {
                        debounceDownload(message, isResume, this);
                        return
                    };

                    RongIM.downloader.doesItExistLocaPath(locaPath).then((res) => {
                        let isFile = RongIM.downloader.getFileList(locaPath).some((item) => {
                            return message.content.name == item;
                        })
                        if (isFile) {
                            this.repeatFile(locaPath, message);
                        } else {
                            debounceDownload(message, isResume, this);
                        }

                    }).catch(err => {
                        RongIM.downloader.removeSaveFolder();
                        debounceDownload(message, isResume, this);
                    })
                },

                // 重复文件处理
                repeatFile(locaPath, message, isResume) {
                    let index = message.content.name.lastIndexOf(".");
                    for (let i = 1; i < RongIM.downloader.getFileList(locaPath).length; i++) {
                        if (RongIM.downloader.getFileList(locaPath).indexOf(this.insertStr(message.content.name, index, "(" + i + ")")) == -1) {
                            let name = this.insertStr(message.content.name, index, "(" + i + ")");
                            i = RongIM.downloader.getFileList(locaPath).length;
                            message.content.name = name;
                        }
                    }
                    debounceDownload(message, isResume, this);
                    common.messageToast({
                        message: "文件保存为" + message.content.name,
                        type: 'success'
                    });
                },

                /**
                 * 字符串指定位置插入
                 * @param {String} soure  原字符串
                 * @param {Number} start  将要插入得位置
                 * @param {String} newStr 要插入的字符
                 */
                insertStr(soure, start, newStr) {
                    return soure.slice(0, start) + newStr + soure.slice(start);
                },

                isUploading: function () {
                    return this.message.uploadStatus === utils.uploadStatus.UPLOADING;
                },
                isCancelUpload: function () {
                    var isCanceled = this.message.uploadStatus === utils.uploadStatus.CANCELLED;
                    var isFailed = this.message.uploadStatus === utils.uploadStatus.FAIL;
                    return isCanceled || isFailed;
                },
                suspendUpload: function () {
                    var message = this.message;
                    message.suspend(function (errorCode) {
                        if (errorCode) {
                            common.toastError(errorCode);
                        }
                    });
                },
                // 取消上传
                cancelUpload: function () {
                    var context = this;
                    var message = this.message;
                    // 第一次上传需要插入消息;后面续传不需要
                    message.cancel(function (errorCode) {
                        if (errorCode) {
                            common.toastError(errorCode);
                            return;
                        }
                        context.message.uploadStatus = utils.uploadStatus.CANCELLED;
                    });
                },
                resumeUpload: function (message) {
                    /* if(message.uploadStatus === utils.uploadStatus.UPLOADING){
                        return;
                    } */
                    debounceResume(message);
                },
                // 上传过程中监控上传中的文件是否有变动,有则提示
                watchFile: function () {
                    var fileInstanse = this;
                    var file = RongIM.file;
                    var fileTimer = fileInstanse.fileTimer;
                    // fileTimer && clearInterval(fileTimer);
                    // TODO: Interval 风险，需替换算法
                    fileTimer = setInterval(function () {
                        if (fileInstanse.message.uploadStatus === utils.uploadStatus.SUCCESS) {
                            clearInterval(fileTimer);
                            return;
                        }
                        var localPath = fileInstanse.message.content.localPath;
                        var fileExist = file.checkExist(localPath);
                        if (!fileExist) {
                            // fileInstanse.suspendUpload();
                            // fileInstanse.message.uploadStatus = utils.uploadStatus.EXPIRED;
                            fileInstanse.cancelUpload();
                            clearInterval(fileTimer);
                            common.toastError('file-404');
                        }
                    }, 6000);
                },
                dblClick: function () {
                    if (this.isSupportOpenFile()) {
                        this.openFile();
                    }
                }
            }
        };
        utils.asyncComponent(options, resolve, reject);
    };

    function attachDownloadEvents(downloader, context) {
        var message = context.message;

        // 下载准备完毕
        downloader.onReady = function () {
            fileApi.downloadManage.add(message.messageUId, downloader);
            context.downloader = downloader;
        };

        // 下载中,返回下载进度
        downloader.onProgress = function (data) {
            context.downloadStatus = 'DOWNLOADING';
            context.downloadProgress = (data.loaded / data.total) * 100;
        };

        // 下载完成
        downloader.onComplete = function (data) {
            fileApi.downloadManage.remove(message.messageUId);
            context.downloader = null;

            context.downloadStatus = 'DOWNLOADED';
            if (!data.path) {
                return;
            }
            if (message.content) {
                message.content.localPath = data.path;
                var rongInstance = RongIMClient.getInstance();
                var messageId;
                if (context.collect) {
                    RongIM.dataModel.Message.getOne(message.messageId, function (errorCode, result) {
                        messageId = result.messageId;
                    });
                } else {
                    messageId = message.messageId;
                }
                var content = message.content;
                rongInstance.setMessageContent(messageId, content, '');
            }
            context.downloadProgress = 0;
            var isFolder = message.content.isFolder || false;
            if (isFolder) {
                var config = { src: data.path };
                RongIM.file.unzip(config, function (err, info) {
                    console.debug(err, info);
                });
            }
        };

        downloader.onError = function (error) {
            fileApi.downloadManage.remove(message.messageUId);
            context.downloader = null;
            console.warn('download-error', error);
            var errorCode = ['ebusy', 'eperm'].indexOf(error) > -1 ? error : 'error';
            // common.toastError('download-' + errorCode);
            console.log('download-' + errorCode);
            common.toastError('download-overdue');
            if (context.downloadProgress === 0) {
                context.downloadStatus = 'READY';
            } else {
                context.downloadStatus = 'CANCELLED';
            }
        };

        downloader.onCancel = function () {
            context.downloadStatus = 'READY';
        };
    }

    function created(context) {
        // var im = RongIM.instance;
        var message = context.message;

        context.size = size(context.message);
        context.filename = context.message.content.name;
        var index = context.filename.lastIndexOf('.');
        var extname = '';
        if (index > -1) {
            // 扩展名前多显示2个字
            var prefix = 0;
            var chPatrn = /[\u4E00-\u9FA5]|[\uFE30-\uFFA0]|[\u0391-\uFFE5]/gi;
            extname = context.filename.slice(Math.max(0, index - prefix));
            extname = chPatrn.exec(extname) ? extname.substring(1) : extname;
        }
        context.extname = utils.encodeHtmlStr(extname);

        var end = 0 - context.extname.length;
        if (end === 0) {
            end = context.filename.length;
        }
        var basename = context.filename.slice(0, end);
        context.basename = utils.encodeHtmlStr(basename);

        context.extnameWidth = common.getTextRenderWidth(context.extname, 14);

        var localPath = message.content.localPath;
        var fileExist = RongIM.file.checkExist(localPath);
        var isUpload = utils.isEmpty(message.content.fileUrl);
        if (isUpload) {
            if (!context.isWeb && fileExist) {
                initUploadState(message);
                if (message.uploadStatus === utils.uploadStatus.UPLOADING) {
                    context.watchFile();
                }
                return;
            }
            var uploader = fileApi.uploadManage.get(message.content.uploadId);
            message.uploadStatus = uploader ? uploader.uploadStatus : utils.uploadStatus.CANCELLED;
            return;
        }

        initDownloadState(context, message);
    }

    /*
        1. 判断文件是否存在,不存在则返回(如果改名,此步已过滤掉)
        2. localPath + size + lastModified + uploadId
    */
    function initUploadState(message) {
        var fileState;
        var localPath = message.content.localPath;
        var uploadId = message.content.uploadId;
        // 发送成功的消息
        if (!uploadId) {
            return;
        }
        // 本地路径已失效
        if (!RongIM.file.checkExist(localPath)) {
            // message.uploadStatus = utils.uploadStatus.SUCCESS;
            return;
        }
        var config = RongIM.config.upload.file;
        var fileInfo = RongIM.file.getFileStat(localPath);
        var key = utils.templateFormat(uploadKeyTmp, localPath, fileInfo.size, +fileInfo.mtime, uploadId);
        key = keyNS + RongIMLib.RongUtil.MD5(key).slice(8, 16);
        // key = keyNS + key;
        fileState = RongIM.upload.getItem(key) || {};
        if ($.isEmptyObject(fileState)) {
            var uploadExpired = message.messageType === RongIMClient.MessageType.LocalFileMessage || !message.messageId;
            uploadExpired = uploadExpired && message.uploadStatus !== utils.uploadStatus.UPLOADING;
            if (uploadExpired) {
                message.uploadStatus = utils.uploadStatus.CANCELLED;
            }
            return;
        }
        try {
            fileState = JSON.parse(fileState);
        } catch (ex) {
            fileState = {};
        }
        fileState = fileState || {};
        // 判断文件超过24小时未操作则失效
        if (fileState.updateTime) {
            var nowDate = new Date().getTime();
            var span = nowDate - fileState.updateTime;
            span /= (1000 * 3600);
            var validity = config.validity || 0;
            if (validity > 0 && span > validity) {
                // RongIM.upload.removeItem(key); //过期暂不删除,否则无法区分是取消时无记录还是过期了
                message.uploadStatus = utils.uploadStatus.EXPIRED;
                return;
            }
        }
        fileState = fileState.data || {};
        var isUploading = fileApi.uploadManage.get(uploadId);
        message.uploadStatus = isUploading ? utils.uploadStatus.UPLOADING : utils.uploadStatus.CANCELLED;
        message.progress = Math.floor(fileState.offset / fileInfo.size * 100);
        message.content.size = fileInfo.size;
        message.content.uniqueName = fileState.sessionId;
    }

    function initDownloadState(fileInstance, message) {
        var localPath = message.content.localPath;
        var uploadDone = message.uploadStatus === utils.uploadStatus.SUCCESS;
        var isDownload = utils.isEmpty(message.uploadStatus) || uploadDone;
        var downloadStatus = '';
        if (message.content.status === 0) {
            // 已取消
        } else if (getFileExists(localPath)) {
            downloadStatus = 'DOWNLOADED';
        } else if (isDownload) {
            downloadStatus = 'READY';
        }
        fileInstance.downloadStatus = downloadStatus;
        var isWeb = fileInstance.isWeb;
        if (isWeb) {
            return;
        }

        var fileState = RongIM.downloader.getProgress(message.messageUId);
        if (!$.isEmptyObject(fileState)) {
            fileInstance.downloadStatus = 'CANCELLED';
            fileInstance.downloadProgress = (fileState.offset / message.content.size) * 100;
            var downloader = fileApi.downloadManage.get(message.messageUId);
            if (downloader) {
                fileInstance.downloadProgress = (downloader.stats.offset / message.content.size) * 100;
                attachDownloadEvents(downloader, fileInstance);
                fileInstance.downloader = downloader;
                if (!downloader.isPause) {
                    fileInstance.downloadStatus = 'DOWNLOADING';
                }
            }
        }
    }

    function getFileExists(fileUrl) {
        var file = RongIM.file;
        var existed = false;
        if (!utils.isEmpty(fileUrl)) {
            existed = file.checkExist(fileUrl);
        }
        return existed;
    }

    function size(message) {
        var filesize = Number(message.content.size) || 0;
        var sizeStr = '';
        var unit = 1024;
        var G = Math.pow(unit, 3);
        var M = Math.pow(unit, 2);
        var K = Math.pow(unit, 1);
        if (filesize > G) {
            sizeStr = (filesize / G).toFixed(2) + ' GB';
        } else if (filesize > M) {
            sizeStr = (filesize / M).toFixed(2) + ' MB';
        } else if (filesize > K) {
            sizeStr = (filesize / K).toFixed(2) + ' KB';
        } else {
            sizeStr = filesize + ' B';
        }
        return sizeStr;
    }

    function checkExist(message) {
        var file = RongIM.file;
        var localPath = message.content.localPath;
        var fileExist = file.checkExist(localPath);
        if (!fileExist) {
            // message.uploadStatus = utils.uploadStatus.EXPIRED;
            common.toastError('file-404');
            return false;
        }
        return true;
    }

    function resumeUpload(uploadMessage) {
        if (!checkExist(uploadMessage)) {
            return;
        }
        var im = RongIM.instance;
        uploadMessage.dataType = RongIMLib.FileType.FILE;
        var filePath = uploadMessage.content.localPath;
        var fileSize = uploadMessage.content.size;
        var resume = function (reUploadMessage) {
            fileApi.resumeUpload(reUploadMessage, im.config.upload.file, function (errorCode, _uploadMessage, data) {
                if (errorCode) {
                    common.messageToast({
                        type: 'error',
                        message: im.locale.components.addAttachment.uploadFaild
                    });
                    return;
                }
                fileApi.addFileUrl(_uploadMessage, data, function (error, sendUploadMessage) {
                    fileApi.send(sendUploadMessage, function (err, message) {
                        if (err) {
                            var errMsg = common.getErrorMessage('lib-' + err);
                            console.warn('fileApi.resumeUpload', errMsg, message);
                        }
                        im.$emit('sendMessage');
                    });
                });
            });
        };
        // uploadMessage.data = uploadMessage.data || RongIM.file.getBlobs([filePath])[0];
        /*
            fetchType === 0 通过 nodejs 获取文件对象. 优点: 速度快 缺点: 文件大小有限制,具体参考 https://cnodejs.org/topic/56499568d28aa64101600fdc
            fetchType === 1 通过 XMLHttpRequest 获取文件对象. 优点: 不限制文件大小 缺点: 文件加载比较慢
         */
        var fetchType = 0;
        if (fileSize > 500 * 1024 * 1024) {
            fetchType = 1;
        }

        if (!uploadMessage.data) {
            if (fetchType === 1) {
                RongIM.file.getBlob(filePath).then(function (file) {
                    uploadMessage.uploadStatus = utils.uploadStatus.READY;
                    uploadMessage.data = file;
                    resume(uploadMessage);
                }, function (err) {
                    common.toastError('file-error');
                    console.warn('RongIM.file.getBlob error', err);
                });
                uploadMessage.uploadStatus = utils.uploadStatus.UPLOADING;
                uploadMessage.sentStatus = utils.sentStatus.SENDING;
                return;
            }
            uploadMessage.data = RongIM.file.getBlobs([filePath])[0];
        }
        resume(uploadMessage);
    }

    function download(message, isContinue, instance) {
        var context = instance;
        fileApi.getFileDownloadToken(function (error, token) {
            if (error) {
                common.toastError('download-error');
                return;
            }
            var url = message.content.fileUrl;
            if (url.indexOf('?') !== -1) {
                url += '&token=' + token;
            } else {
                url += '?token=' + token;
            }
            var file = {
                uId: message.messageUId,
                url: url,
                name: message.content.name,
                size: message.content.size
            };
            var downloader = RongIM.downloader.load(file);
            attachDownloadEvents(downloader, context);
            context.downloadStatus = 'DOWNLOADING';
            if (isContinue) {
                downloader.continue(message);
                return;
            }
            downloader.saveAs();
            console.log('---------结束了-------------------');
        });
    }
}(RongIM, {
    moment: moment,
    jQuery: jQuery
}, RongIM.components));
