(function (RongIM, components) {
'use strict';

var utils = RongIM.utils;
var Base64Util = utils.Base64;

components.getQuoteImage = function (resolve, reject) {
    var options = {
        name: 'quote-image-message',
        props: ['message'],
        data: function () {
            return {
                isGif: false
            };
        },
        template: '#rong-template-quote-image',
        computed: {
            base64: function () {
                var imageMsg = this.message.content.content;
                var content = imageMsg.content;
                return Base64Util.concat(content);
            }
        },
        methods: {
            showImage: function () {
                this.$emit('showImage');
            }
        },
        mounted: function () {
            var url = this.message.content.content.imageUri;
            var isGif = (/.*\.gif$/i).test(url);
            if (isGif) {
                this.isGif = true;
            }
        }
    };
    utils.asyncComponent(options, resolve, reject);
};
}(RongIM, RongIM.components));
