(function (RongIM, dependencies, components) {
'use strict';

var utils = RongIM.utils;
var Base64Util = utils.Base64;

components.getSightMessage = function (resolve, reject) {
    // var dataModel = im.dataModel;
    var options = {
        name: 'sight-message',
        props: ['message'],
        template: '#rong-template-sight',
        data: function () {
            return {
                downloading: false,
                uploading: false,
                progress: 0
            };
        },
        computed: {
            base64: function () {
                var sightMessage = this.message.content;
                var content = sightMessage.content;
                return Base64Util.concat(content);
            },
            path: function () {
                var percent = (this.progress || 0) / 100;
                if (percent === 1) {
                    percent = 0.99;
                }
                var r = 18;
                var degrees = percent * 360;
                var rad = degrees * (Math.PI / 180);
                var x = (Math.sin(rad) * r).toFixed(2);
                var y = -(Math.cos(rad) * r).toFixed(2);
                var lenghty = window.Number(degrees > 180);
                var a = ['M', 0, -r, 'A', r, r, 0, lenghty];
                var b = [1, x, y, 'L', 0, 0, 'Z'];
                var path = a.concat(b);
                path = path.join(' ');
                return path;
            },
            seconds: function () {
                return secondsToTime(this.message.content.duration);
            }
        },
        watch: {
            'message.progress': function (newValue) {
                this.uploading = newValue < 100;
                this.progress = newValue;
            }
        },
        methods: {
            play: function () {
                if (this.downloading) {
                    return;
                }
                this.$emit('showSight', this.message);
            }
        }
    };
    utils.asyncComponent(options, resolve, reject);
};

function secondsToTime(seconds) {
    var hours = Math.floor(seconds / (60 * 60));
    seconds -= hours * (60 * 60);
    var minutes = Math.floor(seconds / 60);
    seconds -= minutes * 60;
    var result = hours > 0 ? hours + ':' : '';
    result += minutes + ':' + (seconds > 9 ? seconds : '0' + seconds);
    return result;
}
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));
