(function (RongIM, dependencies, components) {
'use strict';

var common = RongIM.common;
var cache = RongIM.utils.cache;

RongIM.dialog.setPassword = function () {
    var im = RongIM.instance;
    var options = {
        name: 'set-password',
        template: 'templates/set-password.html',
        data: function () {
            return {
                show: true,
                busy: false,
                password: '',
                confirmPassword: ''
            };
        },
        mixins: [
            components.getValidate()
        ],
        computed: {
            language: function () {
                var language = this.locale.name;
                return language.toLowerCase();
            }
        },
        methods: {
            isError: function () {
                var errors = this.errors;
                return (errors.confirmPassword || errors.password);
            },
            close: function () {
                this.show = false;
            },
            submit: function () {
                var context = this;
                var userApi = im.dataModel.User;
                if (context.busy || !context.valid()) {
                    return;
                }
                var oldPassword = cache.get('auth-password');
                var params = {
                    newPassword: this.password,
                    oldPassword: oldPassword
                };
                context.busy = true;
                // 2019-06-12 密码加密传输 userApi.changePassword 改为 securityChangePassword
                userApi.securityChangePassword(params, function (errorCode) {
                    context.busy = false;
                    if (errorCode) {
                        common.handleError(errorCode);
                        return;
                    }
                    cache.remove('auth-password');
                    context.close();
                    im.auth.isModifyPwd = false;
                });
            }
        }
    };
    common.mountDialog(options);
};
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));
