/*
说明：设置 - 内容页(系统)
功能：
    1. 查看版本信息
    2. 查看版本功能介绍
*/
(function (RongIM, components) {
'use strict';

var utils = RongIM.utils;
var common = RongIM.common;
var Http = RongIM.dataModel._Http;
var browserWindow = RongIM.browserWindow;
var versionCode = RongIM.config.product.version;
components.getSettingAbout = function (resolve, reject) {
    var im = RongIM.instance;
    var options = {
        name: 'setting-about',
        template: '#rong-template-about',
        data: function () {
            return {
                showVersion: false, // im.config.modules.upgrade,
                product: im.locale.product || {},
                release_note:[]
            };
        },
        mounted: function () {
            this.getSjTips(versionCode)
        },
        methods: {
            showVersions: function () {
                browserWindow.openVersions();
            },
            // 查询升级内容
            getSjTips:function (version) {
                var params = { platform:'windows', version }
                const that = this
                Http.get(`/appversion/getSjTips`, params, function (errorCode, result) {
                    if (errorCode && errorCode != 10000) {
                        // common.messageToast({
                        //     message: '查询失败',
                        //     type: 'error'
                        // });
                    }
                    if (result){
                        that.release_note = result.release_note.split('。').slice(0, -1)
                    }
                })
            }

        }
    };
    utils.asyncComponent(options, resolve, reject);
};

}(RongIM, RongIM.components));
