(function (RongIM, dependencies, components) {
'use strict';

var utils = RongIM.utils;
var common = RongIM.common;

components.getStatus = function (resolve, reject) {
    var options = {
        name: 'status',
        template: '#rong-template-status',
        props: ['code'],
        computed: {
            error: function () {
                var locale = this.locale;
                if (this.connected) {
                    return undefined;
                }
                var defaultMessage = locale.netErr;
                var errorKey = 'status-' + this.code;
                var errorMessage = common.getErrorMessage(errorKey, defaultMessage);
                return errorMessage;
            },
            connected: function () {
                return this.code === utils.status.CONNECTED;
            },
            connecting: function () {
                return this.code === utils.status.CONNECTING;
            }
        }
    };
    utils.asyncComponent(options, resolve, reject);
};
}(RongIM, null, RongIM.components));
