(function (RongIM, dependencies, components) {
  'use strict';
  
  var utils = RongIM.utils;
  var dialog = RongIM.dialog;
  var common = RongIM.common;
  var FriendState = common.FriendState;
  // var $ = dependencies.jQuery;
  
  components.newGetRequestAlly = function (resolve, reject) {
      var im = RongIM.instance;
      var orgApi = im.dataModel.Organization;
      var options = {
          name: 'new-request-ally',
          template: '#new-request-ally',
          props: {
            offsetX: Number
          },
          data: function () {
              return {
                  isLoadDone: false,
                  list: []
              };
          },
          mounted: function () {
            this.getNewUnionApply();
          },
          methods: {
            // 获取新的联盟申请
            getNewUnionApply() {
              orgApi.getNewUnionApply((err, res) => {
                if (err) return;
                this.list = res.data;
                this.isLoadDone = true;
              });
            },
            // 同意联盟申请
            updateUnionApply(item) {
              orgApi.updateUnionApply(item.depart_uid, (err, res) => {
                if (err) {
                  common.messageToast({
                    type: 'error',
                    message: "添加失败"
                  });
                  return;
                }
                common.messageToast({
                  type: 'success',
                  message: "添加成功"
                });
                this.getNewUnionApply();
              });
            }
          }
      };
      utils.asyncComponent(options, resolve, reject);
  }
  }(RongIM, {
      jQuery: jQuery
  }, RongIM.components));
  