(function (ImageViewer) {
'use strict';

ImageViewer.browserWindow = RongDesktop.imageViewer.window;
ImageViewer.download = RongDesktop.download;
ImageViewer.options = RongDesktop.imageViewer.options;
ImageViewer.system = RongDesktop.imageViewer.system;
ImageViewer.cache = RongDesktop.cache;
ImageViewer.browserWindow.on('maximize', function () {
    if (ImageViewer.instance) {
        ImageViewer.instance.isMaxWindow = true;
    }
});
ImageViewer.browserWindow.on('unmaximize', function () {
    if (ImageViewer.instance) {
        ImageViewer.instance.isMaxWindow = false;
    }
});

RongDesktop.ipcRenderer.on('update', function (event, _options) {
    if (ImageViewer.onUpdate) {
        ImageViewer.onUpdate(_options);
    }
});

RongDesktop.ipcRenderer.on('closeImageViewer', function (/* event */) {
    if (ImageViewer.onClose) {
        ImageViewer.onClose();
    }
});

RongDesktop.ipcRenderer.on('logout', function (/* event */) {
    if (ImageViewer.onLogout) {
        ImageViewer.onLogout();
    }
});

RongDesktop.ipcRenderer.on('recallMessage', function (event, messageUId) {
    if (ImageViewer.onRecall) {
        ImageViewer.onRecall(messageUId);
    }
});
}(ImageViewer));
