(function (RongIM, dependencies, components) {
    'use strict';

    var common = RongIM.common;
    var utils = RongIM.utils;
    var $ = dependencies.jQuery;
    var dialog = RongIM.dialog;
    var dataModel = RongIM.dataModel;
    var pinApi = dataModel.Pin;
    var orgazApi = RongIM.dataModel.Organization;
    var immediately = 'Immediately';

    RongIM.dialog.addPin = function (msg, callback) {
        var im = RongIM.instance;
        var enabledSms = im.serverConfig.sms.verification_state;
        var maxReceiverCount = im.serverConfig.pin.max_receiver_count;
        var options = {
            name: 'add-pin',
            template: 'modules/pin/templates/add-pin.html',
            data: function () {
                function getMsgFile() {
                    if (msg) {
                        if (msg.attachments) {
                            return msg.attachments.map(function (attach) {
                                return {
                                    data: {
                                        name: attach.name,
                                        size: attach.size,
                                        type: attach.mime_type,
                                        path: attach.url
                                    },
                                    url: attach.url,
                                    progress: 100,
                                };
                            });
                        }

                        if (msg.content) {
                            var uri = msg.content.fileUrl || msg.content.imageUri;
                            if (uri) {
                                return [{
                                    data: {
                                        name: msg.content.name || uri.substr(uri.lastIndexOf('/') + 1),
                                        size: msg.content.size || msg.content.content.length * 0.75,
                                        type: msg.content.type || uri.substr(uri.lastIndexOf('.') + 1),
                                        path: uri
                                    },
                                    url: uri,
                                    progress: 100,
                                    uploadStatus: 2
                                }];
                            }
                        }
                    }
                    return [];
                }

                function getMsgText() {
                    if (msg && msg.content) {
                        if (msg.messageType === 'ReferenceMessage') {
                            return msg.content.text;
                        }

                        if (typeof msg.content.content === 'string') {
                            var isInvalidType = [
                                'ImageMessage',
                                'LocationMessage',
                                'VoiceMessage',
                                'SightMessage'
                            ].some(function (invalidType) {
                                return msg.messageType === invalidType;
                            });

                            if (!isInvalidType) {
                                return msg.content.content;
                            }
                        }
                    }
                    return '';
                }
                return {
                    enabledSms: enabledSms,
                    maxReceiverCount: maxReceiverCount,
                    show: true,
                    tab: 'org',
                    defaultSelected: $.extend(true, [], []),

                    isTimeSelecting: false,
                    isTypeSelecting: false,
                    isSpecificTimeSelecting: false,
                    selectedTime: immediately,
                    // attachments: [], //附件列表
                    // contractList: [], //联系人列表
                    attachments: getMsgFile(),
                    content: getMsgText(),
                    receivers: [],
                    isSending: false,
                    isSendSms: false,
                    isStaff: im.auth.isStaff,
                    pin: {
                        title: "",
                        content: getMsgText() || "",
                        send_sms: true,
                        send_email: false,
                        delayed: false,
                        delayed_send_time: "",
                        urgent_status: false
                    },
                    showAttach: '', //是否显示附件列表
                    receivedTypeList: [{
                            name: '立即发送',
                            value: '1'
                        },
                        {
                            name: '定时发送',
                            value: '2'
                        }
                    ],
                    // ifSent: false, //是否可以发送，必填项填写后改成可发送状态
                    selectContractList: [],
                    forward: msg.forWard || false,
                    textareaMax: false, //textarea是否全屏
                    testareaHeight: 0,
                    selectedPin: null,
                    selectReceiverExpand: true, //是否展开选中联系人
                    ifMessage: false, //是否为消息页面邮件寻呼进入
                    forwardPins: [], //转发详情列表
                    hasForword: false, //是否包含转发记录
                    addPinForward: false, //是否是在转发寻呼时查看转发记录
                    oldPin: null, //修改前的寻呼对象
                    showGroup: false, //是都显示通讯组编辑页面
                    pinGroupList: [],
                    allGroups: [], //所有通讯组
                    selectGroup: {
                        id: ''
                    },
                    groupName: '', //新增组名称
                    isSend:true
                };
            },
            components: {
                avatar: components.getAvatar,
                org: components.group.getOrg,
                friend: components.group.getFriend,
                star: components.group.getStar,
                group: components.group.getGroup,
                addAttachment: components.addAttachment,
                customSelect: components.customSelect,
                pinDetail: components.getPinDetail

            },
            inject: ['reload'], //刷新页面不闪烁
            computed: {
                isStarSelected: function () {
                    return this.tab === 'star';
                },
                isOrgSelected: function () {
                    return this.tab === 'org';
                },
                isFriendSelected: function () {
                    return this.tab === 'friend';
                },
                isGroupSelected: function () {
                    return this.tab === 'group';
                },
                isShowTimeSelect: function () {
                    return this.isTimeSelecting && !this.isSpecificTimeSelecting;
                },
                isAbleSend: function () {
                    return this.selected.length && this.content;
                },
                canNotSelected: function () {
                    var loginUser = im.loginUser || {
                        id: ''
                    };
                    return [loginUser];
                },
                isAttachFull: function () {
                    var serverConfig = RongIM.serverConfig;
                    var maxAttachCount = serverConfig.pin.max_attachment_count;
                    return this.attachments.length >= maxAttachCount;
                },
                ifSent: function () {
                    return this.selectContractList.length > 0 && this.pin.content
                },
                //是否显示超长提示
                showErrorText: function () {
                    return this.groupName.length > 15
                }
            },
            created: function () {
                if (!this.isStaff) {
                    this.tab = 'friend';
                }
                if (this.forward) {
                    //获取详情
                    setDetail(this, im, msg.pin);
                }
                if (msg.targetUser) {
                    this.selectContractList.push(msg.targetUser)
                }
                if (msg.memberList) {
                    this.selectContractList = msg.memberList.map(obj => {
                        return {
                            ...obj,
                            id: obj.receiver_uid
                        }
                    })
                }
                if (msg.groupMembers) {
                    this.selectContractList = msg.groupMembers.filter(function (member) {
                        return member.id !== im.loginUser.id;
                    });

                }
                // if (msg.content) {

                //     if(msg.targetUser){
                //         this.selectContractList=[]
                //         this.selectContractList.push(msg.targetUser)
                //     }

                //     if (msg.messageType !="TextMessage") { //消息是附件
                //         let data = msg.content
                //         if(msg.messageType == "ImageMessage"){
                //             data.size=utils.getBase64Size(data.content);     
                //             data.type=utils.getFileType(data.imageUri)
                //             data.name=utils.getFilename(data.imageUri).filename
                //             data.url=data.imageUri
                //         }
                //         this.attachments.push(data)
                //         this.ifMessage = true
                //     }else { //消息是文字
                //         this.pin.content = msg.content.content
                //     }

                // }
            },
            methods: getMethods(im, callback),
            watch: {
                //是否包含转发记录
                'hasForword' (v) {
                    //包含转发记录
                    let that = this;
                    if (v) {
                        //我收到的
                        if (that.pin.type == 1) {
                            //获取当前要转发的收到的寻呼
                            pinApi.getSelfForward(that.pin.uid, function (errorCode, result) {
                                if (errorCode) {
                                    return;
                                }
                                that.forwardPins.unshift(result[0])
                            });

                        } else {
                            if (that.pin.type == 0) {
                                that.oldPin.name = that.pin.user.name;
                                let obj = utils.deepClone(that.oldPin)
                                // obj.title = obj.title.substring(3)
                                that.forwardPins.unshift(obj)
                            }
                        }
                    } else {
                        that.forwardPins = []
                    }

                },
                "pin.send_sms" (v) {
                    if (!v) {
                        this.pin.send_sms_type = false;
                    }
                }
            }
        };
        common.mountDialog(options);
    };

    function getMethods(im, callback) {
        return {
            reset: function () {
                this.selected.push({});
                this.selected.pop();
            },
            toastError: function (errorCode) {
                common.toastError(errorCode, this.$el.firstChild);
            },
            toast: function (params) {
                params.el = this.$el.firstChild;
                common.messageToast(params);
            },
            getSelectedContact: function () {
                var context = this;
                var selLen = context.selected.filter(function (item) {
                    return !context.executiveLimit(item);
                }).length;
                var selectedContactFormat = im.locale.components.newPin.selectedContact;
                return this.localeFormat(selectedContactFormat, selLen);
            },
            close: function () {
                this.show = false;
            },
            added: function (members) {
                added(this, members, im);
            },
            removed: function (members) {
                removed(this, members);
            },
            selectTab: function (tab) {
                this.tab = tab;
            },
            showSendTime: function () {
                this.isTimeSelecting = !this.isTimeSelecting;
                this.isSpecificTimeSelecting = false;
                this.isTypeSelecting = false;
            },
            showSendType: function () {
                this.isTypeSelecting = !this.isTypeSelecting;
                this.isTimeSelecting = false;
                this.isSpecificTimeSelecting = false;
            },
            getSelectedTime: function () {
                if (this.selectedTime === immediately) {
                    return im.locale.components.newPin.immediatelySend;
                }
                var date = new Date(this.selectedTime);
                return formatDate(null, date);
            },
            getSelectedType: function () {
                var localeNewPin = im.locale.components.newPin;
                return this.isSendSms ? localeNewPin.sms : localeNewPin.app;
            },
            selectSendType: function (isSms) {
                this.isSendSms = isSms;
                this.isTypeSelecting = false;
            },
            selectImmediately: function () {
                this.selectedTime = immediately;
                this.isTimeSelecting = false;
            },
            enterCancelled: function () {
                this.isClicking = false;
            },
            afterEnter: function () {
                this.isClicking = false;
                im.$emit('pinDetailLoadDone');
            },
            selectSpecificTime: function () {
                if ((Object.prototype.toString.call(this.selectedTime) !== '[object Number]')) {
                    var date = new Date();
                    date.setMilliseconds(0);
                    date.setSeconds(0);
                    this.selectedTime = date.getTime();
                }
                this.isSpecificTimeSelecting = true;
            },
            clickAddAttachment: function () {
                components.addAttachment(this);
            },
            getDateItems: function () {
                var locale = im.locale.components.newPin;
                return [locale.year, locale.month, locale.day, locale.hour, locale.minute];
            },
            getFormatDate: function (type) {
                var date = new Date(this.selectedTime);
                return formatDate(type, date);
            },
            calcDate: calcDate,
            sendPin: function () {
                if (this.pin.title.length > 15) {
                    this.toast({
                        type: '',
                        message: '主题的最大长度为15个字'
                    });
                    return;
                }
                var nowTime = new Date();
                nowTime = nowTime.setSeconds(0);
                var isInvalidTime = this.selectedTime !== immediately && nowTime > this.selectedTime;
                if (isInvalidTime) {
                    this.toast({
                        type: 'error',
                        message: im.locale.components.newPin.pastTime
                    });
                    // this.selectedTime = nowTime;
                    return;
                }
                if (!this.ifMessage) {
                    var isAttachmentsComplete = true;
                    this.attachments.forEach(function (atta) {
                        if (atta.progress < 100) {
                            isAttachmentsComplete = false;
                        }
                    });
                    if (!isAttachmentsComplete) {
                        this.toast({
                            type: 'error',
                            message: im.locale.components.newPin.failSend
                        });
                        return;
                    }
                }


                var isValidContent = this.selectContractList.length && this.pin.content;
                if (isValidContent) sendPin(this, im);
            },
            closeSelectTime: function (event) {
                var $target = $(event.target);
                var wrap = '.rong-pin-select-time, .rong-pin-select-sepcific-time, .rong-pin-select-time-box, .rong-pin-select-type-box';
                var inBody = $target.closest('body').length > 0;
                var inWrap = $target.closest(wrap).length < 1;
                var isOuter = inBody && inWrap;
                var isSelecting = this.isTimeSelecting || this.isSpecificTimeSelecting || this.isTypeSelecting;
                if (isSelecting && isOuter) {
                    this.isSpecificTimeSelecting = false;
                    this.isTimeSelecting = false;
                    this.isTypeSelecting = false;
                }
            },
            enterContent: function () {
                var context = this;
                var length = this.content.length;
                if (length > 5000) {
                    context.toast({
                        type: 'error',
                        message: context.locale.components.newPin.mostContent
                    });
                    context.content = context.content.substring(0, 5000);
                }
            },
            executiveLimit: function (item) {
                if (item.isFriend || im.auth.isExecutive || this.disableExecutive) {
                    return false;
                }
                var isExecutive = !!item.isExecutive;
                return isExecutive;
            },
            maxCountLimit: function () {
                var mostReceiveFormat = im.locale.components.newPin.mostReceive;
                var hintMessage = this.localeFormat(mostReceiveFormat, this.maxReceiverCount);
                this.toast({
                    type: 'error',
                    message: hintMessage
                });
                this.reset();
            },
            unique(arr) {
                const res = new Map();
                return arr.filter((arr) => !res.has(arr.id) && res.set(arr.id, 1));
            },
            selectContracts: function () {
                let _that = this
                dialog.pinDialogBox({
                    groupMembers: _that.selectContractList
                }, (tips, content) => {
                    let list = content
                    _that.selectContractList = _that.unique(list);
                });
            },
            changes: function () {
                if (this.pin.title.length == 15) {
                    this.toast({
                        type: '',
                        message: '主题的最大长度为15个字'
                    });
                    return;
                }
            },
            showSendTime: function () {
                this.isTimeSelecting = !this.isTimeSelecting;
                this.isSpecificTimeSelecting = false;
                this.isTypeSelecting = false;
            },
            removeAttachment: function (attachments) {
                this.attachments = attachments
            },
            dateFormat: function (forward) {
                let timestamp = forward.send_dt || forward.create_dt
                var dateFormat = utils.dateFormat;
                var options = {
                    alwaysShowTime: true
                };
                return dateFormat(timestamp, options);
            },
            expandTextarea: function () {
                let height = $(".addpin-bodys").height() - 100
                // 输入框原有高度
                this.testareaHeight = $("#textarea").height() - 100
                $("#textarea").height(height)
                this.textareaMax = true

            },
            shouqiTextarea: function () {
                $("#textarea").height(this.testareaHeight)
                this.textareaMax = false
            },
            openDetails: function (forward) {
                this.selectedPin = forward;
                this.addPinForward = true
            },
            updateAttachs: function (data) {
                this.attachments = data;
                console.log(this.attachments)
            },
            isExis: function (item) {
                let arr = this.pinGroupList.filter(obj => obj.name == item.name)
                if (arr.length > 0) {
                    return true
                } else {
                    return false
                }
            },
            //删除元素
            delItem: function (index) {
                this.pinGroupList.splice(index, 1);
            },
            //点击空格键添加到所属通讯组
            saveGrou() {
                if (this.groupName.length > 15) {
                    this.$refs.groupName.focus()
                    return;
                }
                let obj = {
                    name: this.groupName
                }
                //输入的通讯组名称已存在
                if (this.groupName == '') {
                    return;
                }
                if (this.checkOnly()) {
                    this.allGroups.forEach((item, index) => {
                        if (item.name == this.groupName) {
                            this.pinGroupList.push(item)
                        }
                    })

                } else {
                    this.pinGroupList.push(obj)
                }

                this.groupName = ''
            },
            toastError: function (errorCode) {
                var el = null;
                if (this.$el) {
                    el = this.$el.firstChild;
                }
                common.toastError(errorCode, el);
            },
            //检验输入的通讯组名是否存在
            checkOnly() {
                let arr = this.allGroups.filter(obj => obj.name == this.groupName)
                return arr.length > 0
            },
            //保存通讯组
            savePinGroup() {
                let that = this
                let receiver_ids = that.selectContractList.map(obj => obj.id)
                let receiver_names = that.pinGroupList.map(obj => obj.name)
                im.dataModel.Group.changePersonalGroup({
                    receiver_ids: receiver_ids,
                    receiver_names: receiver_names
                }, function (errorcode, res) {
                    if (errorcode) {
                        return;
                    }
                    common.messageToast({
                        type: 'success',
                        message: '添加成功'
                    });
                    that.showGroup = false
                    let str = ''
                    that.pinGroupList.forEach(obj => {
                        str += obj.name + '、'
                    })
                    that.pinGroup = str.substring(0, str.length - 1)
                    callback(res)
                })
            },
            selectObj: function (obj) {
                let flag = this.pinGroupList.filter(res => res.id == obj.id)
                if (flag.length > 0) {
                    this.pinGroupList.splice(this.pinGroupList.findIndex(item => item.id === obj.id), 1)
                    return;
                }
                this.selectGroup = obj
                let list = this.pinGroupList;
                list.push(obj)
                const res = new Map();
                this.pinGroupList = list.filter((arr) => !res.has(arr.name) && res.set(arr.name, 1));

            },
            openPinGroup: function () {
                let that = this
                if (that.pinGroupList.length == 0) {
                    that.showGroup = false;
                    return false;
                }
                common.messagebox({
                    type: 'confirm',
                    message: that.locale.btns.saveThis,
                    callback: function () {
                        that.savePinGroup()
                    },
                    closeCallback: function () {
                        that.showGroup = false;
                        that.pinGroupList = []
                    },
                    hashchangeClose: false
                });
            },
            unique(arr) {
                const res = new Map();
                return arr.filter((arr) => !res.has(arr.id) && res.set(arr.id, 1));
            },
            setShowGroup: function () {
                this.showGroup = true
                getPinGroups(this)
            },
        };
    }
    //获取所有的通讯组
    function getPinGroups(context) {
        orgazApi.getPinGroups('', res => {
            if (!res.count) return;
            context.allGroups = res.data

        })
    }

    function resetInputFileValue(inputId) {
        var $inputFile = $('#' + inputId);
        $inputFile.val('');
    }

    function checkAttachInBound(context, fileList) {
        // PIN 携带的附件最大数
        var serverConfig = RongIM.serverConfig;
        var maxAttachCount = serverConfig.pin.max_attachment_count;
        // 附件个数设置
        var attachCount = context.attachments.length + fileList.length;
        var isBeyond = attachCount > maxAttachCount;

        return !isBeyond;
    }

    function checkAttachSize(fileList, fileSize) {
        var hasZero = 0;
        /* eslint-disable no-restricted-syntax */
        // eslint-disable-next-line guard-for-in
        for (var key in fileList) {
            if (fileList[key].size === 0) {
                hasZero = 1;
                break;
            }
            if (fileList[key].size > fileSize) {
                hasZero = 2;
                break;
            }
        }
        /* eslint-enable no-restricted-syntax */
        return hasZero;
    }

    function sendPin(context, im) {
        if (!context.ifMessage) {
            if (context.isSending || hasUploadingFile(context)) {
                context.toast({
                    type: 'error',
                    message: context.locale.components.newPin.uploading
                });
                return;
            }
        }

        var sendParams = getSendParams(context);
        if (context.receivers.length > 99) {
            common.messagebox({
                type: 'confirm',
                message: context.locale.pin.willSend,
                callback: function () {
                    createPin(context, im, sendParams);
                },
                hashchangeClose: false
            });
        } else {
            createPin(context, im, sendParams);
        }
    }

    function hasUploadingFile(context) {
        var attachments = context.attachments.filter(function (atta) {
            return atta.progress !== 100 && atta.progress !== -1;
        });
        return attachments.length !== 0;
    }

    function getSendParams(context) {
        context.receivers = context.selectContractList.filter(function (item) {
            return !context.executiveLimit(item);
        });
        var receiverIds = context.receivers.map(function (receiver) {
            return receiver.id;
        });
        var receiverNames = context.receivers[0].name;
        for (var i = 1; i < 3 && i < context.receivers.length; ++i) {
            receiverNames = receiverNames + '、' + context.receivers[i].name;
        }
        if (context.receivers.length > 3) {
            receiverNames = receiverNames + '...';
        }

        var attachments = context.attachments.filter(function (atta) {
            return atta.progress !== -1;
        });
        attachments = attachments.map(function (atta) {
            return {
                name: atta.name || atta.data.name,
                size: atta.size || atta.data.size,
                mime_type: context.ifMessage ? atta.type : atta.mime_type || atta.data.type || 'unknown',
                url: atta.url || atta.fileUrl
            };
        });
        var delayed = (Object.prototype.toString.call(context.selectedTime) === '[object Number]');
        var params = {
            ...context.pin,
            title: context.pin.title,
            delayed: delayed,
            urgent_status: context.pin.urgent_status ? 1 : 0,
            send_see: context.pin.send_see ? 1 : 0,
            send_sms_type: context.pin.send_sms_type ? 1 : 0,
            pin_type: context.forward ? 1 : 0,
            receiver_ids: receiverIds,
            attachments: attachments,
            pin_path: context.forward ? context.forwardPins.map(obj => obj.uid).join(',') : ''
        };
        params.delayed_send_time = delayed ? context.selectedTime : 0;

        return params;
    }
    var setupCommentList = utils.throttle(function (context, pinApi, uid) {
        pinApi.getCommentList(uid, function (errorCode, comments) {
            if (errorCode) {
                return;
            }
            Vue.nextTick(function () {
                context.commentList = comments;
            });
        });
    }, 2000);

    function setDetail(context, im, pin) {
        var dataModel = im.dataModel;
        var pinApi = dataModel.Pin;
        context.oldPin = utils.deepClone(pin)
        context.pin = {
            ...pin,
            title: context.forward ? '转发：' + pin.title : pin.title,
            send_sms: true,
            send_email: false,
            send_see: false,
            delayed: false,
            urgent_status: false,
            progress: 100,
            pin_type: false,
        }
        //如果是收到的寻呼

        // if (!context.pin.forwardPins.length > 0) {
        //     if (context.pin.type == 0) {
        //         context.pin.name = context.pin.user.name;
        //         if (context.pin.type == 1) {
        //             context.pin.receiver_name = im.loginUser.name
        //         }
        //         let obj = utils.deepClone(context.pin)
        //         context.forwardPins.push(obj)
        //     }
        // }else{
        //     context.forwardPins = utils.deepClone(context.pin.forwardPins)
        // } 
        getForwardPin(context, pinApi, context.pin.uid)
        if (context.pin.forwardPins && context.pin.forwardPins.length > 0) {
            context.forwardPins = utils.deepClone(context.pin.forwardPins)
        }
        context.attachments = context.pin.attachments ? context.pin.attachments.map(o => {
            return {
                ...o,
                progress: 100
            }

        }) : []
    }

    // 获取转发记录
    function getForwardPin(context, pinApi, uid) {
        pinApi.getPinDetail(uid, function (errorCode, result) {
            if (errorCode) {
                return;
            }

            context.forwardPins = result.forwardPins
        })
    }

    function createPin(context, im, sendParams) {
        context.isSending = true;
        if (context.isSend) {
          context.isSend=false
          pinApi.create(sendParams, function (errorCode, result) {
            context.isSend=true
            context.isSending = false;
            if (errorCode) {
                context.toastError(errorCode);
                return;
            }
            sendMessageWhenInSendpinPage(im, result);
            afterCreatePin(context, sendParams, result, im);
        });
        }
      
    }

    function afterCreatePin(context, sendParams, result, im) {
        common.messagebox({
            message: context.locale.components.newPin.success,
            callback: function () {
                let timestamp = (new Date()).getTime();

                result.attachments = sendParams.attachments.map(obj => {
                    return {
                        ...obj,
                        isDownloading: false,
                        downloadProgress: 100
                    }
                })
                // 如果是定时发送  定时发送只在发送成功后发通知
                if (result.delayed) {
                    im.$emit('createPin', result)
                }

                context.close();
            },
            closeCallback: function () {
                context.close();
            },
            hashchangeClose: false
        });

    }

    function sendMessageWhenInSendpinPage(im, result) {
        if (im.$route.name !== 'pin-sent') {
            return;
        }
        // content = $.extend(content, { creatorUid: content.creator_uid, timestamp: content.create_dt });
        var message = {
            messageType: pinApi.MessageType.PinNotifyMessage,
            content: {
                pinUid: result.uid,
                creatorUid: result.creatorUid,
                timestamp: result.timestamp,
                content: result.content
            }
        };
        pinApi.observerList.notify(message);
    }

    function calcDate(dateType, addNumber) {
        var im = RongIM.instance;
        var date = new Date(this.selectedTime);
        switch (dateType) {
            case 0:
                var year = date.getFullYear();
                date.setFullYear(year + addNumber);
                break;
            case 1:
                var month = date.getMonth();
                date.setMonth(month + addNumber);
                break;
            case 2:
                var day = date.getDate();
                date.setDate(day + addNumber);
                break;
            case 3:
                var hour = date.getHours();
                date.setHours(hour + addNumber);
                break;
            case 4:
                var minute = date.getMinutes();
                date.setMinutes(minute + addNumber);
                break;
            default:
                break;
        }
        var thisTime = new Date().getTime();
        if (thisTime > date.getTime()) {
            this.toast({
                type: 'error',
                message: im.locale.components.newPin.pastTime
            });
            return;
        }
        date.setSeconds(0);
        date.setMilliseconds(0);
        this.selectedTime = date.getTime();
    }

    function formatDate(type, date) {
        var year = date.getFullYear();
        var month = date.getMonth() + 1;
        var day = date.getDate();
        var hour = date.getHours();
        var minute = date.getMinutes();
        switch (type) {
            case 0:
                return year;
            case 1:
                return month;
            case 2:
                return day;
            case 3:
                return hour;
            case 4:
                return minute;
            default:
                var addZeroWhenSingle = function (number) {
                    return (number + '').length > 1 ? number : ('0' + number);
                };
                var hourMark = addZeroWhenSingle(hour);
                var minuteMark = addZeroWhenSingle(minute);
                return year + '/' + month + '/' + day + ' ' + hourMark + ':' + minuteMark;
        }
    }

    function added(context, members, im) {
        var selectedIdList = context.selected.map(function (item) {
            return item.id;
        });
        var addedList = members.filter(function (item) {
            var hasSelected = selectedIdList.indexOf(item.id) < 0;
            var notSelf = item.id !== im.loginUser.id;
            return hasSelected && notSelf;
        });
        var totalList = context.selected.concat(addedList);
        context.selected = totalList;
        totalList = totalList.filter(function (item) {
            return !context.executiveLimit(item);
        });

        // PIN 最大人数由服务端下发
        var maxReceiverCount = context.maxReceiverCount;
        var mostReceiveFormat = im.locale.components.newPin.mostReceive;
        var hintMessage = context.localeFormat(mostReceiveFormat, maxReceiverCount);
        if (totalList.length > maxReceiverCount) {
            context.toast({
                type: 'error',
                message: hintMessage
            });
            removed(context, addedList);
        }
    }

    function removed(context, members) {
        var idList = members.map(function (item) {
            return item.id;
        });
        var reservedIdList = context.defaultSelected.map(function (item) {
            return item.id;
        });
        context.selected = context.selected.filter(function (item) {
            var reserved = reservedIdList.indexOf(item.id) >= 0;
            return reserved || idList.indexOf(item.id) < 0;
        });
    }

    function upload(file, context) {
        var models = RongIM.instance.dataModel;
        var pin = models.Pin;
        var getFileType = utils.getFileType;
        var fileType = getFileType(file.name);
        var attach = {
            data: file,
            progress: 0,
            url: null,
            uploadId: Date.now(),
            uploadStatus: utils.uploadStatus.READY,
            rawSize: file.size
        };
        context.attachments.push(attach);
        pin.uploadAttach(fileType, file, attach, function (err) {
            if (err) {
                utils.console.warn('上传失败');
                return;
            }
            saveLocalAttach(attach.data, attach.data.path);
        });
    }

    function saveLocalAttach(attach, localPath) {
        var im = RongIM.instance;
        im.dataModel.Pin.addPinLocalAttach(attach.name, localPath);
    }
}(RongIM, {
    jQuery: jQuery,
    UploadClient: UploadClient
}, RongIM.components));