(function (RPSA) {
'use strict';

RPSA.browserWindow = {
    max: function () {
        RongDesktop.Win.max();
    },
    min: function () {
        RongDesktop.Win.min();
    },
    restore: function () {
        RongDesktop.Win.restore();
    },
    close: function () {
        RongDesktop.Win.close();
    },
    platform: RongDesktop.platform,
    openLocaleBrowser: function (url) {
        RongDesktop.shell.openExternal(url);
    },
    onReload: function (callback) {
        RongDesktop.ipcRenderer.on('reload', function (event, url) {
            callback(url);
        });
    }
};
RongDesktop.Win.on('maximize', function () {
    if (RPSA.instance) {
        RPSA.instance.isMaxWindow = true;
    }
});
RongDesktop.Win.on('unmaximize', function () {
    if (RPSA.instance) {
        RPSA.instance.isMaxWindow = false;
    }
});
}(window.RPSA));
