(function (RPSA) {
'use strict';

var browserWindow = RPSA.browserWindow;

function init(config) {
    var psAticle = new Vue({
        el: config.el,
        data: {
            canGoBack: false,
            isMaxWindow: false
        },
        computed: {
            os: function () {
                return browserWindow.platform;
            }
        },
        mounted: function () {
            var context = this;
            Vue.nextTick(function () {
                if (context.$refs.browser) {
                    var query = getQuery();
                    var browser = context.$refs.browser;
                    initBrowser(browser, query, context);
                }
            });
            browserWindow.onReload(function (url) {
                if (context.$refs.browser) {
                    var query = getQuery(url);
                    var browser = context.$refs.browser;
                    initBrowser(browser, query, context);
                }
            });
        },
        methods: {
            bridgeUrl: function (pageUrl, query) {
                var token = decodeURIComponent(query.zkxToken) + ';path=/';
                if (pageUrl.match(/\/taskcenter\//i) != null && query.sessionid) {
                    let urlParts = pageUrl.split('#');
                    pageUrl = urlParts[0] + (
                        urlParts[0].indexOf('?') > 0 ? '&' : '?'
                    ) + "sessionid=" + encodeURIComponent(query.sessionid) +
                    "&uid=RY" + query.empId + (
                        urlParts[1] ? ('#' + urlParts[1]) : ''
                    );
                }
                return RPSA.loginServer + '/sign-bridge.html' +
                    '?target=' + encodeURIComponent(pageUrl) +
                    '&empId=' + (query.empId || '') +
                    '&token=' + encodeURIComponent(token);
            },
            min: function () {
                browserWindow.min();
            },
            max: function () {
                browserWindow.max();
                this.isMaxWindow = true;
            },
            restore: function () {
                browserWindow.restore();
                this.isMaxWindow = false;
            },
            close: function () {
                browserWindow.close();
            },
            copyUrl: function () {
                var url = this.$refs.browser.getURL();
                copyToClipboard(url);
            },
            openUrl: function () {
                var url = this.$refs.browser.getURL();
                browserWindow.openLocaleBrowser(url);
            },
            goBack: function () {
                var browser = this.$refs.browser;
                browser.goBack();
            },
            reload: function () {
                var browser = this.$refs.browser;
                browser.reload();
            }
        }
    });
    RPSA.instance = psAticle;
}

function initBrowser(browser, query, context) {
    if (browser.getWebContents && query.zkxToken) {
        var ses = browser.getWebContents().session;
        var token = decodeURIComponent(query.zkxToken).split('=');
        ses.cookies.remove(query.url, 'JSESSIONID', function () {});
        ses.cookies.set({
            url: RPSA.loginServer,
            name: token[0],
            value: token[1],
            path: '/'
        }, function (err) {});
        ses.cookies.flushStore(function () {});
    }
    browser.src = query.url;
    browser.addEventListener('did-navigate', function () {
        context.canGoBack = browser.canGoBack();
    });
    browser.addEventListener('new-window', function (event) {
        var url = event.url;
        if (url.startsWith('http:') || url.startsWith('https:')) {
            browserWindow.openLocaleBrowser(context.bridgeUrl(url, query));
        }
    });
}

// 复制到剪切板
function copyToClipboard(str) {
    if (window.copy) {
        window.copy(str);
    } else if (document.execCommand) {
        var input = document.createElement('input');
        input.style.position = 'fixed';
        input.style.top = '-99999999px';
        var $input = $('<textarea></textarea>').css({
            position: 'fixed',
            left: '-99999999px'
        });
        $(document.body).append($input);
        $input.val(str);
        $input.select();
        document.execCommand('copy');
        $input.remove();
    }
}

function getQuery(url) {
    var search = window.location.search;
    if (url) {
        search = url.substring(url.indexOf('?'));
    }
    var query = {};
    var str = search.substring(1);
    str.split('&').forEach(function (item) {
        var arr = item.split('=');
        query[arr[0]] = decodeURIComponent(arr[1]);
    });
    return query;
}

RPSA.init = init;
}(window.RPSA));
