(function (win, RongIM) {
'use strict';

var config = RongIM.config;
var server = config.dataModel.server;
var serverOA = config.dataModel.serverOA;
console.log(serverOA);
var RongDesktop = window.RongDesktop;
if (RongDesktop) {
    if (RongDesktop.configInfo) {
        config.dataModel.server = RongDesktop.configInfo.APP_SERVER;
        config.product.name = {
            zh: RongDesktop.configInfo.PRODUCT_NAME_ZH,
            en: RongDesktop.configInfo.PRODUCT_NAME_EN
        };
        config.product.version = RongDesktop.configInfo.APP_VERSION;
        config.product.versionCode = RongDesktop.configInfo.APP_VERSION_CODE;
    }
    // 多个窗口引用此文件，但 builder 中的 preload 未必对所有内容进行了挂载，故需要添加判断
    if (RongDesktop.system) {
        config.locale = RongDesktop.system.locale.split('-')[0];
    }
}
win.RongWork = {
    config: {
        locale: config.locale,
        server: server,
        serverOA:serverOA,
        product: config.product
    },
    locale: {},
    dialog: {},
    components: RongIM.components,
    utils: RongIM.utils,
    loginServer: config.loginServer
};
}(window, RongIM));
