(function (RongWork) {
    'use strict';

    var components = RongWork.components;
    var utils = RongWork.utils;
    var serverApi = RongWork.serverApi;
    var confirmeQuit = false;
    var BaseApp = utils.appType.base;

    function getCurrentWebview(context) {
        var webview = context.$refs[context.currentTab.id];
        if ($.isArray(webview)) {
            return webview[0];
        }
        return webview;
    }

    function init(config) {
        config.product.productName = config.product.name[config.locale];
        var browserWindow = RongWork.browserWindow;
        var time;
        var work = new Vue({
            el: config.el,
            data: {
                busy: false,
                config: config,
                isMaxWindow: false,
                allApps: [],
                baseApps: [],
                otherApps: [],
                scienceApps: [],
                workApps: [],
                academicApps: [],
                partyApps: [],
                thinkApps: [],
                currentTab: null,
                tabList: [],
                location: window.location.href,
                canGoForward: false,
                canGoBack: false,
                canReload: false,
                keyword: '',
                showApps: {
                    baseApps: true,
                    scienceApps: false,
                    workApps: false,
                    academicApps: false,
                    partyApps: false,
                    thinkApps: false
                },
                showTodo:true,
                todoList:[]
            },
            components: {
                // editOtherapp: components.getEditOtherapp,
                pinSearch: components.getPinSearch
            },
            created: function () {
                var context = this;
                /*browserWindow.onCommandClose(function () {
                    confirmeQuit = true;
                    browserWindow.close();
                });*/
                browserWindow.onPublicNotify(function (notify) {
                    getAppList(context);
                    context.removeTab(notify);
                });
            },
            computed: {
                tabWidth: function () {
                    var context = this;
                    var width = 0;
                    if (context.tabList.length > 0) {
                        width = 99 / context.tabList.length;
                        width = width > 50 ? 50 : width;
                    }
                    return width + '%';
                },
                locale: function () {
                    var language = this.query.language || 'zh';
                    RongWork.locale[language].product = this.config.product;
                    return RongWork.locale[language];
                },
                os: function () {
                    return this.query.os || browserWindow.getPlatform();
                },
                usingShell: function () {
                    return (this.os.indexOf('win') > -1);
                },
                query: function () {
                    return getQuery();
                },
                workListStyle: function () {
                    return this.query.hideWorkList ? {
                        'display': 'none'
                    } : {};
                },
                workMainStyle: function () {
                    return this.query.hideWorkList ? {
                        'margin-left': '0'
                    } : {};
                },
                workCtrlStyle: function () {
                    return this.query.hideWorkList ? {
                        'display': 'none'
                    } : {};
                },
                workBodyStyle: function () {
                    return this.query.hideWorkList ? {
                        'padding-top': '0'
                    } : {};
                }
            },
            watch: {
                currentTab: function (newVal) {
                    if (newVal) {
                        var webview = getCurrentWebview(this);
                        var canGoBack = false;
                        var canGoForward = false;
                        if (webview) {
                            canGoBack = webview.canGoBack && webview.canGoBack();
                            canGoForward = webview.canGoForward && webview.canGoForward();
                        }
                        this.canGoBack = canGoBack;
                        this.canGoForward = canGoForward;
                        this.canReload = validUrl(this.pageUrl(newVal));
                    }
                }
            },
            mounted: function () {
                var context = this;
                getTudoList()
                getAppList(this);
                console.info("os: " + this.os);
                browserWindow.reloadWork(function (path) {
                    var newQuery = getQuery(path);
                    if (newQuery.targetId) {
                        newQuery.id = newQuery.targetId;
                    }
                    context.openApp(newQuery);
                });
            },
            methods: {
                appGroupTitle: function (tag, listTag) {
                    if (!listTag) listTag = tag;
                    return this.locale[tag] + ' (' + this[listTag].length + ')';
                },
                min: function () {
                    browserWindow.min();
                },
                max: function () {
                    browserWindow.max();
                    this.isMaxWindow = true;
                },
                restore: function () {
                    browserWindow.restore();
                    this.isMaxWindow = false;
                },
                close: function () {
                    browserWindow.close();
                },
                goBack: function () {
                    var webview = getCurrentWebview(this);
                    if (webview) {
                        webview.goBack();
                    }
                },
                goForward: function () {
                    var webview = getCurrentWebview(this);
                    if (webview) {
                        webview.goForward();
                    }
                },
                reload: function () {
                    var webview = getCurrentWebview(this);
                    if (webview) {
                        if (webview.reload) {
                            webview.reload();
                        } else {
                            webview.src = webview.src;
                        }
                    }
                },
                removeTab: function (notify) {
                    // 后台关闭后消息通知，移除当前已经打开的应用
                    var context = this;
                    var notifyApp = context.tabList.filter(function (item) {
                        return item.id === notify.targetId;
                    });
                    if (context.isSelected(notifyApp[0])) {
                        utils.messagebox({
                            message: context.locale.theAppCloseTip,
                            callback: function () {
                                context.closeTab(notifyApp[0]);
                            }
                        });
                    } else if (notifyApp[0]) {
                        context.closeTab(notifyApp[0]);
                    }
                },
                closeTab: function (item) {
                    var index = this.tabList.indexOf(item);
                    this.tabList.splice(index, 1);
                    this.currentTab = this.tabList[0];
                },
                showPublicDetail: function (item) {
                    return (
                        item.type !== -1 && !validUrl(this.pageUrl(item))
                    );
                },
                isSelected: function (item) {
                    return item === this.currentTab && item !== undefined;
                },
                workViewStyle: function (item) {
                    return Object.assign({
                            display: this.isSelected(item) ? 'flex' : 'none'
                        },
                        this.workBodyStyle
                    );
                },
                isTrueFlag: function (str) {
                    return str == '1' || str == 'true' || str == 'yes' || str == 'on';
                },
                openApp: function (app) {
                    var context = this;
                    var appIndex = -1;
                    context.tabList.forEach(function (value, index) {
                        if (value.id === app.id) {
                            appIndex = index;
                        }
                    });
                    if (appIndex > -1) {
                        context.currentTab = context.tabList[appIndex];
                    } else if (app.type !== -1) {
                        serverApi.getPublicInfo(app.id, function (errorCode, result) {
                            if (errorCode || !result) {
                                return;
                            }
                            var pageUrl = context.pageUrl(result);
                            var searchArgs = {};
                            var searchStart = pageUrl.indexOf('?');
                            if (searchStart > -1) {
                                pageUrl.substr(searchStart + 1).split('&').forEach(function (arg) {
                                    var pair = arg.split('=');
                                    searchArgs[pair[0].toLowerCase()] = pair[1];
                                });
                            }
                            if (context.isTrueFlag(searchArgs['opentab'])) {
                                if (context.tabList.indexOf(result) === -1) {
                                    context.tabList.push(result);
                                    Vue.nextTick(function () {
                                        initWebview(result, context);
                                    });
                                }
                                context.currentTab = result;
                            } else {
                                console.log(context.bridgeUrl(pageUrl))
                                console.info("usingShell:" + context.usingShell + ', openChrome:' + searchArgs['openchrome']);
                                openExternal(
                                    context.bridgeUrl(pageUrl),
                                    context.usingShell && context.isTrueFlag(searchArgs['openchrome'])
                                );
                            }
                        });
                    } else {
                        context.tabList.push(app);
                        context.currentTab = app;
                        Vue.nextTick(function () {
                            initWebview(app, context);
                        });
                    }
                },
                enterPublic: function (app) {
                    var context = this;
                    if (!context.busy) {
                        context.busy = true;
                        browserWindow.enterPublic(app, function () {
                            context.busy = false;
                        });
                    }
                },
                edit: function () {
                    this.openApp({
                        name: this.locale.setCommonApp,
                        type: -1
                    });
                },
                reloadFavApp: function () {
                    this.closeTab(this.currentTab);
                    getAppList(this);
                },
                searchAppList: function (val) {
                    this.keyword = val.keyword;
                    this.filterApps();
                },
                filterApps: function () {
                    var context = this;
                    var regex = this.keyword ? new RegExp(this.keyword, 'i') : null;
                    this.baseApps = [];
                    this.otherApps = [];
                    this.scienceApps = [];
                    this.workApps = [];
                    this.academicApps = [];
                    this.partyApps = [];
                    this.thinkApps = [];
                    this.allApps.forEach(function (item) {
                        var pageUrl = context.pageUrl(item);
                        if (!pageUrl) return;
                        // favorite   判断去掉
                        var favorite = pageUrl.indexOf('favorite');
                        if (favorite > -1) {
                            favorite = pageUrl.substr(favorite).split('&')[0];
                        } else {
                            favorite = null;
                        }
                        var isOther = (item.type != BaseApp && !item.favorite) &&
                            !(favorite && favorite.indexOf('pc') > -1);
                        var pushTarget = context.baseApps;
                        if (isOther) {
                            context.otherApps.push(item);
                            if (item.description == 1) {
                                pushTarget = context.scienceApps;
                            } else if (item.description == 2) {
                                pushTarget = context.workApps;
                            } else if (item.description == 3) {
                                pushTarget = context.academicApps;
                            } else if (item.description == 4) {
                                pushTarget = context.partyApps;
                            } else if (item.description == 5) {
                                pushTarget = context.thinkApps;
                            }
                        }
                        if (!regex || regex.test(item.name)) pushTarget.push(item);
                    })
                    this.onLoadApps();
                },
                pageUrl: function (app) {
                    return app.pc_home_page_url || app.home_page_url || '';
                },
                appUrl: function (app) {
                    var pageUrl = this.pageUrl(app);
                    /*return (this.os.indexOf('web') > -1) ? this.bridgeUrl(pageUrl) : pageUrl;*/
                    var url = this.bridgeUrl(pageUrl);
                    if (pageUrl.indexOf("useValidation") > -1) console.log(url);
                    return url;
                },
                bridgeUrl: function (pageUrl) {
                    if (pageUrl.match(/\/taskcenter\//i) != null && this.query.sessionid) {
                        let urlParts = pageUrl.split('#');
                        pageUrl = urlParts[0] + (
                                urlParts[0].indexOf('?') > 0 ? '&' : '?'
                            ) + "sessionid=" + encodeURIComponent(this.query.sessionid) +
                            "&uid=RY" + this.query.empId + (
                                urlParts[1] ? ('#' + urlParts[1]) : ''
                            );
                    }
                    var token = decodeURIComponent(this.query.zkxToken) + ';path=/';
                    return RongWork.loginServer + '/sign-bridge.html' +
                        '?target=' + encodeURIComponent(pageUrl) +
                        '&empId=' + (this.query.empId || '') +
                        '&token=' + encodeURIComponent(token);
                },
                onLoadApps: function () {
                    var context = this;
                    var params = {
                        id: this.query.targetId
                    };
                    var targetUrl = this.query.targetUrl;
                    if (targetUrl) {
                        targetUrl = decodeURIComponent(targetUrl);
                        allApps.some(function (app) {
                            if (context.pageUrl(app) === targetUrl) {
                                params.id = app.id;
                                return true;
                            }
                        });
                    }
                    if (params.id) {
                        this.openApp(params);
                    }
                },
                isWebPlatform: function () {
                    var platform = browserWindow.getPlatform();
                    return platform.indexOf('web') !== -1;
                }
            }
        });
        //watchClose(work);
        RongWork.instance = work;
    }

    function validUrl(str) {
        var reg = /^(http|https):\/\/\S+$/;
        return reg.test(str);
    }
    //获取tab列表
    function getTabList(){

    }
    //获取待办列表
    function getTudoList(){
        
        serverApi.getTabList((res)=>{
            
        })
    }
    function getQuery(str) {
        var query = {};
        if (str) {
            var ss = str.indexOf('?');
            if (ss === -1) {
                str = '';
            } else if (ss !== 0) {
                str = str.substring(ss);
            }
        } else {
            str = window.location.search;
        }
        if (str) {
            str.substring(1).split('&').forEach(function (item) {
                var arr = item.split('=');
                query[arr[0]] = arr[1];
            });
        }
        console.info(query);
        return query;
    }

    function getNameByUrl(field, url) {
        // eslint-disable-next-line no-undef
        const href = url || window.location.href;
        const reg = new RegExp(`[?&]${field}=([^&#]*)`, 'i');
        const string = reg.exec(href);
        console.log(decodeURIComponent(decodeURIComponent(string[1])))
        return string ? decodeURIComponent(decodeURIComponent(string[1])) : null;
    };

    function getAppList(context) {
        serverApi.getFavApps(context.query.userId, function (errorCode, result) {
            if (result && result.apps && result.apps.length > 0) {
                serverApi.getLikeApps(function (error, likeAppResult) {
                    context.allApps = result.apps.map(function (item) {
                        // 判断web端https方式登录程序
                        if (location.protocol == 'https:' && context.isWebPlatform() && item.logo_url.indexOf('8086') != -1) {
                            item.logo_url = 'https://work.cast.org.cn:1446' + item.logo_url.split('8086')[1]
                        }
                        if (!item.favorite && likeAppResult && likeAppResult.apps) {
                            item.favorite = likeAppResult.apps.some(function (appId) {
                                return (item.id === appId);
                            });
                        }
                        // eslint-disable-next-line eqeqeq
                        if (item.type == 1) {
                            item.type = BaseApp;
                        }
                        return item;
                    });
                    context.filterApps();
                });
            }
        });
    }

    function initWebview(item, context) {
        if (!item) {
            return;
        }
        var id = item.id;
        var webview = context.$refs[id];
        if ($.isArray(webview)) {
            webview = webview[0];
        }
        context.canGoBack = false;
        context.canGoForward = false;
        context.canReload = validUrl(context.pageUrl(item));
        if (webview) {
            if (webview.getWebContents) {
                var ses = webview.getWebContents().session;
                var token = decodeURIComponent(context.query.zkxToken).split('=');
                ses.cookies.remove(context.pageUrl(item), 'JSESSIONID', function () {});
                ses.cookies.set({
                    url: RongWork.loginServer,
                    name: token[0],
                    value: token[1],
                    path: '/'
                }, function (err) {});
                ses.cookies.flushStore(function () {});
            }
            webview.addEventListener('new-window', function (event) {
                var url = event.url;
                if (url.startsWith('http:') || url.startsWith('https:')) {
                    openExternal(context.bridgeUrl(url));
                }
            });
            webview.addEventListener('did-navigate', function (event) {
                if (context.currentTab.id === id) {
                    context.canGoBack = webview.canGoBack && webview.canGoBack();
                    context.canGoForward = webview.canGoForward && webview.canGoForward();
                }
            });
            webview.addEventListener('console-message', function (event) {
                if (/#关闭.*页面#/.test(event.message)) context.closeTab(item);
            });
        }
    }

    /*function watchClose(context) {
        window.onbeforeunload = function () {
            if (!confirmeQuit) {
                RongWork.browserWindow.focus();
                // context.closeBefore = true;
                utils.messagebox({
                    type: 'confirm',
                    message: context.locale.closeWorkTip,
                    callback: function () {
                        confirmeQuit = true;
                        RongWork.browserWindow.close();
                    }
                });
                return true;
            }
            return undefined;
        };
    }*/

    RongWork.init = init;
}(window.RongWork));