import { SentryEvent, SentryResponse } from '@sentry/types';
import { BaseBackend, Scope } from '@sentry/core';
import { CommonBackend, ElectronOptions } from '../common';
/**
 * Retruns a promise that resolves when app is ready.
 */
export declare function isAppReady(): Promise<boolean>;
/** Backend implementation for Electron renderer backends. */
export declare class MainBackend extends BaseBackend<ElectronOptions> implements CommonBackend {
    /** The inner SDK used to record Node events. */
    private readonly inner;
    /** Store to persist context information beyond application crashes. */
    private readonly scopeStore;
    /** Uploader for minidump files. */
    private uploader?;
    /** Creates a new Electron backend instance. */
    constructor(options: ElectronOptions);
    /**
     * @inheritDoc
     */
    install(): boolean;
    /**
     * @inheritDoc
     */
    eventFromException(exception: any): Promise<SentryEvent>;
    /**
     * @inheritDoc
     */
    eventFromMessage(message: string): Promise<SentryEvent>;
    /**
     * @inheritDoc
     */
    sendEvent(event: SentryEvent): Promise<SentryResponse>;
    /**
     * Uploads the given minidump and attaches event information.
     *
     * @param path A relative or absolute path to the minidump file.
     * @param event Optional event information to add to the minidump request.
     * @returns A promise that resolves to the status code of the request.
     */
    uploadMinidump(path: string, event?: SentryEvent): Promise<SentryResponse>;
    /**
     * @inheritDoc
     */
    storeScope(scope: Scope): void;
    /** Returns whether native reports are enabled. */
    private isNativeEnabled;
    /** Activates the Electron CrashReporter. */
    private installNativeHandler;
    /** Installs IPC handlers to receive events and metadata from renderers. */
    private installIPC;
    /** Loads new native crashes from disk and sends them to Sentry. */
    private sendNativeCrashes;
    /** Returns extra information from a renderer's web contents. */
    private getRendererExtra;
}
