import { BaseClient, Scope } from '@sentry/core';
import { Breadcrumb, SentryBreadcrumbHint, SentryEvent, SentryEventHint, SentryResponse } from '@sentry/types';
import { CommonClient, ElectronOptions } from '../common';
import { MainBackend } from './backend';
/** SDK version used in every event. */
export declare const SDK_VERSION: string;
/** Frontend implementation for Electron renderer backends. */
export declare class MainClient extends BaseClient<MainBackend, ElectronOptions> implements CommonClient {
    /**
     * Creates a new Electron SDK instance.
     * @param options Configuration options for this SDK.
     */
    constructor(options: ElectronOptions);
    /**
     * @inheritDoc
     */
    protected prepareEvent(event: SentryEvent, scope?: Scope, hint?: SentryEventHint): Promise<SentryEvent | null>;
    /**
     * Uploads a native crash dump (Minidump) to Sentry.
     *
     * @param path The relative or absolute path to the minidump.
     * @param event Optional event payload to attach to the minidump.
     * @param scope Optional SDK scope used to upload.
     */
    captureMinidump(path: string, event?: SentryEvent, scope?: Scope): Promise<void>;
    /**
     * @inheritDoc
     */
    captureEvent(event: SentryEvent, hint?: SentryEventHint, scope?: Scope): Promise<SentryResponse>;
    /**
     * @inheritDoc
     */
    addBreadcrumb(breadcrumb: Breadcrumb, hint?: SentryBreadcrumbHint, scope?: Scope): void;
    /**
     * Does nothing in main/node
     */
    showReportDialog(_: any): void;
}
