"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@sentry/core");
const node_1 = require("@sentry/node");
const types_1 = require("@sentry/types");
const electron_1 = require("electron");
const backend_1 = require("../backend");
/** Using net module of electron */
class NetTransport extends node_1.Transports.BaseTransport {
    /** Create a new instance and set this.agent */
    constructor(options) {
        super(options);
        this.options = options;
        /** A simple buffer holding all requests. */
        this.buffer = new core_1.PromiseBuffer(30);
    }
    /**
     * @inheritDoc
     */
    sendEvent(body) {
        return __awaiter(this, void 0, void 0, function* () {
            yield backend_1.isAppReady();
            return this.buffer.add(new Promise((resolve, reject) => {
                const req = electron_1.net.request(this.getRequestOptions());
                req.on('error', reject);
                req.on('response', (res) => {
                    if (res.statusCode && res.statusCode >= 200 && res.statusCode < 300) {
                        resolve({
                            status: types_1.Status.fromHttpCode(res.statusCode),
                        });
                    }
                    else {
                        // tslint:disable:no-unsafe-any
                        if (res.headers && res.headers['x-sentry-error']) {
                            const reason = res.headers['x-sentry-error'];
                            // tslint:enable:no-unsafe-any
                            reject(new core_1.SentryError(`HTTP Error (${res.statusCode}): ${reason}`));
                        }
                        else {
                            reject(new core_1.SentryError(`HTTP Error (${res.statusCode})`));
                        }
                    }
                    // force the socket to drain
                    res.on('data', () => {
                        // Drain
                    });
                    res.on('end', () => {
                        // Drain
                    });
                });
                req.write(body);
                req.end();
            }));
        });
    }
}
exports.NetTransport = NetTransport;
//# sourceMappingURL=net.js.map