import { BaseBackend, Scope } from '@sentry/core';
import { Breadcrumb, SentryEvent, SentryEventHint, SentryResponse, Severity } from '@sentry/types';
import { CommonBackend, ElectronOptions } from '../common';
/** Backend implementation for Electron renderer backends. */
export declare class RendererBackend extends BaseBackend<ElectronOptions> implements CommonBackend {
    /** The inner SDK used to record JavaScript events. */
    private readonly inner;
    /** Creates a new Electron backend instance. */
    constructor(options: ElectronOptions);
    /**
     * @inheritDoc
     */
    install(): boolean;
    /**
     * @inheritDoc
     */
    eventFromException(exception: any, hint?: SentryEventHint): Promise<SentryEvent>;
    /**
     * @inheritDoc
     */
    eventFromMessage(message: string, level?: Severity, hint?: SentryEventHint): Promise<SentryEvent>;
    /**
     * @inheritDoc
     */
    sendEvent(event: SentryEvent): Promise<SentryResponse>;
    /**
     * @inheritDoc
     */
    storeBreadcrumb(_: Breadcrumb): boolean;
    /**
     * @inheritDoc
     */
    storeScope(scope: Scope): void;
    /** Returns whether JS is enabled. */
    private isJavaScriptEnabled;
    /** Returns whether native reports are enabled. */
    private isNativeEnabled;
    /** Activates the Electron CrashReporter. */
    private installNativeHandler;
    /** Checks if the main processes is available and logs a warning if not. */
    private pingMainProcess;
}
