/// <reference types="node" />
import { SentryEvent } from '@sentry/types';
/**
 * Requires a module which is protected against bundler minification.
 *
 * @param request The module path to resolve
 */
export declare function dynamicRequire(mod: NodeModule, request: string): any;
/**
 * Checks whether we're in the Node.js or Browser environment
 *
 * @returns Answer to given question
 */
export declare function isNodeEnv(): boolean;
/**
 * Safely get global scope object
 *
 * @returns Global scope object
 */
export declare function getGlobalObject(): Window | NodeJS.Global | {};
/**
 * UUID4 generator
 *
 * @returns string Generated UUID4.
 */
export declare function uuid4(): string;
/**
 * Given a child DOM element, returns a query-selector statement describing that
 * and its ancestors
 * e.g. [HTMLElement] => body > div > input#foo.btn[name=baz]
 * @returns generated DOM path
 */
export declare function htmlTreeAsString(elem: Node): string;
/**
 * Returns a simple, query-selector representation of a DOM element
 * e.g. [HTMLElement] => input#foo.btn[name=baz]
 * @returns generated DOM path
 */
export declare function htmlElementAsString(elem: HTMLElement): string;
/**
 * Parses string form of URL into an object
 * // borrowed from https://tools.ietf.org/html/rfc3986#appendix-B
 * // intentionally using regex and not <a/> href parsing trick because React Native and other
 * // environments where DOM might not be available
 * @returns parsed URL object
 */
export declare function parseUrl(url: string): {
    host?: string;
    path?: string;
    protocol?: string;
    relative?: string;
};
/**
 * Extracts either message or type+value from an event that can be used for user-facing logs
 * @returns event's description
 */
export declare function getEventDescription(event: SentryEvent): string;
/** JSDoc */
export declare function consoleSandbox(callback: () => any): any;
