const {
    ipcRenderer,
    remote,
    shell,
} = require('electron');

const { BrowserWindow } = remote;

const currentWindow = remote.getCurrentWindow();
const BrowserWin = require('../browser_window_new/browser_window.render.js');

let configInfo;

try {
    configInfo = remote.require('./config.js');
} catch (err) {
    configInfo = null;
}

// 浏览器环境运行
const window = global;

window.RongDesktop = {
    shell,
    ipcRenderer,
    configInfo,
    require,
    remote,
    platform: process.platform,
    child_process: require('child_process'),
    workAppsPreloadPath: __filename,
    Win: {
        on(event, listener) {
            currentWindow.on(event, listener);
        },
        max() {
            currentWindow.maximize();
        },
        unmax() {
            currentWindow.unmaximize();
        },
        min() {
            currentWindow.minimize();
        },
        restore() {
            currentWindow.restore();
        },
        close() {
            currentWindow.close();
        },
        bringFront() {
            currentWindow.setAlwaysOnTop(false);
        },
        focus() {
            currentWindow.focus();
        },
        showInactive() {
            currentWindow.showInactive();
        },
        show(show) {
            if (show) {
                currentWindow.show();
            } else {
                currentWindow.hide();
            }
        },
        enterPublic(params, callback) {
            ipcRenderer.send('openConversation', params);
            callback();
        },
    },
    Extra: {
        enableVueDevtool(toolPath) {
            if (configInfo.DEBUG) {
                BrowserWindow.addDevToolsExtension(toolPath);
            }
        },
    },
    BrowserWin,
};
