// const getModulePath = require('../../utils').getModulePath;
// const sqlite3 = require(getModulePath({
//     path: './{platform}/sqlite3'
// })).verbose();
const { app } = require('electron').remote;
const path = require('path');
const fs = require('fs');
const sqlite3 = require('./sqlite3').verbose();

const dbFileName = 'sqlcipher';
const basePath = path.join(app.getPath('userData'), 'storage');
let instance = null;
const noop = function () {};

function dbFileDir(appkey, userId) {
    return path.join(basePath, appkey, userId);
}
function dbFilePath(appkey, userId) {
    return path.join(dbFileDir(appkey, userId), dbFileName);
}

function mkdir(targetPath) {
    const parent = path.join(targetPath, '..');
    if (!fs.existsSync(parent)) {
        mkdir(parent);
    }
    if (!fs.existsSync(targetPath)) {
        fs.mkdirSync(targetPath);
    }
}

function init(appkey, userId, callback) {
    close();
    mkdir(dbFileDir(appkey, userId));
    try {
        instance = new sqlite3.Database(dbFilePath(appkey, userId));
    } catch (error) {
        callback(error);
        return;
    }
    instance.serialize(() => {
        instance.run(`PRAGMA key = '${[appkey, userId].join('')}'`);
        callback(null);
    });
}

function existsSync(appkey, userId) {
    return fs.existsSync(dbFilePath(appkey, userId));
}

function exec(sql, callback) {
    callback = callback || noop;
    if (!instance) {
        callback('Not initialized');
        return;
    }
    instance.exec(sql, callback);
}

function get(sql, params, callback) {
    callback = callback || noop;
    if (typeof params === 'function') {
        callback = params;
    }
    if (!instance) {
        callback('Not initialized');
        return;
    }
    instance.get(sql, params, callback);
}

function all(sql, params, callback) {
    callback = callback || noop;
    if (typeof params === 'function') {
        callback = params;
    }
    if (!instance) {
        callback('Not initialized');
        return;
    }
    instance.all(sql, params, callback);
}

// function serialize(callback) {
//     callback = callback || noop;
//     if (typeof params === 'function') {
//         callback = params;
//     }
//     if (!instance) {
//         callback('Not initialized');
//         return;
//     }
//     instance.serialize(callback);
// }

function prepare(sql, params, callback) {
    callback = callback || noop;
    if (typeof params === 'function') {
        callback = params;
    }
    if (!instance) {
        callback('Not initialized');
        return null;
    }
    return instance.prepare(sql, params, callback);
}

function close(callback) {
    callback = callback || noop;
    if (instance) {
        instance.close(callback);
        instance = null;
    } else {
        callback();
    }
}

function clean(appkey, userId) {
    close(() => {
        fs.unlink(dbFilePath(appkey, userId), () => {});
    });
}

module.exports = {
    init,
    existsSync,
    exec,
    all,
    get,
    prepare,
    close,
    clean,
    // serialize,
};
