 ; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

#define MyAppName "科协一家"
#define MyCompanyName "中国科协"
#define MyAppVersion "1.9.0"
#define MyAppVersionCode "1"
#define MyAppCopyright "Copyright (C) RongCloud, Inc."
#define MyAppPublisher "中国科协信息中心"
#define MyAppURL "http://www.rongcloud.cn/"
#define MyAppExeName "科协一家.exe"     
#define UninstallName "Uninstall"
#define BaseDir "D:\code\pc1.6.9"
#define Protocal "科协一家"

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)

;appid需更新
AppId={{A4DA116F-A0EC-4218-AF05-B91902765B8D}
AppName={#MyAppName}
;AppVersion={#MyAppVersion}
;AppMutex={#MyAppName}
SetupMutex=SetupMutex{#SetupSetting("AppId")}
AppVerName={#MyAppName}

AppPublisher={#MyAppPublisher}

VersionInfoVersion="{#MyAppVersion}.{#MyAppVersionCode}"
VersionInfoProductVersion={#MyAppVersion}
VersionInfoCopyright={#MyAppCopyright}
VersionInfoCompany={#MyCompanyName}

AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}
DefaultDirName={pf}\{#MyAppName}
;DefaultDirName=C:\Program Files\{#MyCompanyName}
DisableDirPage=auto
;DisableProgramGroupPage=yes
DefaultGroupName={#MyCompanyName}
LicenseFile={#BaseDir}\LICENSE
;InfoBeforeFile=E:\myWork\Electron\sealtalk-desktop-Ent\setup_info_before.txt
;InfoAfterFile=E:\myWork\Electron\sealtalk-desktop-Ent\setup_info_after.txt
OutputDir={#BaseDir}\dist
OutputBaseFilename=hicast
SetupIconFile={#BaseDir}\res\app.ico
UninstallDisplayIcon={app}\{#MyAppExeName}
Compression=lzma
SolidCompression=yes
Uninstallable=yes
;UninstallDisplayName=卸载{#MyAppName}
ShowLanguageDialog=no


[Languages]
Name: "en"; MessagesFile: "compiler:Default.isl"
Name: "zh"; MessagesFile: "compiler:Languages\Unofficial\ChineseSimplified.isl"

[CustomMessages]
en.InstallAppRuningTip=The program is running, please exit and run the installation.
en.UninstallAppRuningTip=The program is running, please exit and run the uninstallation.
zh.InstallAppRuningTip=检测到科协一家正在运行，请退出运行后再进行安装。
zh.UninstallAppRuningTip=检测到科协一家正在运行，请退出运行后再进行卸载。

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}";

[Files]
Source: "{#BaseDir}\build\{#MyAppName}-win32-ia32\{#MyAppExeName}"; DestDir: "{app}"; Flags: ignoreversion
Source: "{#BaseDir}\build\{#MyAppName}-win32-ia32\*"; DestDir: "{app}"; Flags: ignoreversion recursesubdirs createallsubdirs
; NOTE: Don't use "Flags: ignoreversion" on any shared system files
; Visual C++ redist
Source: "vc_redist.x86.exe"; DestDir: {tmp}; Flags: deleteafterinstall

[InstallDelete]
Type: filesandordirs; Name: {app}\{#MyCompanyName}
Type: filesandordirs; Name: {userappdata}\{#MyAppName}\Cache
;Type: filesandordirs; Name: {userappdata}\{#MyAppName}

[UninstallDelete]
Type: filesandordirs; Name: "{app}\{#MyCompanyName}"    
Type: filesandordirs; Name: "{app}\locales"
Type: filesandordirs; Name: "{app}\resources"
Type: filesandordirs; Name: "{userappdata}\{#MyAppName}"

[Icons]
Name: "{group}\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"        
Name: "{group}\{cm:UninstallProgram,{#MyAppName}}"; Filename: "{uninstallexe}"   
;Name: "{group}\{#UninstallName} {#MyAppName}"; Filename: "{uninstallexe}"
Name: "{commondesktop}\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"; Tasks: desktopicon

[Registry]
Root: HKCR; SubKey: {#Protocal}; ValueData: "RCE Protocol"; ValueType: string; Flags: CreateValueIfDoesntExist UninsDeleteKey;
Root: HKCR; SubKey: {#Protocal}; ValueName: "URL Protocol"; Flags: CreateValueIfDoesntExist; ValueType: string;
Root: HKCR; SubKey: {#Protocal}\DefaultIcon; ValueData: "{app}\{#MyAppExeName}"; Flags: CreateValueIfDoesntExist; ValueType: string;
Root: HKCR; SubKey: {#Protocal}\shell\open\command; ValueData:"{app}\{#MyAppExeName} ""%1"""; Flags: CreateValueIfDoesntExist; ValueType: string;

[Run]
Filename: "{app}\{#MyAppExeName}"; Description: "{cm:LaunchProgram,{#StringChange(MyAppName, '&', '&&')}}"; Flags: nowait postinstall skipifsilent
; add the Parameters, WorkingDir and StatusMsg as you wish, just keep here
; the conditional installation Check
;Filename: "{tmp}\vc_redist.x86.exe"; Check: VCRedistNeedsInstall

Filename: {tmp}\vc_redist.x86.exe; Parameters: /q; WorkingDir: {tmp}; Flags: skipifdoesntexist; StatusMsg: "Installing Microsoft Visual C++ Runtime ..."; Check: VCRedistNeedsInstall


[Code]

function IsAppRunning(const FileName : string): Boolean;
var
    FSWbemLocator: Variant;
    FWMIService   : Variant;
    FWbemObjectSet: Variant;
begin
    Result := false;
    FSWbemLocator := CreateOleObject('WBEMScripting.SWBEMLocator');
    FWMIService := FSWbemLocator.ConnectServer('', 'root\CIMV2', '', '');
    FWbemObjectSet := FWMIService.ExecQuery(Format('SELECT Name FROM Win32_Process Where Name="%s"',[FileName]));
    Result := (FWbemObjectSet.Count > 0);
    FWbemObjectSet := Unassigned;
    FWMIService := Unassigned;
    FSWbemLocator := Unassigned;
end;

function InitializeSetup(): Boolean;
begin
   //MsgBox(  ExpandConstant('{pf}'), mbError, MB_OK );
  if IsAppRunning('{#MyAppExeName}') then
  begin
    MsgBox( CustomMessage('InstallAppRuningTip'), mbError, MB_OK );
    Result := false;
  end
  else 
    Result := true;
End;

function InitializeUninstall(): Boolean;
begin
  // check if application is running
  if IsAppRunning('{#MyAppExeName}') then
  begin
    MsgBox( CustomMessage('UninstallAppRuningTip'), mbError, MB_OK );
    Result := false;
  end
  else 
    Result := true;
End;


//install vcredist_x86.exe

#IFDEF UNICODE
  #DEFINE AW "W"
#ELSE
  #DEFINE AW "A"
#ENDIF
type
  INSTALLSTATE = Longint;
const
  INSTALLSTATE_INVALIDARG = -2;  { An invalid parameter was passed to the function. }
  INSTALLSTATE_UNKNOWN = -1;     { The product is neither advertised or installed. }
  INSTALLSTATE_ADVERTISED = 1;   { The product is advertised but not installed. }
  INSTALLSTATE_ABSENT = 2;       { The product is installed for a different user. }
  INSTALLSTATE_DEFAULT = 5;      { The product is installed for the current user. }

  VC_2005_REDIST_X86 = '{A49F249F-0C91-497F-86DF-B2585E8E76B7}';
  VC_2005_REDIST_X64 = '{6E8E85E8-CE4B-4FF5-91F7-04999C9FAE6A}';
  VC_2005_REDIST_IA64 = '{03ED71EA-F531-4927-AABD-1C31BCE8E187}';
  VC_2005_SP1_REDIST_X86 = '{7299052B-02A4-4627-81F2-1818DA5D550D}';
  VC_2005_SP1_REDIST_X64 = '{071C9B48-7C32-4621-A0AC-3F809523288F}';
  VC_2005_SP1_REDIST_IA64 = '{0F8FB34E-675E-42ED-850B-29D98C2ECE08}';
  VC_2005_SP1_ATL_SEC_UPD_REDIST_X86 = '{837B34E3-7C30-493C-8F6A-2B0F04E2912C}';
  VC_2005_SP1_ATL_SEC_UPD_REDIST_X64 = '{6CE5BAE9-D3CA-4B99-891A-1DC6C118A5FC}';
  VC_2005_SP1_ATL_SEC_UPD_REDIST_IA64 = '{85025851-A784-46D8-950D-05CB3CA43A13}';

  VC_2008_REDIST_X86 = '{FF66E9F6-83E7-3A3E-AF14-8DE9A809A6A4}';
  VC_2008_REDIST_X64 = '{350AA351-21FA-3270-8B7A-835434E766AD}';
  VC_2008_REDIST_IA64 = '{2B547B43-DB50-3139-9EBE-37D419E0F5FA}';
  VC_2008_SP1_REDIST_X86 = '{9A25302D-30C0-39D9-BD6F-21E6EC160475}';
  VC_2008_SP1_REDIST_X64 = '{8220EEFE-38CD-377E-8595-13398D740ACE}';
  VC_2008_SP1_REDIST_IA64 = '{5827ECE1-AEB0-328E-B813-6FC68622C1F9}';
  VC_2008_SP1_ATL_SEC_UPD_REDIST_X86 = '{1F1C2DFC-2D24-3E06-BCB8-725134ADF989}';
  VC_2008_SP1_ATL_SEC_UPD_REDIST_X64 = '{4B6C7001-C7D6-3710-913E-5BC23FCE91E6}';
  VC_2008_SP1_ATL_SEC_UPD_REDIST_IA64 = '{977AD349-C2A8-39DD-9273-285C08987C7B}';
  VC_2008_SP1_MFC_SEC_UPD_REDIST_X86 = '{9BE518E6-ECC6-35A9-88E4-87755C07200F}';
  VC_2008_SP1_MFC_SEC_UPD_REDIST_X64 = '{5FCE6D76-F5DC-37AB-B2B8-22AB8CEDB1D4}';
  VC_2008_SP1_MFC_SEC_UPD_REDIST_IA64 = '{515643D1-4E9E-342F-A75A-D1F16448DC04}';

  VC_2010_REDIST_X86 = '{196BB40D-1578-3D01-B289-BEFC77A11A1E}';
  VC_2010_REDIST_X64 = '{DA5E371C-6333-3D8A-93A4-6FD5B20BCC6E}';
  VC_2010_REDIST_IA64 = '{C1A35166-4301-38E9-BA67-02823AD72A1B}';
  VC_2010_SP1_REDIST_X86 = '{F0C3E5D1-1ADE-321E-8167-68EF0DE699A5}';
  VC_2010_SP1_REDIST_X64 = '{1D8E6291-B0D5-35EC-8441-6616F567A0F7}';
  VC_2010_SP1_REDIST_IA64 = '{88C73C1C-2DE5-3B01-AFB8-B46EF4AB41CD}';

  { Microsoft Visual C++ 2012 x86 Minimum Runtime - 11.0.61030.0 (Update 4) }
  VC_2012_REDIST_MIN_UPD4_X86 = '{BD95A8CD-1D9F-35AD-981A-3E7925026EBB}';
  VC_2012_REDIST_MIN_UPD4_X64 = '{CF2BEA3C-26EA-32F8-AA9B-331F7E34BA97}';
  { Microsoft Visual C++ 2012 x86 Additional Runtime - 11.0.61030.0 (Update 4)  }
  VC_2012_REDIST_ADD_UPD4_X86 = '{B175520C-86A2-35A7-8619-86DC379688B9}';
  VC_2012_REDIST_ADD_UPD4_X64 = '{37B8F9C7-03FB-3253-8781-2517C99D7C00}';

  { Visual C++ 2013 Redistributable 12.0.21005 }
  VC_2013_REDIST_X86_MIN = '{13A4EE12-23EA-3371-91EE-EFB36DDFFF3E}';
  VC_2013_REDIST_X64_MIN = '{A749D8E6-B613-3BE3-8F5F-045C84EBA29B}';

  VC_2013_REDIST_X86_ADD = '{F8CFEB22-A2E7-3971-9EDA-4B11EDEFC185}';
  VC_2013_REDIST_X64_ADD = '{929FBD26-9020-399B-9A7A-751D61F0B942}';

  { Visual C++ 2015 Redistributable 14.0.23026 }
  VC_2015_REDIST_X86_MIN = '{A2563E55-3BEC-3828-8D67-E5E8B9E8B675}';
  VC_2015_REDIST_X64_MIN = '{0D3E9E15-DE7A-300B-96F1-B4AF12B96488}';

  VC_2015_REDIST_X86_ADD = '{BE960C1C-7BAD-3DE6-8B1A-2616FE532845}';
  VC_2015_REDIST_X64_ADD = '{BC958BD2-5DAC-3862-BB1A-C1BE0790438D}';

  { Visual C++ 2015 Redistributable 14.0.24210 }
  //VC_2015_REDIST_X86 = '{8FD71E98-EE44-3844-9DAD-9CB0BBBC603C}';
  //VC_2015_REDIST_X64 = '{C0B2C673-ECAA-372D-94E5-E89440D087AD}';

  { Visual C++ 2015 Redistributable 14.0.23918 }
  //VC_2015_REDIST_X86 = '{DFFEB619-5455-3697-B145-243D936DB95B}';

  { Visual C++ 2015 Redistributable 14.0.23026 }
  //VC_2015_REDIST_X86 = '{74d0e5db-b326-4dae-a6b2-445b9de1836e}';

  //{HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{DFFEB619-5455-3697-B145-243D936DB95B}}

function MsiQueryProductState(szProduct: string): INSTALLSTATE; 
  external 'MsiQueryProductState{#AW}@msi.dll stdcall';

function VCVersionInstalled(const ProductID: string): Boolean;
begin
  Result := MsiQueryProductState(ProductID) = INSTALLSTATE_DEFAULT;
end;

function VCRedistNeedsInstall: Boolean;
begin
  { here the Result must be True when you need to install your VCRedist }
  { or False when you don't need to, so now it's upon you how you build }
  { this statement, the followi
  ng won't install your VC redist only when }
  { the Visual C++ 2010 Redist (x86) and Visual C++ 2010 SP1 Redist(x86) }
  { are installed for the current user }
  {Result := not (VCVersionInstalled(VC_2010_REDIST_X86) and 
    VCVersionInstalled(VC_2010_SP1_REDIST_X86));   }
  Result := not (VCVersionInstalled(VC_2015_REDIST_X86_MIN) or VCVersionInstalled(VC_2015_REDIST_X86_ADD));
end;

//function NextButtonClick(CurPageID: Integer): Boolean;
//begin
  //Result := True;
  { if we're on the directory selection page and the value returned by }
  { the WizardDirValue function contains at least one space, then... }
  //if (CurPageID = wpSelectDir) and (Pos(' ', WizardDirValue) > 0) then
  //begin
    //Result := False;
    //MsgBox('Target installation directory cannot contain spaces. ' +
      //'Choose a different one.', mbError, MB_OK);
  //end;
//end;
