(function (RongIM, dependencies, components) {
  'use strict';

  var common = RongIM.common;

  RongIM.dialog.cardDialog = function (targetUserId) {
    console.log(targetUserId)
    var im = RongIM.instance;
    var dataModel = im.dataModel;
    var options = {
          name: 'card-dialog',
          template: 'templates/blish/card-dialog.html',
          data: function () {
            var canNotSelected = [];
            if (targetUserId) {
                canNotSelected = [targetUserId];
            }
              return {
                  canNotSelected: canNotSelected,
                  showDialog: true,
                  //config tab Title
                  configTabTitle:[{
                      name: RongIM.locale.zh.blish.orgContact,
                      id: 'org'
                  },{
                      name: RongIM.locale.zh.blish.friend,
                      id: 'follow'
                  },{
                    name: RongIM.locale.zh.blish.myMailList,
                    id: 'phone'
                  }],
                  // config selected list
                  configSeleList:[{
                    name: RongIM.locale.zh.blish.dropDownAll,
                    type: 'all',
                    id: '3'
                  },{
                      name: RongIM.locale.zh.blish.dropDownCompany,
                      type: 'company',
                      id: '2'
                  },{
                      name: RongIM.locale.zh.blish.dropDownDepart,
                      type: 'depart',
                      id: '0'
                  },{
                      name: RongIM.locale.zh.blish.dropDownWorkingGroup,
                      type: 'staff',
                      id: '1'
                  }],
                  treeTitle: RongIM.locale.zh.blish.orgContact,
                  // 当前选中的头部tab
                  itemTabParam: {},
                  // 当前选中的下拉
                  itemSeleParam: {
                    index: 0,
                    item: {}
                  },
                  selectedTreeItemParams: null,
                  // 弹窗入口区分
                  dialogEntry: "",
                  // 搜索关键字
                  searchKey: "",
                  // 搜索状态： star 搜索中 end 搜索结束 empty 搜索没结果
                  searchStatus: "",
                  // 选中人员集合
                  selected: [],
                  //是否保存为群聊
                  isStorge: false,
                  // 群组名称
                  groupName: '',
                  defaultSelected: []
                  
              };
          },
          components: {
              'tab-title': components.tabTitle,
              'search-deprt': components.searchDeprt,
              "dialog-tree-list": components.dialogTreeList,
              dialogRight: components.dialogRight
          },
          computed: {
            groupIdExisted: function () {
              return !utils.isEmpty(this.groupId);
            },
          },
          created: function () {
              this.itemTabParam = this.configTabTitle[0];
              this.itemSeleParam.item= this.configSeleList[0];
          },
          mounted: function () {
            var context = this;
            var messageApi = dataModel.Message;
            messageApi.watch(function (newMessage) {
                if (newMessage.content && newMessage.messageType === 'RecallCommandMessage') {
                    if (message.messageUId === newMessage.content.messageUId) {
                        // 转发的消息被撤回
                        var tip = context.locale.forwardedFailed;
                        context.showMessage({
                            type: 'error',
                            message: tip,
                            callback: function () {
                                context.busy = false;
                                context.close();
                            }
                        });
                    }
                }
            });
          },
          methods: getMethods(dataModel, im)
      };
      common.mountDialog(options, function (instance) {
        RongIM._groupInstance = instance;
      });
  };

  function getMethods(dataModel, im) {
      return {
        /**是否保存为群聊 */
        storeDayGroup(){
          this.isStorge = !this.isStorge;
        },
        // 当前选中人员
        allSeleChange(newVal) {
          this.selected= newVal;
          this.defaultConcatSeleArr= this.defaultSelected.concat(newVal);
        },
        //当前点击的树形item
        itemMember(item,target){
          this.selectedTreeItemParams = item;
          if(item.nodeType){
            this.$refs.treeItem.getMailList(item)
          }else {
            this.$refs.treeItem.getItemList(item,{
              type: 'staff',
              scope: 'name,duty,mobile,staff_no',
              keyword: this.searchKey
            });
          }
        },
        //搜索关键字
        searchChange(val,sources,searchType){
          // this.searchStatus = type;
          this.searchKey = val;
          let params = {
            type: 'staff',
            tabId: this.itemTabParam.id,
            orgtype: this.itemSeleParam.item.id,
            keyword: this.searchKey,
            scope: 'name,duty,mobile,staff_no'
          };
          this.$refs.treeItem.getItemList(null,params,sources,searchType);
        },
        //当前选中的tab
        currentAvtive(tabItem){
          this.itemTabParam= tabItem;
          this.$refs.treeItem.resetParams();
          this.$refs.treeItem.clickItemTreeParam= null;
        },
        //当前选中的下拉
        seleChange(seleItem){
          this.itemSeleParam= seleItem;
        },
        // 当前点击的tree节点
        itemMember(item,target){
          if(item.nodeType){
            this.$refs.treeItem.getMailList(item)
          }else {
            this.$refs.treeItem.getItemList(item,{
              type: 'staff',
              scope: 'name,duty,mobile,staff_no',
              keyword: this.searchKey
            });
          }
        },
        /**将创建的群添加到群聊 */
        addDayGroup(groupId,groupApi){
          groupApi.addToFav(groupId,function(errorCode){
            if (errorCode) {
              common.toastError(errorCode);
              return;
            }
          })
        },
        close() {
          this.showDialog = false;
        },
        submit: function () {
          var routeParams = im.$route.params;
          var conversationType = parseInt(routeParams.conversationType);
          var targetId = routeParams.targetId;
          // 已选用户信息，名片只允许选择 1 个取数组第一个即可
          var user = this.selected[0];
          var params = {
              conversationType: conversationType,
              targetId: targetId,
              user: {
                  userId: user.id,
                  name: user.name,
                  portraitUri: user.avatar,
                  sendUserId: im.loginUser.id,
                  sendUserName: im.loginUser.name,
                  extra: '',
                  type: user.type
              }
          };
          sendCardMessage(dataModel.Message, params);
          this.close();
        }
      };
    /*
    说明： 发送名片消息
    */
    function sendCardMessage(messageApi, params) {
      if (sendCardMessage.busy) {
          return;
      }
      sendCardMessage.busy = true;
      messageApi.sendCard(params, function (errorCode) {
          sendCardMessage.busy = false;
          if (errorCode) {
              common.toastError(errorCode);
          }
      });
    }
  }
}(RongIM, {
  jQuery: jQuery,
  UploadClient: UploadClient
}, RongIM.components));