(function (RongIM, dependencies, components) {
    'use strict';
    var utils = RongIM.utils;
    var dialog = RongIM.dialog;
    var common = RongIM.common;
    var pageNum = RongIM.config.profile.pageNum;

    function transUrl(url) {
        return common.trans2Localfile(url, 'icons');
    }

    /**
     * title 组件
     * @params titleList 设置title的内容
     * @params isShow 是否显示title组件
     * @params currentAvtive 向外部传递当前点击项
     */

    components.dialogRight = function (resolve, reject) {
        var im = RongIM.instance;
        var dataModel = im.dataModel;
        var starApi = dataModel.Star;
        var friendApi = dataModel.Friend;
        var groupApi = dataModel.Group;
        var orgApi = dataModel.Organization;
        var userApi = dataModel.User;
        var publicTreeView = RongIM.treeView;
        var treeViewData = publicTreeView.treeViewData;
        var conversationApi = dataModel.Conversation;
        var options = {
            name: 'dialog-right',
            template: '#dialog-right',
            inject: ['reload'],
            props: {
                // 当前点击的tree节点
                requestTree: {
                    type: String,
                    default: () => { }
                },
                // 默认选中人员
                defaultSeleList: {
                    type: Array,
                    default: () => []
                },
                // 是否禁选自己
                isProhibitUser: {
                    type: Boolean,
                    default: true
                },
                // 是否禁选默认选中人员
                isProhibitDefaultList: {
                    type: Boolean,
                    default: true
                },
                // 是否可删除默认选中人员
                delDefauleSelected: {
                    type: Boolean,
                    default: false
                },
                // 搜索状态
                searchStatus: {
                    type: String,
                    default: ""
                },
                // dialog 入口区分(用于操作单个dialog的特殊情况)
                entryType: {
                    type: String,
                    default: ""
                },
                // 选中群组是 是否拍平群组(相当于选中群里的每一个成员,true) else 选中群组不拍平(false)
                isSeleGroupMember: {
                    type: Boolean,
                    default: true
                },
                // 不可选的成员 
                canNotSelected: {
                    type: Array,
                    default: () => []
                },
                // 是否单选
                singleElection: {
                    type: Boolean,
                    default: false
                },
                //是否是详情页面进来的
                isAddReceiver: {
                    type: Boolean,
                    default: false
                },
                //是否是通讯组
                isTxz: {
                    type: Boolean,
                    default: false
                }
            },

            data: function () {
                return {
                    itemTemp: {},
                    paramsTemp: {},
                    listFinished: false,
                    // itemList: [],
                    // 存放搜索结果
                    searchParamsList: [],
                    // 存放点击tree结果
                    membersParamsList: [],
                    // 当前点击的tree 节点
                    clickItemTreeParam: null,
                    // 已选人员列表
                    allSelecteds: [],
                    // 是否为群组
                    isGroup: false,
                    // 索引默认选中人员
                    defaultIndexItem: {},
                    // 最近联系人
                    recentList: [],
                    // 群聊
                    dayGroupsList: [],
                    // 外部联系人
                    dailysContactList: [],
                    // 重要联系人
                    KeyContactsContactList: [],
                    distributionGroupList: [], //通讯组
                    searchResult: {
                        id: '',
                        deptName: '',
                        members: [],
                        depts: [],
                        companies: []
                    },
                    searchStatusType: "",
                    // 重要联系人数组（用于本地搜索）
                    keContactsList: [],
                    isOpen: true,
                    selectedAllId: [],
                    groupArrId: [],
                    // 用户当前操作（搜索false，点击）
                    isClickTreeNode: true,
                    // 已选人眼列表和默认联系人列表的集合
                    selectedToDefaultAllList: [],
                    orgId: ""
                };
            },
            computed: {
                itemList: {
                    get: function () {
                        if (this.membersParamsList.length > 0 || this.searchParamsList.length > 0) {
                            let isNumber = this.membersParamsList.length > 0 && this.isClickTreeNode;
                            let item = isNumber ? this.membersParamsList : this.searchParamsList;
                            item.forEach((element, index) => {
                                if (!element.extDuties && element.vchar_p3) element.extDuties = this.strTurmObj(element.vchar_p3);
                                if (element.visible == 2) {
                                    element.selection = "disabled"
                                }
                                else if (element.itemNodeType == "group" && this.isSeleGroupMember) { // 群组
                                    element.selection = this.groupType(element.groupMembers);
                                } else if (this.selectedAllId.indexOf(element.id) != -1 && element.selection != "disabled") {
                                    element.selection = "selected";
                                } else if (!this.delDefauleSelected && this.defaultSeleList.indexOf(element.id) != -1) {
                                    element.selection = "selected";
                                } else if (element.selection != "disabled") {
                                    if (!this.delDefauleSelected && this.defaultIndexItem[element.id] == undefined) element.selection = "selectable";
                                    if (this.delDefauleSelected) element.selection = "selectable";
                                }
                            })
                            return item
                        }
                        return []
                    },
                    set: function () {
                        return this.membersParamsList
                    }
                },
                // 是否显示无数据提示
                isShowLoad() {
                    if (this.itemList.length > 0) {
                        return false
                    }
                    return true
                },
                // 全选按钮类型 ：可选selectable、已选selected、禁选indeterminate(有时群组为禁选)
                seleAllType() {
                    if (this.singleElection) return "electionAll"
                    if (this.itemList.length == 0) return "selectable";

                    let count = 0;
                    this.itemList.forEach((element, index) => {
                        if (element.selection == "selected" || element.selection == "disabled") {
                            count += 1;
                        }
                    })
                    if (count == this.itemList.length) { //全选
                        return "selected"
                    } else if (count > 0 && count < this.itemList.length) {
                        return "indeterminate"
                    } else {
                        return "selectable"
                    }
                },
                // 已选中人员count
                seleCount() {
                    let arr = !this.isAddReceiver ? publicTreeView.combine(this.defaultSeleList.concat(this.allSelecteds)) : this.defaultSeleList.concat(this.allSelecteds);
                    return arr.length
                },

            },
            filters: {},
            watch: {
                searchStatus: function (newVal) {
                    this.searchStatusType = newVal;
                },
                allSelecteds: function (newArr) {
                    this.selectedToDefaultAllList = publicTreeView.combine(newArr.concat(this.defaultSeleList));
                    this.$emit("allSeleChange", newArr);
                    this.$emit("allSeleDefaulrChange", this.selectedToDefaultAllList);
                },
                defaultSeleList: function (newArr) {
                    this.selectedToDefaultAllList = publicTreeView.combine(newArr.concat(this.allSelecteds));
                    this.$emit("allSeleDefaulrChange", this.selectedToDefaultAllList);
                    this.$emit("allSeleChange", newArr);
                }
            },
            components: {
                selected: components.selectedList,
                avatar: components.getAvatar,
            },
            created() {
                this.defaultListIndex();
                // 获取群聊
                if (this.entryType != "created") this.geCommunicateGroupList();
                // 获取最近联系人
                if (this.entryType == "forward") this.getRecentList();
                // 获取日常联系人
                this.getDailyContactList();
                // 获取重要联系人
                this.getKeyContactsList();
            },
            mounted: function () { },

            methods: {
                // 字符串分割数组转成对象
                strTurmObj(str) {
                    let arr = str.split(",");
                    let obj = {};
                    for (let i = 0; i < arr.length; i++) {
                        let newArr = arr[i].split(":");
                        obj[newArr[0]] = newArr[1];
                    }
                    return obj || ""
                },
                // 人员增加path
                addPath(list) {
                    let that = this;
                    list.forEach((item, index) => {

                        let pathCallBack = (res) => {
                            if (res.orgs_info && res.orgs_info.length > 0) {
                                item.path = res.orgs_info[0].path;
                                for (let i of res.orgs_info) {
                                    if (i.mainDepart == 1) item.path = i.path.path
                                }
                            }
                        };

                        let depathCallBack = (res) => {
                            item.extDuties = that.strTurmObj(res.vchar_p3);
                        }

                        // 增加path
                        if (!item.path) {
                            orgApi.getOrgPath(item.id, function (req, res) {
                                pathCallBack(res)
                            })
                        }

                        // 增加职务名称字段
                        if (!item.extDuties) {
                            orgApi.getOrgPath(item.id, function (req, res) {
                                depathCallBack(res)
                            })
                        }

                    })
                },
                loadMoreList() {
                    if (this.listFinished) {
                        this.$emit('nextPage')
                    }
                    // let that = this
                    // this.paramsTemp.page = 2
                    // orgApi.getMembers(this.itemTemp.id, params, function (result) {
                    //     if (result.data && result.data instanceof Array && result.data.length > 0) {
                    //         that.$emit('memberResult', result)
                    //         // that.membersParamsList = that.setItemList(result.data);
                    //         console.log('jklsdjflsfjlksjflkjsdlkf-------', that.setItemList(result.data))
                    //     }
                    // })
                },
                // 监听滚动 滚动到底部加载
                // scrollEvent() {
                //     let offsetHeight = this.$el.querySelector("#scroll-box").offsetHeight;
                //     let scrollHeight = this.$el.querySelector("#scroll-box").scrollHeight;
                //     let scrollTop = this.$el.querySelector("#scroll-box").scrollTop;
                //     // scroll to bottom
                //     if ((offsetHeight + scrollTop) - scrollHeight >= -1) {
                //         // this is pageLoad params
                //     }
                //     if (scrollHeight - (offsetHeight + scrollTop) < 100) {
                //         this.loadMoreList();
                //     }
                // },
                scrollEvent: (() => {
                    let last = 0;
                    return function (e) {
                        if (Date.now() - last < 100) return false;
                        last = Date.now();

                        let elem = e.target,
                            offsetHeight = elem.offsetHeight,
                            scrollTop = elem.scrollTop,
                            scrollHeight = elem.scrollHeight;

                        if (scrollHeight - (offsetHeight + scrollTop) < 100) {
                            this.loadMoreList();
                        }
                    };
                })(),
                toastError: function (errorCode) {
                    var el = null;
                    if (this.$parent) {
                        el = this.$parent.$el.firstChild;
                    }
                    common.toastError(errorCode, el);
                },
                // 重置数据 
                resetParams() {
                    // this.itemList= [];
                    this.searchStatusType = "";
                    this.searchParamsList = [];
                    this.membersParamsList = [];
                    // this.clickItemTreeParam= null
                },
                // 已选人员列表删除
                removeSelected(item) {
                    this.removeDefaultSele(item)
                    this.deleteObj(item);
                    this.deleteSeleId(item.id)
                },
                // 删除默认人员
                removeDefaultSele(item) {
                    let that = this;
                    this.defaultIndexItem = {};
                    this.defaultSeleList.forEach((element, index) => {
                        // if(item.id == element.id && that.isSameSelectedItem(element, item)){
                        if (item.id == element.id) {
                            this.defaultSeleList.splice(index, 1);
                        }
                    })
                    this.defaultListIndex();
                },
                hideSele(type) {
                    this.isOpen = type;
                },
                openRetract() {
                    if (!this.seleCount) {
                        this.isOpen = true;
                        return;
                    }
                    this.isOpen = !this.isOpen;
                },
                selectedItem(item) {
                    if (item.itemNodeType == "group" && this.isSeleGroupMember) {
                        debugger
                        this.allSelecteds.push(this.filterUser(item.groupMembers));
                    } else if (item.selection != "disabled") {
                        this.allSelecteds.push(item);
                    }
                    if (this.isSeleGroupMember) {
                        this.allSelecteds = publicTreeView.combine(this.allSelecteds.flat(Infinity));
                    } else {
                        this.allSelecteds = publicTreeView.combine(this.allSelecteds);
                    }

                    this.selectedAllId = this.allSelecteds.map(data => data.id);
                    console.log('*****************************************************')
                    console.log(this.selectedAllId)
                    console.log('*****************************************************')
                },
                //全选 or 取消全选
                settingAllType() {
                    if (this.seleAllType == "selected") {
                        this.itemList.forEach((element, index) => {
                            if (element.itemNodeType == "group" && this.isSeleGroupMember) {
                                element.groupMembers.forEach((data, index) => {
                                    this.deleteObj(data);
                                })
                            } else {
                                this.deleteObj(element);
                            }
                        });
                        this.allSelecteds = publicTreeView.combine(this.allSelecteds.flat(Infinity));
                        this.selectedAllId = this.allSelecteds.map((data) => {
                            return data.id
                        });
                        if (this.seleCount == 0) this.isOpen = true;
                    } else if (this.seleAllType != "electionAll") {
                        this.itemList.forEach((element, index) => {
                            this.selectedItem(element)
                        })
                    }
                },
                // 群组状态
                groupType(arr) {
                    let count = 0,
                        idList = [];
                    idList = this.defaultSeleList.map(data => {
                        return data.id
                    });
                    if (this.singleElection) return 'disabled';
                    if (this.selectedAllId.concat(idList).length == 0 || arr.length == 0) return "selectable";
                    this.selectedAllId.concat(idList).forEach((element, index) => {
                        for (let i of arr) {
                            if (element == i.id) {
                                count++;
                            }
                        }
                    })
                    if (count == arr.length - 1 && arr.length > 1) return "selected";
                    if (count > 0 && count < arr.length - 1) return "election";
                    if (count == 0) return "selectable";
                },
                // 单项选中 or 单项取消选中
                itemSelection(item, index) {
                    if (this.singleElection) {
                        if (item.selection === 'selectable' || item.selection === 'election') {
                            this.allSelecteds = [item];
                            this.selectedAllId = this.allSelecteds.map((data) => {
                                return data.id
                            });
                        } else if (item.selection == "selected") {
                            this.allSelecteds = [];
                            this.selectedAllId = []
                        }
                    } else {
                        if (item.selection === 'selectable' || item.selection === 'election') {
                            debugger
                            this.selectedItem(item);
                        } else if (item.selection == "selected") {
                            if (item.itemNodeType == "group" && this.isSeleGroupMember) {
                                item.groupMembers.forEach((data, index) => {
                                    this.deleteObj(data);
                                    this.deleteSeleId(data.id)
                                    this.groupArrId.push(data.id)
                                })
                                this.allSelecteds = publicTreeView.combine(this.allSelecteds.flat(Infinity));
                                this.selectedAllId = this.allSelecteds.map((data) => {
                                    return data.id
                                });
                            } else {
                                this.deleteObj(item);
                                this.deleteSeleId(item.id)
                                this.allSelecteds = publicTreeView.combine(this.allSelecteds);
                                this.selectedAllId = this.allSelecteds.map((data) => {
                                    return data.id
                                });
                            }
                        }
                    }
                },
                filterUser(arr) {
                    debugger
                    let removeUserArr = [];
                    arr.forEach((item, index) => {
                        if (item.id != RongIM.instance.auth.id && this.defaultIndexItem[item.id] == undefined) {
                            removeUserArr.push(item);
                        };
                    })
                    return removeUserArr;
                },
                //索引默认选中人员
                defaultListIndex() {
                    this.defaultSeleList.forEach((item, index) => {
                        this.defaultIndexItem[item.id] = item;
                    })
                },
                // 移除已选中人员
                deleteObj(item) {
                    let isNumber = this.membersParamsList.length > 0 && this.isClickTreeNode,
                        that = this;
                    this.allSelecteds.forEach((element, index) => {
                        if (item.id == element.id) {
                            this.allSelecteds.splice(index, 1);
                        }
                    })
                    if (!this.delDefauleSelected) {
                        this.removeDefaultSele(item);
                    }
                    (function () {
                        if (isNumber) that.membersParamsList = that.setItemList(that.membersParamsList);
                        if (!isNumber) that.searchParamsList = that.setItemList(that.searchParamsList);
                    })()
                },
                // 移除已选中人员id
                deleteSeleId(item) {
                    this.selectedAllId.forEach((element, index) => {
                        if (element == item) {
                            this.selectedAllId.splice(index, 1);
                        }
                    })
                },
                // removeSelected(item){
                //   this.deleteObj(item)
                // },
                /**获取我的关注、我的组织，成员数据
                 * @params item {Object} 当前点击对象
                 * @params params {params} 当前请求参数
                 * @params sources {String} 当前数据来源(搜索、节点)
                 */
                getItemList(item, params, sources, searchType, isScroll) {

                    this.isGroup = false;

                    this.searchStatusType = searchType;
                    // this.membersParamsList = [];
                    // this.itemList = [];
                    if (!item && sources == "search" && searchType && searchType == "end") {
                        // this.itemList = this.membersParamsList
                        this.isClickTreeNode = true;
                        this.searchParamsList = []
                    }
                    // else if ((!item && sources == "search" && searchType == "conduct") || (item && item.root && item.rootType =="myMailList" && sources == "search" && searchType == "conduct")) {
                    //   this.searchList(params,sources)
                    // }
                    else if (sources == "search" && searchType && searchType == "conduct") {
                        this.searchList(params, sources)
                        this.isClickTreeNode = false;
                    } else if (item && params) {
                        if (!isScroll) {
                            this.resetParams();
                        }
                        this.clickItemTreeParam = item;
                        this.orgId = item.id;
                        this.isClickTreeNode = true;
                        this.numberList(item, params, isScroll)
                    }
                },
                /**
                 * setting request params
                 * @param {*} itemList    Array  接口吐出来的数据
                 */
                setItemList: function (itemList) {
                    let paramsList = itemList.map(data => {
                        this.$set(data, 'selection', 'selectable')
                        this.$set(data, 'showTips', false)
                        if (this.isProhibitUser && data.id == RongIM.instance.auth.id) { // 禁止勾选自己
                            this.$set(data, 'selection', 'disabled')
                        }
                        if ((this.isProhibitDefaultList && this.defaultIndexItem[data.id] != undefined) || (this.canNotSelected.indexOf(data.id) != -1)) { // 禁止勾选默认选中人员 和 默认不可选人员
                            this.$set(data, 'selection', 'disabled')
                        }
                        if (!this.delDefauleSelected && this.defaultIndexItem[data.id] != undefined) { // 禁止勾选默认选中人员 和 默认不可选人员
                            this.$set(data, 'selection', 'selected');
                        }
                        this.allSelecteds.forEach((element, index) => { // 之前选中的人员并且是之前点击的人员设置为选中状态
                            if (data.id == element.id && data.parent_id == element.parent_id) {
                                this.$set(data, 'selection', 'selected') // 之前选中的人员但不是之前点击的人员设置为禁选状态
                            } else if (data.id == element.id) {
                                this.$set(data, 'selection', 'disabled')
                            }
                        })
                        return data
                    })
                    return paramsList;
                },
                // 取消选择后删除已选人员
                // spliceArr(list){
                //   let that = this;
                //   that.allSelecteds.forEach((item,index) => {
                //     list.forEach((e,i) =>{
                //       if(item.id == e.id && that.isSameSelectedItem(e, item)){
                //         that.allSelecteds.splice(index,1);
                //         that.spliceArr(list);
                //       }
                //     })
                //   })
                // },
                isSameSelectedItem: function (element, item) {
                    return element.parent_id == item.parent_id || (
                        item.orgsInfo && item.orgsInfo.some(function (org) {
                            return element.parent_id == org.id;
                        })
                    );
                },
                /**点击节点数据 */
                numberList(item, params, isScroll) {
                    this.itemTemp = item
                    this.paramsTemp = params
                    this.isOpen = true;
                    let that = this;
                    delete params.tabId;
                    params.state = 0;
                    // orgApi.getAllMembers(item.id,params,function(result){
                    orgApi.getMembers(item.id, params, function (result) {
                        if (result.data && result.data instanceof Array && result.data.length > 0) {
                            that.$emit('memberResult', result)
                            if (isScroll) {
                                that.membersParamsList = that.membersParamsList.concat(that.setItemList(result.data))
                                console.log('that.membersParamsList', that.membersParamsList)
                            } else {
                                that.membersParamsList = that.setItemList(result.data);
                            }
                            that.listFinished = !(result.total_count === that.membersParamsList.length)
                        }
                    })
                },

                // dialog search myOrg and myFollow
                searchList(params, sources) {
                    this.isOpen = true;
                    let that = this;
                    if (params.tabId == "phone" || params.tabId == "recentContacts") {
                        return this.mailListSearchType(params, sources)
                    }
                    orgApi.searchInMyOrg({
                        type: 'staff',
                        keyword: params.keyword,
                        scope: 'name,duty,mobile,staff_no'
                    }, function (result) {
                        if (result != undefined && result.length > 0) {

                            that.addPath(result)
                            that.searchParamsList = publicTreeView.combine(that.setItemList(result));
                            that.searchStatusType = "end";
                            // that.itemList = publicTreeView.combine(that.searchParamsList);
                        } else {
                            that.searchStatusType = "empty";
                        }
                    });
                },

                // 搜索规则
                mailListSearchType(params, sources) {

                    this.searchParamsList = [];
                    let that = this,
                        searchGroups = [],
                        searchFrend = [],
                        searchKeyCont = [],
                        searchRec = [];
                    if (that.clickItemTreeParam != null && (!that.clickItemTreeParam.root)) { //单独搜索
                        switch (that.clickItemTreeParam.nodeType) {
                            case 'communicateGroup': // 群聊
                                that.searchParamsList = that.searchGroups(params.keyword);
                                // that.itemList = publicTreeView.combine(that.searchParamsList);
                                that.searchStatusType = that.itemList.length > 0 ? "end" : "empty";
                                break;
                            case 'dailyContact': // 日常联系人
                                that.searchParamsList = that.searchFriend(params.keyword);
                                // that.itemList = publicTreeView.combine(that.searchParamsList);
                                that.searchStatusType = that.itemList.length > 0 ? "end" : "empty";
                                break;
                            case 'KeyContacts': // 重要联系人
                                that.isGroup = false;
                                that.searchParamsList = that.searchKeyContactsList(params.keyword);
                                // that.itemList = publicTreeView.combine(that.searchParamsList);
                                that.searchStatusType = that.itemList.length > 0 ? "end" : "empty";
                                break;
                            case 'recent': // 最近联系人
                                that.isGroup = false;
                                that.searchParamsList = that.searchRecent(params.keyword);
                                // that.itemList = publicTreeView.combine(that.searchParamsList);
                                that.searchStatusType = that.itemList.length > 0 ? "end" : "empty";
                                break;
                            case 'distributionGroup':
                                that.isGroup = false;
                                that.searchPinGroupItem(params.keyword);
                                // that.itemList = publicTreeView.combine(that.searchParamsList);
                                that.searchStatusType = that.itemList.length > 0 ? "end" : "empty";

                            default:
                        }
                    } else {
                        searchGroups = that.searchGroups(params.keyword);
                        searchFrend = that.searchFriend(params.keyword);
                        searchKeyCont = that.searchKeyContactsList(params.keyword);
                        searchRec = that.searchRecent(params.keyword);
                        let searchAllParams = [];
                        if (that.entryType == "created") { // 不搜索群组
                            searchAllParams = searchFrend.concat(searchKeyCont)
                        } else if (that.entryType == "forward") {
                            searchAllParams = searchFrend.concat([...searchKeyCont, ...searchGroups, ...searchRec]);
                        } else { // 搜索最新联系人
                            searchAllParams = searchFrend.concat([...searchKeyCont, ...searchGroups])
                        }
                        that.searchStatusType = searchAllParams.length > 0 ? "end" : "empty";
                        that.searchParamsList = searchAllParams;
                        // that.itemList = publicTreeView.combine(that.searchParamsList);
                    }
                },
                /** 搜索最近联系人*/
                searchRecent(searchKey, sources, searchRange) {
                    let searchResult = [];
                    this.recentList.forEach((item, index) => {
                        let nameRange = utils.searchStrRange(item.name, searchKey);
                        let aliasRange = utils.searchStrRange(item.alias, searchKey);
                        if (nameRange || aliasRange) {
                            let result = $.extend({
                                range: nameRange,
                                aliasRange: aliasRange
                            }, item);
                            searchResult.push(result);
                        }
                    });
                    return searchResult;
                },

                /**
                 * 群组搜索
                 * @param {*} searchKey    String  搜索关键字
                 */
                searchGroups(searchKey, sources, searchRange) {
                    var searchResult = [];
                    this.dayGroupsList.forEach((item, index) => {
                        var nameRange = utils.searchStrRange(item.name, searchKey);
                        var aliasRange = utils.searchStrRange(item.alias, searchKey);
                        if (nameRange || aliasRange) {
                            var result = $.extend({
                                range: nameRange,
                                aliasRange: aliasRange
                            }, item);
                            searchResult.push(result);
                        } else if (item.group && item.group.groupMembers) {
                            var hasMember = item.group.groupMembers.some(function (member) {
                                return utils.searchStrRange(member.name, searchKey) ||
                                    utils.searchStrRange(member.alias, searchKey);
                            })
                            if (hasMember) searchResult.push(item);
                        }
                    });
                    return searchResult;
                },
                //搜索外部联系人
                searchFriend(searchKey, sources, searchRange) {
                    let that = this,
                        searchFriendList = [];
                    that.dailysContactList.forEach((item, index) => {
                        var nameRange = utils.searchStrRange(item.name, searchKey);
                        if (nameRange) {
                            searchFriendList.push($.extend({
                                range: nameRange
                            }, item));
                            return;
                        }
                        var aliasRange = utils.searchStrRange(item.alias, searchKey);
                        if (aliasRange) {
                            searchFriendList.push($.extend({
                                range: aliasRange
                            }, item));
                        }
                    });
                    return searchFriendList;
                },
                // 搜索重要联系人
                searchKeyContactsList(searchKey, sources, searchRange) {
                    let that = this,
                        searchResultArr = [];
                    that.KeyContactsContactList.forEach((item, index) => {
                        var nameRange = utils.searchStrRange(item.name, searchKey);
                        var aliasRange = utils.searchStrRange(item.alias, searchKey);
                        if (nameRange || aliasRange) {
                            var result = $.extend({
                                range: nameRange,
                                aliasRange: aliasRange
                            }, item);
                            searchResultArr.push(result);
                        }
                    });
                    common.sortUsers(searchResultArr);
                    return searchResultArr;
                },
                getFriends(context, friendApi, callback) {
                    callback = callback || $.noop;
                    friendApi.getList(function (errorCode, list) {
                        if (errorCode) {
                            context.toastError(errorCode);
                            return;
                        }
                        common.sortUsers(list);
                        context.friends = list;
                        callback();
                    });
                },
                //我的通讯录下的点击
                getMailList(item) {

                    let that = this;
                    this.resetParams();
                    this.isClickTreeNode = true;
                    this.isOpen = true;
                    this.clickItemTreeParam = item;
                    switch (item.nodeType) {
                        case 'communicateGroup': //群聊
                            that.isGroup = true;
                            that.membersParamsList = that.dayGroupsList;
                            break;
                        case 'dailyContact': //日常联系人
                            that.isGroup = false;
                            that.membersParamsList = that.dailysContactList;
                            break;
                        case 'KeyContacts': //重要联系人
                            that.isGroup = false;
                            that.membersParamsList = that.KeyContactsContactList;
                            break;
                        case 'recent': //最近联系人
                            that.isGroup = false;
                            if (item.isDefaultSele) {
                                that.getRecentList(function () {
                                    that.membersParamsList = that.recentList;
                                })
                            } else {
                                that.membersParamsList = that.recentList;
                            }
                            break;
                        case 'distributionGroup':
                            if (item.id != 'pinGroup') {
                                that.isGroup = false;
                                that.searchPinGroupMembers(item)
                            }

                        default:
                    }
                },
                // 获取通讯组成员列表
                searchPinGroupMembers(item) {
                    orgApi.getMembersById(item.id, (errorCode, result) => {
                        if (errorCode) {
                            common.toastError(errorCode);
                            return errorCode;
                        }
                        this.searchParamsList = this.setItemList(result.data)

                    })

                },
                // 获取通讯组成员列表
                searchPinGroupItem(keyWord) {

                    let id = ''
                    if (this.clickItemTreeParam.id != 'pinGroup') {
                        id = this.clickItemTreeParam.id
                    }
                    orgApi.searchPinGroupItem(id, keyWord, (errorCode, result) => {
                        if (errorCode) {
                            common.toastError(errorCode);
                            return errorCode;
                        }
                        this.searchParamsList = this.setItemList(result.data)

                    })

                },
                // 获取最近联系人
                getRecentList(callback) {
                    let result = [],
                        that = this;
                    conversationApi.getList(null, function (errorCode, list) {
                        if (errorCode) {
                            context.toastError(errorCode);
                            return;
                        }
                        list.forEach(function (conversation) {
                            let isGroup = conversation.conversationType === 3;
                            let isPublic = conversation.conversationType === 7;
                            let target = {};
                            if (isGroup) {
                                target = conversation.group;
                            } else if (isPublic) {
                                target = conversation.latestMessage.user;
                            } else {
                                target = conversation.user;
                            }
                            let isSysUser = conversation.user && common.isSysUser(conversation.user);
                            if (conversation.conversationType !== 6 && !isSysUser) {
                                result.push(formateContact(target, isGroup));
                            }
                        });
                        that.recentList = that.setItemList(result);
                        if (callback) {
                            callback()
                        }
                    })
                },
                //获取重要联系人
                getKeyContactsList(item) {
                    let that = this;
                    starApi.getList(function (errorCode, list) {
                        if (errorCode) {
                            return [];
                        }
                        if (list && list.length > 0) {
                            that.KeyContactsContactList = that.setItemList(list);
                        }
                    })
                },
                //获取日常联系人
                getDailyContactList(item) {
                    let that = this;
                    friendApi.getList(function (errorCode, list) {
                        if (errorCode) {
                            return [];
                        }
                        if (list && list.length > 0) {
                            that.dailysContactList = that.setItemList(list);
                        }
                    })
                },
                //获取群聊
                geCommunicateGroupList(item) {
                    let that = this;
                    groupApi.getList(function (errorCode, list) {
                        if (errorCode) {
                            that.toastError(errorCode);
                            return [];
                        }

                        function initContextGroups() {
                            var groups = getGroups(list);
                            groups.sort(function (a, b) {
                                return b.type - a.type;
                            });
                            that.dayGroupsList = that.setItemList(groups);
                        }
                        var groupCount = list.length;
                        list.forEach(function (item) {
                            groupApi.getAllMembers(item.id, function (err, members, group) {
                                $.extend(item, group);
                                if (--groupCount == 0) initContextGroups();
                            });
                        });
                        console.log('list---------------',list)
                    });
                },
                enter(item) {
                    if ((item.itemNodeType && item.itemNodeType == 'group') || (item.itemNodeType && item.itemNodeType == '')) {
                        this.$set(item, 'showTips', true);
                    }
                },
                leave(item) {
                    if ((item.itemNodeType && item.itemNodeType == 'group') || (item.itemNodeType && item.itemNodeType == '')) {
                        this.$set(item, 'showTips', false);
                    }
                },
                getUsername: common.getUsername,
                getGroupType: common.getGroupType,
                getGroupName: common.getGroupName,
                userProfile: function () {
                    // dialog.user
                },
                getDutyName: function (item) {
                    return (item.extDuties && this.orgId) ? item.extDuties[this.orgId] : item.dutyName;
                },
                loadMore() {
                    this.loadingNextPage = true;
                    let totalNum = this.allList.length;
                    let end = this.lastIndex + pageNum;
                    let adjust = function (index) {
                        return index > totalNum ? totalNum : index;
                    };
                    end = adjust(end);
                    if (end === this.lastIndex) {
                        this.loadingNextPage = false;
                        return;
                    }
                    setTimeout(function () {
                        this.lastIndex = end;
                        this.loadingNextPage = false;
                    }, 500);
                }
            },
            destroyed: function () {
                orgApi.unwatch(this.deptWatch);
            }
        };
        utils.asyncComponent(options, resolve, reject);
    };

    function getOrgBranch(uid, orgApi, callback) {
        orgApi.getBranch(uid, function (errorCode, result) {
            if (errorCode) {
                common.toastError(errorCode);
                return;
            }
            callback(result);
        });
    }

    function formateContact(item, isGroup) {
        var obj = {
            id: isGroup ? 'group_' + item.id : item.id,
            name: item.name,
            avatar: item.avatar,
            member_avatars: isGroup ? item.member_avatars : '',
            member_names: isGroup ? item.member_names : '',
            member_id_list: isGroup ? item.member_id_list : '',
            isFriend: isGroup ? true : item.isFriend,
            type: item.type,
            dutyName: item.dutyName
        };
        if (isGroup) {
            obj.group = item;
            obj.itemNodeType = "group"
        }
        return obj;
    }

    function getGroups(list) {
        return list.map(function (group) {
            return {
                id: 'group_' + group.id,
                name: group.name,
                itemNodeType: 'group',
                avatar: group.avatar,
                groupMembers: group.groupMembers,
                member_avatars: group.member_avatars,
                member_names: group.member_names,
                member_id_list: group.member_id_list,
                group_status: group.group_status,
                isFriend: true,
                type: group.type,
                group: group,
                member_count: group.member_count
            };
        });
    }
}(RongIM, null, RongIM.components));