

(function (RongIM, dependencies, components) {
  'use strict';
  
  var utils = RongIM.utils;
  var dialog = RongIM.dialog;
  var common = RongIM.common;
  var $ = dependencies.jQuery;
  /**
   * 已选人员列表 组件
   * @params titleList 设置title的内容
   * @params isShow 是否显示title组件
   * @params currentAvtive 向外部传递当前点击项
   */
  
  components.selectedList = function (resolve, reject) {
      var im = RongIM.instance;
      var dataModel = im.dataModel;
      var userApi = dataModel.User;
      var options = {
          name: 'selected-list',
          template: '#selected-list',
          components: {
            avatar: components.getAvatar,
            paging: components.newPaging
        },
          props: {
              //默认选中人员列表
              defaultSelectedList: {
                  type: Array,
                  default: () => []
              },
              /**是否可删除默认选中人员配置  false为可删除*/
              delDefauleSelected: {
                type: Boolean,
                default: false
              },
              isOpen: {
                type: Boolean,
                default: true
              },
              //已选人员列表
              selectedList: {
                type: Array,
                default: () => []
              },
              orgId: String,
              isTxz:{
                type: Boolean,
                default: false
              }
          },
          data: function () {
              return {
                allDepatId: {},
                allItemList: [],
                allCount: 0,
                nonePathList: [],
                allSelectedList: [],
                userId: RongIM.instance.auth.id,
                thisDefaultSelectedList: [],
                seleIsOpen: "init"
              };
          },
          computed: {},
          filters: {},
          watch: {

            // 已选人员列表监听
            selectedList(newVal,usedVal){
              console.log(newVal)
              this.resetParams();
              this.allSelectedListChange(newVal,'select');
            },
            
            // 默认选中人员列表变化
            defaultSelectedList(newVal,oldVal) {
              this.resetParams();
              this.allSelectedListChange(newVal,'default');
            },

            // 卷帘门显示隐藏
            // isOpen(newVal) {
            //   if(newVal) this.seleIsOpen = "hide-selected-box";
            //   if(!newVal) this.seleIsOpen = "show-selected-box";
            //   console.log(this.seleIsOpen == "selected-list-none" ? '影藏' : "显示");
            // }
          },
          created(){
            //禁止直接修改props属性
            this.thisDefaultSelectedList = this.defaultSelectedList;
            //用于初始化选中人数
            this.allCount = this.thisDefaultSelectedList.length;
            //配置默认选中人员可删除状态
            if(this.delDefauleSelected) {
              this.thisDefaultSelectedList = this.configDelDefaultSelectedList(this.thisDefaultSelectedList);
            }
            //初始化数据
            this.initData(this.thisDefaultSelectedList);
           },
          mounted: function () {},

          methods: {

              getGroupType: common.getGroupType,

              /**配置默认选中人员是否可删除*/
              configDelDefaultSelectedList(defaultList){
                let isDelList = defaultList.map((item,index) => {
                  item.isDel = true;
                  return item
                })
                return isDelList
              },

              userProfile: function(){
                // dialog.user
              },

              getUsername: common.getUsername,

              //重置人员信息
              resetParams(){
                this.allDepatId= {};
                this.allItemList= [];
                this.nonePathList= [];
              },

              /**
               * 删除数组
               * @param {Array} delList  需要删除的数组
               * @param {object} delItem 需要删除的对象
               */
              delArr(delList, delItem) {
                let [...newArr] = delList;
                newArr.forEach((element,index) => {
                  if(element.id == delItem.id) {
                    newArr.splice(index,1)
                  }
                })
              },

              //已选人员列表变化
              allSelectedListChange(newVal, type){
                this.allSelectedList = type == "default" ? this.selectedList: this.thisDefaultSelectedList;
                let obj = {};
                let newArr = this.allSelectedList.concat(newVal).reduce((cur,next) => {
                  obj[next.id] ? "" : obj[next.id] = true && cur.push(next);
                  return cur;
                },[])
                this.allSelectedList = newArr;
                this.allCount = this.allSelectedList.length;
                this.initData(this.allSelectedList)
              },

              //删除已选人员
              removeSelected(item,type,index){
                let that = this;
                let list =  that.selectedList.concat(that.defaultSelectedList)
                if(that.isTxz &&list.length == 1){
                  common.messageToast({
                    message:  that.locale.contact.oneMoreMembers, // toast
                    type: 'error'
                  });
                  return;
                }
                // 删除已经选人员列表
                that.delArr(that.selectedList,item)
                // 删除默认人员列表
                if(!this.delDefauleSelected) {
                  that.delArr(that.defaultSelectedList,item);
                }

                setTimeout(() => {
                  if(Number(that.selectedList.length) + Number(JSON.parse(JSON.stringify(that.defaultSelectedList)).length) == 0){
                    this.seleIsOpen = "hide-selected-box";
                    this.$emit('hideSele',true)
                  }
                }, 0);

                this.$emit('removeSelected',item)
              },

              getDutyName: function (item) {
                // if(item.extDuties && (this.orgId || item.departId)) {
                //   return item.extDuties[this.orgId || item.departId]
                // }
                // return item.departName
                return (item.extDuties && this.orgId) ? item.extDuties[this.orgId] : item.dutyName;
              },

              //初始化生成数据
              initData(arr){
                let that = this;
                arr.forEach((element,index) => {
                  if(element.path && element.path != '' && element.path instanceof Array && element.path.length > 0){
                    if(that.allDepatId[element.path[element.path.length -1].id] != undefined){
                      that.allDepatId[element.path[element.path.length -1].id].memberList.push(element)
                    }else {
                      element.memberList = [element];
                      element.departName = element.path[element.path.length -1].name;
                      element.departId = element.path[element.path.length -1].id;
                      element.departType = element.path[element.path.length -1].type;
                      that.allDepatId[element.path[element.path.length -1].id] = element;
                    }
                  }else {
                    if(element.id == im.loginUser.id){
                      element.isDel = true
                    }
                    that.nonePathList.push(element)
                  }
                });
                for(let item in that.allDepatId){
                  that.allItemList.push(that.allDepatId[item])
                }
              }
          },
          destroyed: function () {}
      };
      utils.asyncComponent(options, resolve, reject);
  };
  }(RongIM, {jQuery: jQuery}, RongIM.components));
  
