(function (RongIM, dependencies, components) {
    'use strict';
    var utils = RongIM.utils;
    var dialog = RongIM.dialog;
    var common = RongIM.common;
    var pageNum = RongIM.config.profile.pageNum;
    function transUrl(url) {
        return common.trans2Localfile(url, 'icons');
    }
    
    /**
     * title 组件
     * @params titleList 设置title的内容
     * @params isShow 是否显示title组件
     * @params currentAvtive 向外部传递当前点击项
     */
    
    components.treeRightItem = function (resolve, reject) {
        var im = RongIM.instance;
        var dataModel = im.dataModel;
        var starApi = dataModel.Star;
        var friendApi = dataModel.Friend;
        var groupApi = dataModel.Group;
        var orgApi = dataModel.Organization;
        var userApi = dataModel.User;
        var options = {
            name: 'tree-right-item',
            template: '#tree-right-item',
            inject: ['reload'],
            props: {
                itemTitle: {
                    type: String,
                    default: RongIM.locale.zh.blish.selectedMemberList
                },
                isShow: {
                    type: Boolean,
                    default: true
                },
                showCount: {
                    type: Boolean,
                    default: true
                },
                itemdata: {
                    type: Object,
                    default: () => {}
                },
                selectedMembers: {
                    type: Array,
                    default: () => {
                        return []
                    }
                },
                eventtarger: {
                    type: Object,
                    default: () => {}
                },
                isPickYourself: {
                  type: Boolean,
                  default: false
                },
                type: {
                  type: String,
                  default: ''
                },
                selectId: { //下拉id
                  type: String,
                  default: '2'
                },
                keyword: { //搜索关键字
                  type: String,
                  default: ''
                },
                isSeleOwn: { //是否禁选自己
                  type: Boolean,
                  default: false
                },
                defaultList: {
                  type: Array,
                  default: () => []
                },
                /**是否可删除默认选中人员 */
                delDefauleSelected: {
                  type: Boolean,
                  default: false
                },
                //是否偏移提示
                dialogType: {
                  type: String,
                  default: "group"
                },
                isSelectedGroup: {
                  type: Boolean,
                  default: true
                },
                //是否禁止修改默认人员空状态
                prohibitDefault: {
                  type: Boolean,
                  default: true
                },
                entryType: {
                  type: String,
                  default:""
                },
                tabItem: {
                  type: Object,
                  default: () => {}
                },
                searchStatus: {
                  type: String,
                  default: ""
                }
            },
            data: function () {
                return {
                    itemIndex : 0,
                    pageConfigTotal:{total:21,pageSize:10,pageNo:1},
                    pageConfigPageTotal:{
                        total:21,
                        pageSize:10,
                        pageNo:1,
                        pageTotal:30
                    },
                    // 通讯录当前点击的item
                    iteMailListms: null,
                    itemList: [],
                    paramsData: null,
                    isGroup: false,
                    searchResult: [],
                    deptName: '',
                    company: {},
                    breadcrumb: [],
                    allMembers: [],
                    allDepts: [],
                    allCompanies: [],
                    loadingNextPage: false,
                    lastIndex: 0,
                    allList: [],
                    page: 1,
                    size: 10,
                    itemData: null,
                    getMyFollowList: [],
                    events: null,
                    selectedArr:[],
                    parentArr: [],
                    allSelecteds: this.selectedMembers,
                    allSelevtion: false,
                    optionalLength: [],
                    defaultIndexItem:{},
                    searchResult: {
                      id: '',
                      deptName: '',
                      members: [],
                      depts: [],
                      companies: []
                    },
                    searchParamsList: [],
                    membersParamsList: [],
                    getList: [],
                    //搜索我的通讯录
                    searchMyMailList: [],
                    searchPadding: ""
                };
            },
            computed: {
                /* 成员选中状态计算属性绑定 */
                checkedMembers: {
                  get: function () {
                    return this.selected.map(function (item) {
                        return item.id;
                    });
                  },
                  set: function (newMemberIds) {
                    // 只有企业通讯录的选择器变化会触发
                    var context = this;
                    var oldMembers = context.checkedMembers.slice();
                    var addedList = [];
                    newMemberIds.forEach(function (id) {
                        var index = oldMembers.indexOf(id);
                        if (index === -1) {
                            // 标记新加入的 id
                            addedList.push(id);
                        } else {
                            // 移除还存在的 id，剩余的即是被删除的 id
                            oldMembers.splice(index, 1);
                        }
                    });
                    if (oldMembers.length) {
                        this.onMemberChange('removed', oldMembers);
                    }
                    if (addedList.length) {
                        this.onMemberChange('added', addedList);
                    }
                  }
                },
                searchType(){
                  return this.searchPadding
                },
                nemberCount: function () {
                    return this.allSelecteds.length;
                },
                allSelevtionType: function(){
                  let selectedLeng = 0;
                  if(this.itemList.length < 1){
                    return false
                  }
                  this.itemList.forEach((item,index) => {
                    if(item.selection == "selectable") {
                      return false
                    }else {
                      selectedLeng++;
                    }
                  })
                  if(selectedLeng == this.itemList.length){
                    return true
                  }
                },
                isShowLoad: function(){
                  if(this.itemList.length > 0){
                    return false
                  }
                  return true
                }
            },
            filters: {
                itemType(val){
                    if(val.type == 0){
                        return val;
                    }
                }
            },
            watch: {
              'tabItem': function(newVal){
                this.itemList= [];
                this.searchParamsList= [];
                this.membersParamsList= [];
                this.searchMyMailList= [];
                this.iteMailListms= null
              },
              searchStatus: function(newVal){
                this.searchPadding= newVal
              }
            },
            components: {
                avatar: components.getAvatar,
                paging: components.newPaging,
                selected: components.selectedList
            },
            created(){
                this.events = this.eventtarger;
                this.defaultListIndex()
            },
            mounted: function () {},

            methods: {
              //索引默认人员
              defaultListIndex(){
                this.defaultList.forEach((item,index)=>{
                  this.defaultIndexItem[item.id]= item;
                })
              },
              //删除已选人员并将已选人员重置可选状态
              removeSelected(item){
                let that = this;
                that.allSelecteds.forEach((element,index) => {
                  if(element.id == item.id){
                    that.allSelecteds.splice(index,1)
                  }
                })
                that.itemList.forEach((element,index) => {
                  if(element.id == item.id){
                    that.$set(element,'selection','selectable');
                  }
                })
                that.$emit('allSelectd',that.allSelecteds);
              },
              isSameSelectedItem: function(element, item) {
                  return element.parent_id == item.parent_id || (
                      item.orgsInfo && item.orgsInfo.some(function(org) {
                          return element.parent_id == org.id;
                      })
                  );
              },
              /**取消搜索 */
              closeSearchResetItem(){
                this.searchPadding= "end";
                this.itemList= this.membersParamsList;
                
              },
              /**
               * 
               * @param {Array} itemList 接口拉取的数据
               * @param {String} sources 数据来源(搜索、节点)
               */
              setItemList: function(itemList,sources) {
                  let that = this,staffMap = {},paramsList=[];
                  paramsList = itemList.map(function(element) {
                    console.log(that.defaultIndexItem,element.id)
                      if(that.isSeleOwn && element.id == RongIM.instance.auth.id){ //是否禁选自己
                          element.selection = 'indeterminate';
                      }else if((that.isPickYourself && element.id == RongIM.instance.auth.id) || staffMap[element.id]) { //是否默认选择自己
                          element.selection = 'disabled';
                      }else if(that.prohibitDefault &&that.defaultIndexItem.length>0 && that.defaultIndexItem[element.id] != undefined){  //是否禁默认
                          element.selection = 'disabled';
                      }else{
                          element.selection = 'selectable';
                          staffMap[element.id] = true;
                      }
                      element.showTips = false;
                      if (element.selection == 'selectable') {
                          for(let i of that.allSelecteds){
                              if(element.id == i.id){
                                  element.selection = that.isSameSelectedItem(element, i) ? 'selected' : 'disabled';
                              }
                          }
                      }
                      return element;
                  });
                  if(sources != undefined && sources == "search"){
                    this.searchParamsList= paramsList;
                    this.itemList= this.searchParamsList
                    if(this.itemList.length > 0){
                      this.searchPadding= "";
                    }else {
                      this.searchPadding= "empty";
                    }
                  }else {
                    this.membersParamsList= paramsList;
                    this.itemList= this.membersParamsList
                  }
                  
              },
              onMemberChange: function (type, members) {
                var context = this;
                userApi.get(members, function (err, list) {
                    if (err) {
                        context.toastError(err);
                        return;
                    }
                    context.$emit(type, list);
                });
            },
              enter(item){
                this.$set(item,'showTips',true);
              },
              leave(item){
                this.$set(item,'showTips',false);
              },
              resetpageConfig (){
                this.pageConfigPageTotal = {
                  total:21,
                  pageSize:10,
                  pageNo:1,
                  pageTotal:1
                };
              },
              //全选
              allItemSelected(){
                let that= this,newArr=[];
                that.itemList.forEach((item,index) => {
                  if(item.selection == 'selectable'){
                    newArr.push(item);
                    that.$set(item,'selection','selected');
                  }
                })
                if(that.isGroup && that.isSelectedGroup){
                  newArr = newArr.flat(Infinity)
                }
                return newArr
              },
              //取消全选
              deselectAll(){
                let that= this,newArr= [];
                that.itemList.forEach((item,index) => {
                  if(item.selection == 'selected'){
                    newArr.push(item);
                    that.$set(item,'selection','selectable');
                  }
                })
                if(that.isGroup && that.isSelectedGroup){
                  newArr = newArr.flat(Infinity)
                }
                that.spliceArr(newArr);
                that.$emit('allSelectd',that.allSelecteds);
              },
              allElection(){
                let that = this;
                that.allSelevtion = !this.allSelevtionType;
                if(that.itemList.length > 0 && !this.isShowLoad){
                  if(that.allSelevtion){
                    that.allSelecteds = that.allSelecteds.concat(that.allItemSelected());
                    that.$emit('allSelectd',that.allSelecteds);
                  }else {
                    that.deselectAll()
                  }
                }
              },
                getUsername: common.getUsername,
                getGroupType: common.getGroupType,
                getGroupName: common.getGroupName,
                userProfile: function(){
                  // dialog.user
                },
                getRoute: getRoute,
                getTypeName: common.getGroupType,
                getDutyName: function (item) {
                    return (item.extDuties && this.orgId) ? item.extDuties[this.orgId] : item.dutyName;
                },
                itemActive(item,index){
                    this.itemIndex = index;
                    this.$emit('currentAvtive',item);
                },
                spliceArr(list){
                  let that = this;
                  that.allSelecteds.forEach((item,index) => {
                    list.forEach((e,i) =>{
                      if(item.id == e.id && that.isSameSelectedItem(e, item)){
                        that.allSelecteds.splice(index,1);
                        that.spliceArr(list);
                      }
                    })
                  })
                },
                changePage(page){
                    this.pageConfigPageTotal.pageNo = page;
                    let params = {
                      type: 'staff',
                      // orgtype: this.selectId
                    };
                    if (this.keyword) {
                        params.keyword = this.keyword;
                        params.scope = 'name,duty,mobile,staff_no';
                    }
                    if(this.itemData != null){
                      this.getItemList(this.itemData,params);
                    }
                },
                //获取我的关注列表
                getFollowParams (){
                    let that = this,params = {focustate:'0'};
                    orgApi.getMyfollow(RongIM.instance.auth.id,params,function(result){
                        // result.data.forEach(element => {
                        //     that.getMyFollowList.push(element.id)
                        // });
                    })
                },
                departIconClass: function(item) {
                    return (item.vcharp3 == 1 || item.type == 3) ? 'rong-dept-blue-icon' : 'rong-dept-icon';
                },
                getDutyName: function (item) {
                    return (item.extDuties && this.orgId) ? item.extDuties[this.orgId] : item.dutyName;
                },
                memberCount: function (item) {
                    var staffCount = item.staff_count || item.member_count;
                    var format = (staffCount == 1) ? this.locale.contact.personSingle : this.locale.contact.person;
                    return this.localeFormat(format, staffCount);
                },
                isAutonomyCompany: function (item) {
                    return orgApi.isAutonomyCompany(item.id);
                },
                loadMore: function () {
                    loadMore(this);
                },
                addGroup(item){
                  this.allSelecteds.push(item);
                },
                deleteGroup(item){
                  let that= this;
                  that.deleteObj(item);
                },
                itemSelection(item,index){
                  if(this.isGroup) {
                    this.allSelecteds = this.allSelecteds.flat(Infinity)
                  }
                  let that = this;
                    if(item.selection == 'selectable'){
                        if(that.isGroup) { //群组添加
                          that.addGroup(item)
                          this.$set(item,'selection','selected');
                        }else if(!that.isGroup) {
                          this.filterPosts(item);
                          this.addObj(item);
                          this.$set(item,'selection','selected');
                        }
                        this.$emit('allSelectd',this.allSelecteds,item,'add');
                    }else if(item.selection == 'selected'){
                        
                        if(that.isGroup) { //群组添加
                          this.deleteGroup(item)
                          this.$set(item,'selection','selectable');
                        }else if(!that.isGroup) {
                          this.recoveryPosts(item);
                          this.deleteObj(item);
                          this.$set(item,'selection','selectable');
                        }
                        this.$emit('allSelectd',this.allSelecteds,item,'remove');
                    }else{
                        return
                    }
                },
                //添加时过滤一人多职人员状态为禁选
                filterPosts(item){
                  let that = this;
                    this.itemList.forEach(element =>{
                        if(element.id == item.id && !that.isSameSelectedItem(element, item)){
                          this.$set(element,'selection','disabled');
                        }
                    })
                },
                //删除时恢复一人多职人员状态为可选
                recoveryPosts(item){
                    this.itemList.forEach(element =>{
                        if(element.id == item.id){
                            this.$set(element,'selection','selectable');
                        }
                    })
                },
                //添加某个对象
                addObj(item){
                  let that = this;
                  getCheckedAll(this)
                    if(this.allSelecteds.length > 0){
                        this.itemList.forEach((element,index) =>{
                            if(item.id == element.id && that.isSameSelectedItem(element, item)){
                                this.allSelecteds.push(item);
                            }
                        })
                    }else {
                        this.allSelecteds.push(item);
                    }
                },
                //删除某个对象
                deleteObj(item){
                  let that = this;
                  getCheckedAll(this)
                    this.allSelecteds.forEach((element,index) =>{
                        if(item.id == element.id && that.isSameSelectedItem(element, item)){
                            this.allSelecteds.splice(index,1);
                        }
                    })
                },
                //获取重要联系人
                getKeyContactsList(){
                  let that= this;
                  starApi.getList(function (errorCode, list) {
                    if(list && list.length > 0){
                      that.setItemList(list);
                    }
                  })
                },
                //获取日常联系人
                getDailyContactList(){
                  let that= this;
                  friendApi.getList(function (errorCode, list) {
                    if(list && list.length > 0){
                      that.setItemList(list);
                    }
                  })
                },
                //获取群聊
                geCommunicateGroupList(item){
                  let that = this;
                  groupApi.getList(function (errorCode, list) {
                    if(list && list.length > 0){
                      list.forEach((element,index) => {
                        element.itemNodeType = 'group'
                        groupApi.getAllMembers(element.id, function(err, members, group) {
                            element.group = members
                        });
                      })
                      that.setItemList(list);
                    }
                  })
                },
                //通讯录
                getMailList(item){
                  let that = this;
                  this.iteMailListms= item;
                  switch(item.nodeType) {
                    case 'communicateGroup': //群聊
                      that.isGroup = true;
                      that.geCommunicateGroupList(item)
                      break;
                    case 'dailyContact': //日常联系人
                      that.isGroup = false;
                      that.getDailyContactList()
                        break;
                    case 'KeyContacts': //重要联系人
                    that.isGroup = false;
                      that.getKeyContactsList()
                      break;
                    default:
                  } 
                },
                //群组搜索
                searchGroups(searchKey,sources){
                  let groups= [],that= this,_groups = [];;
                  groupApi.search(searchKey, function (errorCode, groups) {
                    console.log(groups)
                    if (errorCode) {
                      return;
                    }
                    groups.forEach(function (group) {
                      var rangeName = utils.searchStrRange(that.getGroupName(group), searchKey);
                      var isSearched = group.user_list.length > 0;
                      if (rangeName || isSearched) {
                          group = $.extend({ range: rangeName }, group);
                          group.itemNodeType= "group";
                          _groups.push(group);
                      }
                    });
                    common.sortGroups(_groups);
                    console.log(_groups)
                    that.searchMyMailList= that.searchMyMailList.concat(_groups)
                    that.searchFriend(searchKey,sources)
                    // that.setItemList(_groups,sources);
                  })
                },
                getFriends(context, friendApi, callback) {
                  callback = callback || $.noop;
                  friendApi.getList(function (errorCode, list) {
                    if (errorCode) {
                      context.toastError(errorCode);
                      return;
                    }
                    common.sortUsers(list);
                    context.friends = list;
                    console.log(list)
                    callback();
                  });
                },
                //搜索外部联系人
                searchFriend(searchKey,sources){
                  let that= this,searchFriendList= [];
                  that.getFriends(this, friendApi, function () {
                    that.friends.forEach(function (item) {
                      var nameRange = utils.searchStrRange(item.name, searchKey);
                      if (nameRange) {
                        searchFriendList.push($.extend({ range: nameRange }, item));
                        return;
                      }
                      var aliasRange = utils.searchStrRange(item.alias, searchKey);
                      if (aliasRange) {
                          searchFriendList.push($.extend({ range: aliasRange }, item));
                      }
                    });
                    that.searchMyMailList= that.searchMyMailList.concat(searchFriendList)
                    console.log(that.searchMyMailList)
                    that.setItemList(that.searchMyMailList,sources);
                  });
                },
                toastError: function(errorCode) {
                  common.toastError(errorCode);
              },
                /**
                 * 搜索关键字数据
                 */
                searchList(params,sources){
                  console.log(params,sources)
                  this.searchParamsList= [];
                  this.searchMyMailList= [];
                  let that= this;
                  if (params.tabId == "phone") {
                    return this.mailListSearchType(params,sources)
                  }
                  orgApi.searchInMyOrg({
                      type: params.type,
                      keyword: params.keyword,
                      scope: params.scope
                  },function(result){
                      if(result!=undefined && result.length > 0){
                          that.pageConfigPageTotal.pageTotal = 1;
                          that.setItemList(result,sources);
                      }
                  });
                },
                // 搜索规则
                mailListSearchType(params,sources){
                  console.log(params,sources)
                  let that= this;
                  if(that.iteMailListms != null){ //单独搜索
                    switch(that.iteMailListms.nodeType) {
                      case 'communicateGroup': //群聊
                        that.searchGroups(params.keyword,sources)
                        break;
                      case 'dailyContact': //日常联系人
                        that.searchFriend(params.keyword,sources)
                        break;
                      case 'KeyContacts': //重要联系人
                      that.isGroup = false;
                        that.searchFriend(params.keyword,sources)
                        break;
                      default:
                    } 
                  }else if(that.entryType =="establish") { // 不搜索群组
                    that.searchFriend(params.keyword,sources)
                  }else {
                    that.searchGroups(params.keyword,sources) // 搜索群组、联系人.
                  }
                },
                /**点击节点数据 */
                numberList(item,params){
                  let that= this;
                  this.itemData = item;
                  this.optionalLength = [];
                  delete params.tabId;
                  params.state = 0;
                  params.limit = that.pageConfigPageTotal.pageSize;
                  params.offset = that.pageConfigPageTotal.pageNo;
                  // orgApi.getAllMembers(item.id,params,function(result){
                  orgApi.getMembers(item.id,params,function(result){
                    if(result.data && result.data instanceof Array && result.data.length > 0){
                      that.pageConfigPageTotal.pageTotal = Math.ceil(result.total_count / that.pageConfigPageTotal.pageSize);
                        that.setItemList(result.data);
                      }
                  })
                },
                /**
                 * @params item {Object} 当前点击对象
                 * @params params {params} 当前请求参数
                 * @params sources {String} 当前数据来源(搜索、节点)
                 */
                getItemList(item,params,sources){
                  console.log(item,params,sources)
                    this.isGroup = false;
                    this.itemData = [];
                    if (!item && sources == "search") {
                      this.searchList(params,sources)
                    }else {
                      this.numberList(item,params)
                    }
                },
                // unique(arr1) {
                //   const res = new Map();
                //   return arr1.filter((a) => !res.has(a.id) && res.set(a.id, 1));
                // }
            },
            destroyed: function () {
                orgApi.unwatch(this.deptWatch);
            }
        };
        utils.asyncComponent(options, resolve, reject);
    };
    function getOrgBranch(uid, orgApi, callback) {
        orgApi.getBranch(uid, function (errorCode, result) {
            if (errorCode) {
                common.toastError(errorCode);
                return;
            }
            callback(result);
        });
    }
/*
说明：获取全选状态
步骤：1.获取当前成员如果 checkedMembers 选中的列表中没有返回 false
      2.获取当前部门和公司如果 checkedDepts 选中的列表中没有返回 false
      3.否则返回 true
*/
function getCheckedAll(context) {
  
  var searchResult = context.searchResult;
  var memberList = searchResult.members;
  for (var i = 0, memberLen = memberList.length; i < memberLen; i += 1) {
      var member = memberList[i];
      if (context.checkedMembers.indexOf(member.id) === -1) {
          return false;
      }
  }
  var deptList = searchResult.depts.concat(searchResult.companies);
  deptList = deptList.filter(function (item) {
      return item.node_count > 0;
  });
  for (var j = 0, deptLen = deptList.length; j < deptLen; j += 1) {
      var dept = deptList[j];
      if (!dept.checked) {
          return false;
      }
  }
  return true;
};
function getRoute(item) {
    var coId = this.coId;
    return {
        name: 'organization',
        params: {
            coId: coId,
            orgId: item.id,
            type: item.type
        }
    };
}
    function loadMore(context) {
        context.loadingNextPage = true;
        var totalNum = context.allList.length;
        var end = context.lastIndex + pageNum;
        var adjust = function (index) {
            return index > totalNum ? totalNum : index;
        };
        end = adjust(end);
        if (end === context.lastIndex) {
            context.loadingNextPage = false;
            return;
        }
        setTimeout(function () {
            context.lastIndex = end;
            context.loadingNextPage = false;
        }, 500);
    }
    }(RongIM, null, RongIM.components));
    
