(function (RongIM, dependencies, components) {
    'use strict';
    var utils = RongIM.utils;
    var common = RongIM.common;
    var $ = dependencies.jQuery;
    var drag = RongIM.drag;
    var isBusy = false;
    var orgazApi = RongIM.dataModel.Organization;
    var Friend = RongIM.dataModel.Friend;

    RongIM.dialog.user = function (userId, closeFuc, disabledEdit, type, callBack, visible) {
        console.log(userId, closeFuc, disabledEdit, type, visible)
        if (isBusy) {
            return;
        }
        var im = RongIM.instance;
        isBusy = true;

        // 是否显示手机号由服务端下发配置
        var serverConfig = RongIM.serverConfig;
        // var privacyMobile = false;
        var displayMobile = serverConfig.privacy.display_mobile;
        var options = {
            name: 'user',
            template: '#rong-template-user',
            data: function () {
                return {
                    avatarEditable: false,
                    aliasEditable: false,
                    user: null,
                    infoList: [],
                    alias: '',
                    // 用户是否是当前登录用户
                    isLoginUser: false,
                    // 用户是否是内部员工
                    isStaff: false,
                    // 是否好友
                    isFriend: false,
                    disabledEdit: disabledEdit,
                    isShowEntry: type || '',
                    pinGroupList: [], //所属通讯组列表
                    pinGroup: '', //所属通讯组
                    isEditGroup: false,
                    allGroups: [], //所有通讯组
                    selectGroup: {
                        id: ''
                    },
                    groupName: '', //新增组名称
                    pinGroupListNew:[],
                    visible: visible || 1, // 1：全部可见，2：部分可见
                };
            },
            components: {
                avatar: components.getAvatar,
                'edit-avatar': components.editAvatar
            },
            directives: {
                focus: {
                    inserted: function (el) {
                        el.focus();
                    }
                }
            },
            computed: {
                showMobile: function () {
                    if (this.isStaff) {
                        return displayMobile || Boolean(im.auth.display_mobile);
                    }
                    return true;
                },
                executiveLimit: function () {
                    if (this.isFriend || im.auth.isExecutive) {
                        return false;
                    }
                    if (this.user) {
                        return !!this.user.isExecutive;
                    }
                    return undefined;
                },
                showStar: function () {
                    return !this.isLoginUser && (this.isStaff || this.isFriend);
                },
                showEditAlias: function () {
                    if (im.auth.isStaff) {
                        if ((this.isStaff || this.isFriend) && !this.isLoginUser) {
                            return true;
                        }
                    } else if (this.isFriend) {
                        return true;
                    }
                    return false;
                },
                showStartCoversation: function () {
                    return !this.isLoginUser && (this.isStaff || this.isFriend);
                },
                showStartCoversationNoIsLoginUser: function () {
                    return this.isStaff || this.isFriend;
                },
                userName: function () {
                    var name = this.user.name;
                    if (!this.isStaff && !this.isFriend && !this.isLoginUser) {
                        // name = name.replace(/.(?=.)/g, '*');  //只显示最后一个字
                        name = name.replace(/.$/g, '*');
                    }
                    return name;
                },
                hasAvatar: function () {
                    var cursor = 'auto';
                    var user = this.user;
                    if (user) {
                        var isFileHelper = user.type === 3;
                        if (this.user.avatar && !isFileHelper) {
                            cursor = 'pointer';
                        } else {
                            cursor = 'auto';
                        }
                    } else {
                        cursor = 'auto';
                    }
                    return cursor;
                },
                isDeleted: function () {
                    return this.user && this.user.state === common.UserState.DELETED;
                },
                notMe: function () {
                    return this.user && this.user.id !== im.loginUser.id;
                },
                isFileHelper: function () {
                    var user = this.user || {};
                    return user.type === 3;
                },
                //是否显示超长提示
                showErrorText: function () {
                    return this.groupName.length > 15
                }
            },
            created: function () {
                var api = {
                    org: im.dataModel.Organization,
                    user: im.dataModel.User,
                    friend: im.dataModel.Friend,
                    group: im.dataModel.Group
                };
                created(this, api, userId, im);
                // if(item != undefined){
                //   this.getApplyList()
                // }
            },
            destroyed: function () {
                im.dataModel.User.unwatch(this.userwatch);
            },
            methods: getMethods(im, userId, closeFuc, disabledEdit, type, item, callBack)
        };

        common.mountDialog(options, function (instance) {
            RongIM._user = instance;
        });
    };

    function created(context, api, userId, im) {
        var auth = im.auth;

        if (userId === auth.id) {
            context.isLoginUser = true;
        }
        if (auth.isStaff) {
            api.user.get(userId, function (errorCode, user) {
                console.log("user",user);
                if (errorCode) {
                    getDeletedUser(api, context, userId);
                    return;
                }
                context.isStaff = (user.type === common.UserType.STAFF);
                if (!context.isStaff) {
                    getFriendInfo(context, api, user);
                    syncUserInfo(context, api, user);
                    return;
                }
                api.user.getDetail(userId, function (error, userDetail) {
                    console.log("userDetail",userDetail);
                    if (error) {
                        getDeletedUser(api, context, userId);
                        return;
                    }
                    // orgsInfo 为空是新增员工需要同步组织机构信息 organization company department
                    if (utils.isEmpty(userDetail.orgsInfo)) {
                        RongIM.syncdata.allOrgs(function (err) {
                            if (err) {
                                // 输出并记录错误
                                return;
                            }
                            getFriendInfo(context, api, userDetail);
                            syncUserInfo(context, api, userDetail);
                        });
                        return;
                    }
                    getFriendInfo(context, api, userDetail);
                    syncUserInfo(context, api, userDetail);
                    //查询所有的通讯组
                    getPinGroups(context)
                    //.查询个人所在的通讯组
                    getPersonalGroup(context, api, userDetail)
                });
            });
        } else {
            api.user.get(userId, function (errorCode, user) {
                if (errorCode) {
                    context.toastError(errorCode);
                    return;
                }
                context.isStaff = false;
                getFriendInfo(context, api, user);
                syncUserInfo(context, api, user);
            });
        }
        context.userwatch = function (user) {
            if (context.user && user.id === context.user.id) {
                $.extend(context.user, user);
            }
        };
        api.user.watch(context.userwatch);
    }

    function getPersonalGroup(context, api, user) {
        api.user.getPersonalGroup(user.id, function (errorCode, result) {
            if (errorCode) {
                context.toastError(errorCode);
                return;
            }
            context.pinGroupList = result.data;
            context.pinGroupListNew = utils.deepClone(result.data);
            let str = ''
            result.data.forEach(obj => {
                str += obj.name + '、'
            })
            context.pinGroup = str.substring(0, str.length - 1)

        })
    }

    function syncUserInfo(context, api, user) {
        var userId = user.id;
        if (context.isStaff) {
            RongIM.syncdata.staffById(userId, function () {
                api.user.getDetail(userId, function (errorCode, staff) {
                    if (errorCode) {
                        getDeletedUser(api, context, userId);
                        return;
                    }
                    context.isStaff = (staff.user_type === common.UserType.STAFF);
                    getFriendInfo(context, api, staff);
                });
            });
        } else {
            RongIM.syncdata.userById([userId], function () {
                api.user.getNewUser(userId, function (errorCode, userInfo) {
                    if (errorCode) {
                        context.toastError(errorCode);
                        return;
                    }
                    context.isStaff = false;
                    getFriendInfo(context, api, userInfo);
                });
            });
        }
    }

    function getDeletedUser(api, context, userId) {
        api.user.getBatch([userId], function (errorCode, users) {
            if (errorCode) {
                context.toastError(errorCode);
                return;
            }
            context.user = users[0];
        });
    }

    function sortMajorCompany(list, majorCompanyId) {
        var index = 0;
        list.forEach(function (item, i) {
            if (item.companyId === majorCompanyId) {
                index = i;
            }
        });
        var majorCompany = list.splice(index, 1)[0];
        if (!utils.isEmpty(majorCompany)) {
            list.unshift(majorCompany);
        }
    }

    /*
    说明：多公司多部门 - 获取用户信息
    备注：这里用重复数据做假数据产品暂无设计多部门不同信息的管理
    */
    function getUserInfoList(user, orgApi) {
        var infoList = [];
        var orgsInfo = user.orgsInfo || [];
        console.log("orgsInfo",orgsInfo);
        var cache = {};
        orgsInfo.forEach(function (orgInfo) {
            // 判断第二级是否是独立子公司，是则从独立子公司开始计算
            var company = orgInfo.path[0] || {};
            var subcompany = orgInfo.path[1];
            var isAutomy = subcompany && orgApi.isAutonomyCompany(subcompany.id);
            var path = orgInfo.path;
            if (isAutomy) {
                company = subcompany;
                path.shift();
            }
            var dept = {
                id: orgInfo.id,
                type: orgInfo.type,
                name: orgInfo.name,
                path: path
            };
            if (cache[company.id]) {
                cache[company.id].deptList.push(dept);
            } else {
                var userInfo = $.extend({}, user, {
                    companyId: company.id,
                    companyName: company.name,
                    deptList: [dept]
                });
                cache[company.id] = userInfo;
                console.log("userInfo",userInfo);
                infoList.push(userInfo);
            }
        });

        var majorCompanyId = user.companyId;
        sortMajorCompany(infoList, majorCompanyId);
        console.log("infoList",infoList);

        return infoList;
    }

    function getFriendInfo(context, api, user) {
        console.log("user2",user);
        var friendApi = api.friend;
        var orgApi = api.org;
        var userId = user.id;
        var userApi = api.user;
        var groupApi = api.group;
        // delete user.tel;
        context.user = user;
        userApi.observerList.notify(user);
        groupApi.updateGroupMember(user);
        var cacheFriend = friendApi.getCacheFriend(userId);
        if (cacheFriend) {
            context.isFriend = true;
            context.user.mobile = cacheFriend.tel;
        } else {
            friendApi.getCacheFriend(userId, function (errorCode, friend) {
                if (errorCode) {
                    context.isFriend = false;
                    return;
                }
                context.isFriend = true;
                context.user.mobile = friend.tel;
            });
        }

        var requestInfo = friendApi.getRequest(userId);
        user.requestInfo = requestInfo;
        context.infoList = getUserInfoList(user, orgApi);
    }

    function getMethods(im, userId, closeFuc, disabledEdit, type, item, callBack) {
        var dataModel = im.dataModel;
        var friendApi = im.dataModel.Friend;
        var conversationApi = im.dataModel.Conversation;
        var messageApi = im.dataModel.Message;
        var im = RongIM.instance;
        var orgApi = dataModel.Organization;
        return {
            isShowPaging() {
                let that = this;
                let arr = Array.prototype.slice.call(that.applyList);
                if (item && item.orgsInfo) {
                    item.orgsInfo.forEach((element, index) => {
                        for (let i of element.path) {
                            if (arr.indexOf(i.id) != -1) {
                                that.isFollow = false;
                            }
                        }
                    })
                } else if (item && !item.orgsInfo && item.path) {
                    for (let i of item.path) {
                        if (arr.indexOf(i.id) != -1) {
                            that.isFollow = false;
                        }
                    }
                }
                console.log(that.isFollow)
            },
            //获取关注的list
            getApplyList() {
                let that = this,
                    params = {
                        focustate: '0,1'
                    };
                orgApi.getMyfollow(RongIM.instance.auth.id, params, function (result) {
                    result.data.forEach((element, index) => {
                        // that.applyList[element.id] = element
                        that.applyList.push(element.id)
                    })
                    that.isShowPaging()
                })
            },
            toastError: function (errorCode) {
                var el = null;
                if (this.$el) {
                    el = this.$el.firstChild;
                }
                common.toastError(errorCode, el);
            },
            getFullDeptPath: function (item, info) {
                if (item.type === common.OrgType.COMPANY) {
                    return item.name;
                }
                var subcompany = item.path[1];
                if (subcompany && subcompany.type === common.OrgType.COMPANY) {
                    console.log("subcompany",subcompany.name + ' - ' + item.name);
                    return subcompany.name + ' - ' + item.name;
                }
                if (info.vchar_p3) {
                    if (!info.extDuties) {
                        info.extDuties = this.getExtDuties(info.vchar_p3);
                    }
                    
                    if (info.extDuties[item.id]) {
                        console.log("extDuties",item.name + " - " + info.extDuties[item.id]);
                        return item.name + " - " + info.extDuties[item.id];
                        // return '';
                    }
                }
                if (info.duty_name) {
                    console.log("name",item.name);
                    // return item.name + ' - ' + info.duty_name;
                    return item.name ;
                }
                return item.name;
            },
            getExtDuties: function (strVal) {
                var duties = {};
                strVal.split(',').forEach(function (dutyItem) {
                    var dutyPair = dutyItem.trim().split(':');
                    if (dutyPair.length > 1) {
                        duties[dutyPair[0].trim()] = dutyPair[1].trim();
                    }
                });
                return duties;
            },
            fullPath: function (item) {
                var pathArray = [];
                item.path.map(function (pathItem) {
                    if (pathItem != null) {
                        pathArray.push(pathItem.name);
                        return pathItem;
                    }
                });
                return pathArray.join('/');
            },
            setAliasEditable: function () {
                setAliasEditable(this);
            },
            setAvatarEditable: function () {
                this.avatarEditable = true;
            },
            setAlias: function () {
                setAlias(this, dataModel.User, this.user.id, this.alias);
            },
            cancelAlias: function () {
                this.alias = this.user.alias;
                this.aliasEditable = false;
            },
            setStar: function () {
                setStar(this, dataModel.Star, userId, callBack);
            },
            unsetStar: function () {
                unsetStar(this, dataModel.Star, userId, callBack);
            },
            //保存通讯组
            savePinGroup: function () {
                savePinGroup(this, dataModel.User, callBack);

            },
            startConversation: function () {
                startConversation(this, im.$router, conversationApi);
            },
            srcChanged: function (src, big_src) {
                this.user.avatar = src;
                this.user.portrait_url = src;
                this.user.portrait_big_url = big_src;
            },
            addFriend: function () {
                // if(type != undefined && type){
                addFriend(this);
                // }
            },
            viewAvatar: function (user) {
                var hasAvatar = this.hasAvatar === 'pointer';
                if (hasAvatar) viewAvatar(this, user, im);
            },
            removeFriend: function () {
                var context = this;
                common.messagebox({
                    type: 'confirm',
                    message: context.locale.removeFriendBefore,
                    submitText: context.locale.btns.remove,
                    callback: function () {
                        // utils.console.info('TODO 删除好友');
                        var api = {
                            friend: friendApi,
                            conversation: conversationApi,
                            message: messageApi,
                            star: im.dataModel.Star
                        };
                        removeFriend(context, api, userId, im);
                    }
                });
            },
            addPin: function () {
                RongIM.dialog.addPin({
                    targetUser: this.user
                });
            },
            close: function () {
                this.user = null;
                isBusy = false;
                if (closeFuc) closeFuc();
            },
            openPinGroup: function () {
                let that = this
                if (that.pinGroupList.length == 0) {
                    that.isEditGroup = false;
                    return false;
                }
                common.messagebox({
                    type: 'confirm',
                    message: that.locale.btns.saveThis,
                    callback: function () {
                        that.savePinGroup()
                    },
                    closeCallback: function () {
                        that.isEditGroup = false;
                        that.pinGroupList = utils.deepClone(that.pinGroupListNew);
                    },
                    hashchangeClose: false
                });
            },
            selectObj: function (obj) {
                let flag = this.pinGroupList.filter(res => res.id == obj.id)
                if (flag.length > 0) {
                    this.pinGroupList.splice(this.pinGroupList.findIndex(item => item.id === obj.id), 1)
                    return;
                }
                this.selectGroup = obj
                let list = this.pinGroupList;
                list.push(obj)
                this.pinGroupList = this.unique(list)

            },
            unique(arr) {
                const res = new Map();
                return arr.filter((arr) => !res.has(arr.name) && res.set(arr.name, 1));
            },
            isExis: function (item) {
                let arr = this.pinGroupList.filter(obj => obj.name == item.name)
                if (arr.length > 0) {
                    return true
                } else {
                    return false
                }
            },
            //删除元素
            delItem: function (index) {
                this.pinGroupList.splice(index, 1);
            },
            //点击空格键添加到所属通讯组
            saveGrou() {
                if (this.groupName.length > 15) {
                    this.$refs.groupName.focus()
                    return;
                }
                let obj = {
                    name: this.groupName
                }
                //输入的通讯组名称已存在

                if (this.groupName == '') {
                    return;
                }
                let arr = this.allGroups.filter(obj => obj.name == this.groupName)
                //所属工作组存在
                let sele = this.pinGroupList.filter(obj => obj.name == this.groupName)
                if(sele.length >0){
                    this.$refs.groupName.focus()
                    return ;
                }
                    this.pinGroupList.push(obj)

                this.groupName = ''
            },
            toastError: function (errorCode) {
                var el = null;
                if (this.$el) {
                    el = this.$el.firstChild;
                }
                common.toastError(errorCode, el);
            },


        };
    }
    //获取所有的通讯组
    function getPinGroups(context) {
        orgazApi.getPinGroups('', res => {
            if (!res.count) return;
            context.allGroups = res.data

        })
    }

    function setAliasEditable(context) {
        context.alias = context.user.alias;
        context.aliasEditable = true;
    }

    function setAlias(context, userApi, userId, alias) {
        userApi.setAlias(userId, alias, function (errorCode) {
            if (errorCode) {
                context.toastError(errorCode);
                return;
            }
            context.user.alias = context.alias;
            context.aliasEditable = false;
        });
    }

    function savePinGroup(context, userApi, callback) {
        let param = {
            staff_uid: context.user.id,
            receiver_names: context.pinGroupList.map(obj => obj.name)
        }
        userApi.changePersonalGroup(param, function (errorcode, res) {
            if (errorcode) {
                return;
            }
            context.isEditGroup = false
            let str = ''
            context.pinGroupList.forEach(obj => {
                str += obj.name + '、'
            })
            context.pinGroup = str.substring(0, str.length - 1)
            context.pinGroupListNew = utils.deepClone(context.pinGroupList)
            let userObj = context.user
            context.close();
            if (callback) {
                callback(true,userObj.id)
            }
        })
    }

    function setStar(context, starApi, userId, callback) {
        starApi.star(userId, function (errorCode) {
            if (errorCode) {
                context.toastError(errorCode);
                return;
            }
            common.messageToast({
                message: context.locale.setStarMessage, // toast
                type: 'success'
            });
            context.user.star = true;
            context.close();
            if (callback) {
                callback()
            }
        });
    }

    function unsetStar(context, starApi, userId, callback) {
        starApi.unstar(userId, function (errorCode) {
            if (errorCode) {
                context.toastError(errorCode);
                return;
            }
            common.messageToast({
                message: context.locale.unsetStarMessage, // toast
                type: 'success'
            });
            if (context.user) {
                context.user.star = false;
            }
            context.close();
            if (callback) {
                callback()
            }
        });

    }

    function startConversation(context, router, conversationApi) {
        var params = {
            conversationType: utils.conversationType.PRIVATE,
            targetId: context.user.id
        };
        router.push({
            name: 'conversation',
            params: params
        });
        conversationApi.add(params);
        setTimeout(function () {
            var itemId = ['conversation', params.conversationType, params.targetId].join('-');
            var item = document.getElementById(itemId);
            if (item) {
                var parentHeight = item.parentNode.offsetHeight;
                var offsetTop = item.offsetTop;
                var alginWithTop = offsetTop > parentHeight;
                item.scrollIntoView(alginWithTop);
            }
        }, 50);
        context.close();
    }

    function addFriend(context) {
        RongIM.dialog.verifyFriend(context.user);
        context.close();
    }

    function viewAvatar(context, user, im) {
        if (!user.portrait_big_url && !user.portrait_url && !user.avatar) {
            return;
        }
        var options = getImageOptions({
            template: '#rong-template-image-rebox',
            bigAvatar: {
                content: {
                    imageUri: user.portrait_big_url || user.portrait_url || user.avatar
                },
                uId: user.id
            }
        });
        options.mixins = options.mixins || [];
        var localeMix = {
            computed: {
                locale: function () {
                    var locale = RongIM.instance.locale;
                    return locale;
                }
            }
        };
        options.mixins.push(localeMix);

        var Image = Vue.extend(options);
        var instance = new Image({
            el: document.createElement('div')
        });
        var wrap = im.$el.firstChild;
        $(wrap).append(instance.$el);
    }

    function clearMessages(conversationType, targetId, messageApi) {
        var params = {
            conversationType: conversationType,
            targetId: targetId
        };
        messageApi.clearMessages(params, function () {
            // 删除成功
        });
    }

    function removeFriend(context, api, friendId, im) {
        api.friend.delFriend(friendId, function ( /* errorCode, list */ ) {
            // TODO: 删除聊天记录
            // utils.console.log('TODO 删除聊天记录', list);
            // 删除组织外人员同时删除会话列表, 同时删除星标
            var privateConversation = utils.conversationType.PRIVATE;
            if (!context.isStaff) {
                clearMessages(privateConversation, friendId, api.message);
                api.conversation.remove(privateConversation, friendId);
                if (context.user.star) {
                    unsetStar(context, api.star, friendId);
                }
                var params = im.$route.params;
                var conversation = {
                    conversationType: privateConversation,
                    targetId: friendId
                };
                if (common.sameConversaton(params, conversation)) {
                    im.$router.push({
                        name: 'conversation',
                        query: {
                            force: 1
                        }
                    });
                }
            }
            context.close();
        });
    }

    function getImageOptions(options) {
        return {
            name: 'image',
            template: options.template,
            data: function () {
                return {
                    show: true,
                    loading: true,
                    bigAvatar: options.bigAvatar || '',
                    // 'normal' or 'full'
                    size: 'normal',
                    margin: 0,
                    scale: 1
                };
            },
            computed: {
                current: function () {
                    return this.bigAvatar;
                },
                hasPrev: function () {
                    return false;
                },
                hasNext: function () {
                    return false;
                }
            },
            watch: {
                currentIndex: function () {
                    this.scale = 1;
                    this.margin = 0;
                }
            },
            mixins: [
                components.getFullscreen()
            ],
            methods: {
                close: function () {
                    this.show = false;
                },

                dragImg: function (event) {
                    dragImg(this, event);
                },
                toggle: function () {
                    var context = this;
                    context.margin = 0;
                    context.scale = getScale(context.$refs.img);
                    context.toggleFullScreen(context.$el);
                },
                prev: function () {

                },
                next: function () {

                },
                zoomIn: function (STEP) {
                    var MAX_SCALE = 9;
                    this.scale = Math.min(MAX_SCALE, this.scale + STEP);
                },
                zoomOut: function (STEP) {
                    var MIN_SCALE = 0.1;
                    this.scale = Math.max(MIN_SCALE, this.scale - STEP);
                },
                zoom: utils.throttle(function (event) {
                    var STEP = 0.25;
                    if (event.deltaY < 0) {
                        this.zoomIn(STEP);
                    } else if (event.deltaY > 0) {
                        this.zoomOut(STEP);
                    }
                }, 80),
                download: function (message) {
                    var _file = utils.getFilename(message.content.imageUri);
                    var filename = '';
                    if (_file.ext === '') {
                        filename = utils.getDateId() + '.png';
                    }
                    var file = {
                        url: message.content.imageUri,
                        name: filename
                    };
                    var downloader = RongIM.download(file);
                    downloader.saveAs();
                }
            }
        };
    }

    function getScale(img) {
        getScale.size = getScale.size || {};

        var $img = $(img);
        var src = $img.attr('src');
        if (!getScale.size[src]) {
            getScale.size[src] = {
                width: $img.width(),
                height: $img.height()
            };
        }

        var imgSize = getScale.size[src];
        var $wrap = $img.parent();
        var wrapWidth = $wrap.width();
        var wrapHeight = $wrap.height();

        var scale = 1;
        if (imgSize.width > wrapWidth) {
            var widthScale = wrapWidth / imgSize.width;
            scale = Math.min(scale, widthScale);
        }
        if (imgSize.height > wrapHeight) {
            var heightScale = wrapHeight / imgSize.height;
            scale = Math.min(scale, heightScale);
        }
        return scale;
    }

    function dragImg(context, event) {
        var el = event.target;
        var $el = $(el);
        var oldPosition = {
            left: parseFloat($el.css('left')),
            top: parseFloat($el.css('top'))
        };
        drag(el, event, function (position) {
            var deltaX = position.left - oldPosition.left;
            var deltaY = position.top - oldPosition.top;
            var margin = '{top}px 0 0 {left}px'.replace('{top}', deltaY);
            margin = margin.replace('{left}', deltaX);
            context.margin = margin;
        }, el.parentElement);
    }
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));