(function (RongIM, dependencies, components) {
    'use strict';
    var common = RongIM.common;
    var utils = RongIM.utils;
    var $ = dependencies.jQuery;
    var dialog = RongIM.dialog;
    var dataModel = RongIM.dataModel;
    var conversationApi = dataModel.Conversation;
    var server = RongIM.dataModel.config.dataModel.server;
    RongIM.dialog.agreeGroup = function (Message, l) {
        var im = RongIM.instance;
        var groupApi = im.dataModel.Group;
        var options = {
            name: 'agree-group',
            template: 'templates/conversation/agree-group.html',
            data: function () {
                return {
                    // url参数
                    requestParams: {},
                    groupsInfo: '',
                    userInfoUid: '',
                    isshowagree: '',
                    group: {
                        id: '',
                        member_avatars: [],
                        member_names: [],
                        member_id_list: []
                    }
                };
            },
            components: {
                avatar: components.getAvatar,
            },
            inject: ['reload'], //刷新页面不闪烁
            computed: {
                // isshowagree: function () {
                    
                    // }
                },
                created: function () {
                console.log(Message);
                var url = Message.message.content.url
                this.userInfoUid = im.auth.id
                this.getRequestParams(url)
                this.initGroup(this, groupApi);
                console.log(1111, server);
            },
            methods: {
                startConversation() { },
                initGroup(context, groupApi) {
                    groupApi.getList(function (errorCode, groups) {
                        if (errorCode) {
                            context.groups = [];
                            // context.isLoadDone = true;
                            common.toastError(errorCode);
                            return;
                        }
                        console.log(groups);
                        groups.forEach(function (item, index) {
                            item.wType = groups.length - index + item.type * groups.length;
                        });

                        groups.sort(function (a, b) {
                            return b.wType - a.wType;
                        });

                        context.groups = groups;
                        // context.isLoadDone = true;
                    });
                },

                getRequestParams(url) {
                    if (url.indexOf("?") !== -1) {
                        let str = url.substr(url.indexOf("?") + 1); //截取?后面的内容作为字符串
                        let strs = str.split("&"); //将字符串内容以&分隔为一个数组
                        for (let i = 0; i < strs.length; i++) {
                            this.requestParams[strs[i].split("=")[0]] = decodeURI(strs[i].split("=")[1]); // 将数组元素中'='左边的内容作为对象的属性名，'='右边的内容作为对象对应属性的属性值  
                        }
                    }
                    this.GroupInfo(this.requestParams.groupId)
                    console.log(this.requestParams);
                },
                GroupInfo(groupId) {
                    var httpRequest = RongIM.dataModel._httpRequest;
                    let context = this
                    console.log("groupId", groupId);
                    var httpRequest = new XMLHttpRequest();
                    httpRequest.open('GET', server+'/groups/' + groupId, true);
                    httpRequest.send();
                    httpRequest.onreadystatechange = function () {
                        if (httpRequest.readyState == 4 && httpRequest.status == 200) {
                            var json = httpRequest.responseText;//获取到json字符串，还需解析
                            context.groupsInfo = JSON.parse(json).result;
                            context.group.id = context.groupsInfo.id
                            context.group.avatar = context.groupsInfo.portrait_url;
                            context.group.admin_id = context.groupsInfo.manager_id;
                            context.group.member_id_list = context.groupsInfo.members.map(function (member) {
                                return member.id;
                            });
                            context.group.member_brief = context.groupsInfo.members.map(function (member) {
                                return {
                                    id: member.id,
                                    createDt: member.create_dt
                                };
                            });
                            var xhr = new XMLHttpRequest();
                            xhr.open("POST",  server+'/groups/batch/members', true);
                            xhr.setRequestHeader('Content-Type', 'application/json');
                            xhr.send(JSON.stringify({
                                ids: [context.group.id]
                            }));
                            xhr.onreadystatechange = function () {
                                if (xhr.readyState == 4 && xhr.status == 200) {
                                    var json = xhr.responseText;//获取到json字符串，还需解析
                                    let result = JSON.parse(json).result;
                                    console.log("post", result);
                                    var groupMemberInfo = ((result[0] || {}).member_infos || []);
                                    context.group.member_names = groupMemberInfo.map(function (userItem) {
                                        return userItem.name;
                                    });
                                    context.group.member_avatars = groupMemberInfo.map(function (userItem) {
                                        return userItem.portrait_url;
                                    });
                                }
                            }
                            console.log(context.group);
                            var eidlist = [];
                            context.groupsInfo.members.forEach(e => {
                                eidlist.push(e.id)
                                if (e.id == context.userInfoUid) {
                                    if (e.jq_status == 3) {
                                        return context.isshowagree = true
                                    } else if (e.jq_status == 1) {
                                        return context.isshowagree = false
                                    }
                                }
                            })
                            if (eidlist.indexOf(context.userInfoUid) == -1) {
                                return context.isshowagree = true
                            }
                        }
                    };
                },
                startConversation(context, id) {
                    startConversation(context, id, im.dataModel.Conversation)

                },
                agreeGroup() {
                    let context = this
                    groupApi.inviteAccept(context.requestParams.groupId, function (res) {
                        console.log(res);
                        context.isshowagree = false
                        context.startConversation(context, context.requestParams.groupId)
                    })
                },
                getOneGroup(id) {
                    if (Cache.group._defer[id]) {
                        return Cache.group._defer[id].promise();
                    }

                    var defer = $.Deferred();
                    Cache.group._defer[id] = defer;

                    var getGroupFailed = function () {
                        var group = {
                            id: id,
                            member_avatars: [],
                            member_names: [],
                            member_id_list: []
                        };
                        var thisGroup = Cache.group[id] || group;
                        // Cache.group[id] = thisGroup;
                        defer.resolve(thisGroup);
                    };

                    var url = '/groups/' + id;
                    Http.get(url).then(function (group) {
                        if (!group) {
                            getGroupFailed();
                            return;
                        }

                        group.avatar = group.portrait_url;
                        group.admin_id = group.manager_id;
                        group.member_id_list = group.members.map(function (member) {
                            return member.id;
                        });
                        group.member_brief = group.members.map(function (member) {
                            return {
                                id: member.id,
                                createDt: member.create_dt
                            };
                        });
                        var organization = orgApi.getLocalDept(group.organization_id);
                        if (organization.type === common.OrgType.COMPANY) {
                            var co = orgApi.getLocalCompany(group.organization_id) || {};
                            organization.fullName = co.fullName;
                        }
                        group.organization = organization;
                        Group.batchMembers([group.id]).then(function (result) {
                            var groupMemberInfo = ((result[0] || {}).member_infos || []);
                            group.member_names = groupMemberInfo.map(function (userItem) {
                                return userItem.name;
                            });
                            group.member_avatars = groupMemberInfo.map(function (userItem) {
                                return userItem.portrait_url;
                            });
                            Cache.group[id] = group;
                            defer.resolve(group);
                        }, function (error) {
                            defer.reject(error);
                        });
                    }).fail(getGroupFailed).always(function () {
                        delete Cache.group._defer[id];
                    });
                    return defer.promise();
                }

            },

        };
        common.mountDialog(options);
        function startConversation(context, id, conversationApi) {
            var params = {
                targetId: id,
                conversationType: utils.conversationType.GROUP
            };
            var path = {
                name: 'conversation',
                params: params
            };
            context.$router.push(path);
            conversationApi.add(params);
            // 页面跳转完成后获取页面节点滚动会话列表
            setTimeout(function () {
                var itemId = ['conversation', params.conversationType, params.targetId].join('-');
                var item = document.getElementById(itemId);
                if (item) {
                    var parentHeight = item.parentNode.offsetHeight;
                    var offsetTop = item.offsetTop;
                    var alginWithTop = offsetTop > parentHeight;
                    item.scrollIntoView(alginWithTop);
                }
            }, 50);
        }
    };



}(RongIM, {
    jQuery: jQuery,
    UploadClient: UploadClient
}, RongIM.components));