(function (RongIM, dependencies, components) {
    'use strict';

    var common = RongIM.common;
    var utils = RongIM.utils;
    var $ = dependencies.jQuery;
    var dialog = RongIM.dialog;
    var dataModel = RongIM.dataModel;
    var conversationApi = dataModel.Conversation;

    RongIM.dialog.buildChain = function (msg, callback) {
        var im = RongIM.instance;
        var enabledSms = im.serverConfig.sms.verification_state;
        var maxReceiverCount = im.serverConfig.pin.max_receiver_count;
        var options = {
            name: 'build-chain',
            template: 'templates/conversation/build-chain.html',
            data: function () {
                return {
                    show: true,
                    isEdit: msg.isEdit || false,
                    chain: {
                        title: '',
                        content: '',
                        operate_name: ''
                    },
                    list: [],
                    message: msg.message || {},
                    loginUser: im.loginUser,
                    isCreator: false,
                    showInput: true,
                    myContent: '',
                    isEnter: false,
                    isInput: true,
                    isDel: false
                };
            },
            components: {
                avatar: components.getAvatar,
            },
            inject: ['reload'], //刷新页面不闪烁
            computed: {
                isOk: function () {
                    if (this.isEdit) {
                        return this.chain.content != undefined && this.chain.content != ''
                    } else {
                        return this.chain.title != ''
                    }

                    // && this.list.length > 0 && this.list.every(obj=>obj.content != '')
                },
            },
            created: function () {
                // 编辑接龙
                if (msg.isEdit) {
                    if (msg.message.content.extra) {
                        let extra = JSON.parse(msg.message.content.extra)
                        this.getJieLong(extra.jielongId)
                    }

                } else {
                    let creator = im.loginUser
                    this.chain.operate_name = creator.name,
                        this.chaincontent = ''

                }

            },
            mounted() {
                this.$nextTick(() => {
                    if (this.isEdit) {
                        this.$refs.chainContentUpdate.focus()
                    } else {
                        this.$refs.chainContent.focus()
                    }

                })

            },
            methods: {

                close: function () {
                    this.show = false;
                },
                buildChain: function () {
                    let that = this;
                    if (that.isEdit || that.isEnter) {
                        if (that.isDel) {
                            that.deleteJieLong()
                        } else {
                            that.updateJieLong()
                        }
                        return;
                    }
                    that.chain.create_uid = RongIM.instance.loginUser.id;
                    that.chain.operate_uid = that.chain.create_uid
                    that.chain.content = $("#chainContent").html()
                    conversationApi.createJieLong(that.chain, function (errorCode, res) {
                        if (errorCode) {
                            return;
                        }
                        that.chain.extra = JSON.stringify({
                            jielongId: res.uid
                        })

                        callback(that.chain);
                        that.close();
                    })
                },
                getJieLong: function (id) {
                    let that = this;
                    conversationApi.getJieLong(id, function (errorCode, res) {
                        if (errorCode) {
                            return;
                        }
                        that.chain = $.extend(that.chain, that.chain, res);
                        that.list = res.data.map(obj => {
                            let orgList = obj.main_org.path.map(item => item.name) || []
                            return {
                                ...obj,
                                isMe: obj.operate_uid == that.loginUser.id,
                                mainOrgName: orgList.length > 0 ? orgList.join(" > ") : ""
                            }
                        })

                        if (that.chain.creator_uid == that.loginUser.id) {
                            that.isCreator = false;
                        }
                        let name = that.list.filter(obj => obj.operate_uid == that.loginUser.id)[0].content
                        if (that.list.filter(obj => obj.operate_uid == that.loginUser.id).length > 0) {
                            that.showInput = false;
                            that.$nextTick(() => {
                                that.$refs.myContent[0].focus()
                                var range = window.getSelection(); //创建range
                                range.selectAllChildren(that.$refs.myContent[0]); //range 选择obj下所有子内容
                                range.collapseToEnd(); //光标移至最后
                            })

                        }

                    })
                },
                updateJieLong: function () {
                    let that = this;
                    let uid = that.chain.uid;
                    let string = ''
                    if (that.isEnter) {
                        if (that.showInput) {
                            string = $("#chainContentUpdate").html()
                        } else {
                            string = $('#myContent').html()
                        }
                    } else {
                        string = that.chain.content
                    }
                    let param = {
                        "operate_uid": that.loginUser.id,
                        "content": string
                    }
                    that.close();

                    conversationApi.updateJieLong(uid, param, function (errorCode, res) {
                        if (errorCode) {
                            return;
                        }
                        let obj = {
                            content: $("#chainContentUpdate").html(),
                            operate_name: that.loginUser.name,
                            operate_uid: that.loginUser.id,
                        }
                        that.list.push(obj)
                        that.chain.extra = JSON.stringify({
                            jielongId: uid
                        })
                        //参与接龙
                        // callback(that.chain);
                        common.messageToast({
                            message: '提交成功', // toast
                            type: 'success'
                        });
                        that.close();
                    })
                },
                deleteJieLong: function () {
                    let that = this;
                    let uid = that.chain.uid;
                    let param = {
                        "operate_uid": that.loginUser.id,
                        "content": ''
                    }
                  

                    conversationApi.deleteJieLong(uid, param, function (errorCode, res) {
                        if (errorCode) {
                            return;
                        }
                        callback({"isDel":true});
                        that.close();
                    })
                },
                editnameSet: function (index, e) {
                    let that = this;
                    that.isEnter = true;
                    let value = that.$refs.myContent[0].innerText
                    if (value == '') {
                        //需要调用删除
                        that.isDel = true
                    } else {
                        //不需要
                        that.isDel = false
                    }

                },
                showDiv: function () {
                    let that = this;
                    that.isInput = false;
                    console.log(that.$refs.chainContent)

                }
            },
            watch: {

            }
        };
        common.mountDialog(options);
    };



}(RongIM, {
    jQuery: jQuery,
    UploadClient: UploadClient
}, RongIM.components));