(function (RongIM, dependencies, components) {
'use strict';

var utils = RongIM.utils;
var browserWindow = RongIM.browserWindow;

var menuType = {
    0: 'parent',
    1: 'url',
    2: 'click'
};

var handleMenucommand = {
    parent: function (menu, context, im) {
        Vue.set(menu, 'show', true);
        menu.hidden = function () {
            menu.show = false;
            im.$off('imclick', menu.hidden);
            context.$off('hiddenMenu', menu.hidden);
        };
        context.$on('hiddenMenu', menu.hidden);
        im.$on('imclick', menu.hidden);
    },
    url: function (menu) {
        var url = menu.url;
        // openUrl(url);
        // browserWindow.openPSArticle(url);
        var loginInfo = utils.cache.get('loginInfo');
        var zkxToken = decodeURIComponent(loginInfo.zkxToken);
        if (url.match(/\/taskcenter\//i) != null && loginInfo.RCESESSIONID) {
            let urlParts = url.split('#');
            url = urlParts[0] + (
                urlParts[0].indexOf('?') > 0 ? '&' : '?'
            ) + "sessionid=" + encodeURIComponent(loginInfo.RCESESSIONID) +
            "&uid=RY" + loginInfo.zkxEmpId + (
                urlParts[1] ? ('#' + urlParts[1]) : ''
            );
        }
        browserWindow.openPSArticle(
            RongIM.config.loginServer + '/sign-bridge.html' +
            '?empId=' + (loginInfo.zkxEmpId || '') +
            '&target=' + encodeURIComponent(url) +
            '&token=' + encodeURIComponent(zkxToken + ';path=/')
        );
    },
    click: function (menu) {
        console.debug(menu);
    }
};

// 公众号服务聊天界 面菜单组件
components.getPublicMenu = function (resolve, reject) {
    var im = RongIM.instance;
    var dataModel = im.dataModel;
    var options = {
        name: 'public-menu',
        template: '#rong-template-public-menu',
        props: ['menuInfo'],
        data: function () {
            return {
                subShow: false
            };
        },
        methods: {
            // 公众号点击 切换输入框和菜单
            inputMenuChanged: function () {
                this.$emit('inputMenuChanged', false);
            },
            menuClick: function (menu) {
                // debugger
                var context = this;
                context.$emit('hiddenMenu');
                var handleName = menuType[menu.type];
                if (menu.type !== 0) {
                    sendMessage(menu, this.menuInfo, dataModel);
                }
                var handle = handleMenucommand[handleName];
                if (handle) {
                    handle(menu, context, im);
                }
            }
        }
    };

    utils.asyncComponent(options, resolve, reject);
};

// function openUrl(url) {
//     var a = document.createElement('A');
//     a.target = '_blank';
//     a.href = url;
//     document.body.appendChild(a);
//     a.click();
//     document.body.removeChild(a);
// }

function sendMessage(menu, menuInfo, dataModel) {
    var params = {
        conversationType: 7,
        targetId: menuInfo.app_id,
        cmd: '',
        id: menu.id,
        type: menu.type,
        name: menu.name,
        data: menu.id
    };
    if (menu.type === 1) {
        params.cmd = 'VIEW';
    } else if (menu.type === 2) {
        params.cmd = 'CLICK';
    }
    var msg = new RongIMClient.RegisterMessage.ClickMenuMessage({
        cmd: params.cmd, id: params.id, type: params.type, name: params.name, data: params.data
    });
    dataModel.Message.sendCommandMessage({
        conversationType: params.conversationType,
        targetId: params.targetId,
        content: msg
    });
}
}(RongIM, {
    jQuery: jQuery
}, RongIM.components));
