(function (RongIM, dependencies) {
    'use strict';

    var $ = dependencies.jQuery;
    var RongIMClient = dependencies.RongIMClient;
    var RongIMLib = dependencies.RongIMLib;
    var UploadClient = dependencies.UploadClient;
    var Http = RongIM.dataModel._Http;
    var Cache = RongIM.dataModel._Cache;
    var ObserverList = RongIM.dataModel._ObserverList;
    var utils = RongIM.utils;
    var common = RongIM.common;
    var store = RongIM.utils.cache;

    var userApi = RongIM.dataModel.User;
    var fileApi = RongIM.dataModel.File;

    var Pin = {
        observerList: new ObserverList()
    };
    var pinObserverList = Pin.observerList;

    Cache.pin = {
        attach: {}
    };

    Pin.cleanCache = function () {
        Cache.pin = {
            attach: {}
        };
    };

    Pin.loadApi = function () {
        userApi = RongIM.dataModel.User;
        utils = RongIM.utils;
    };

    function getReceiverList(detail) {
        var def = $.Deferred();
        Pin.getReceiverList(detail.uid, function (error, res) {
            if (error) {
                return;
            }
            detail.receiverList = res;
            def.resolve();
        })
        return def.promise();
    }

    function addUserToList(list, key) {
        var def = $.Deferred();
        var count = 0;
        if (list.length === 0) {
            def.resolve();
            return def;
        }
        var ids = list.map(function (item) {
            return item[key];
        });
        userApi.get(ids, function (errorCode, userList) {
            userList = [].concat(userList);
            userList.forEach(function (user) {
                count += 1;
                list.forEach(function (data) {
                    if (user && user.id === data[key]) {
                        data.user = user;
                    }
                });
                if (count === userList.length) def.resolve();
            });
        });
        return def;
    }

    Pin.registerMessage = function () {
        // Pin消息创建
        var messageName = 'PinNotifyMessage';
        var objectName = 'RCE:Pin';
        var messageTag = new RongIMLib.MessageTag(false, false);
        var properties = ['creatorUid', 'pinUid', 'timestamp', 'content'];
        RongIMClient.registerMessageType(messageName, objectName, messageTag, properties);

        // Pin被评论
        messageName = 'PinCommentMessage';
        objectName = 'RCE:PinComment';
        messageTag = new RongIMLib.MessageTag(false, false);
        properties = ['publisherUid', 'pinUid', 'timestamp', 'comment'];
        RongIMClient.registerMessageType(messageName, objectName, messageTag, properties);

        // Pin被确认
        messageName = 'PinConfirmMessage';
        objectName = 'RCE:PinConfirm';
        messageTag = new RongIMLib.MessageTag(false, false);
        properties = ['operatorUid', 'pinUid', 'timestamp'];
        RongIMClient.registerMessageType(messageName, objectName, messageTag, properties);

        // Pin新添加了联系人
        messageName = 'PinNewReciverMessage';
        objectName = 'RCE:PinNewReceiver';
        messageTag = new RongIMLib.MessageTag(false, false);
        properties = ['pinUid', 'timestamp', 'receivers'];
        RongIMClient.registerMessageType(messageName, objectName, messageTag, properties);

        // Pin一端删除，其他端收到该消息
        messageName = 'PinDeletedMessage';
        objectName = 'RCE:PinDeleted';
        messageTag = new RongIMLib.MessageTag(false, false);
        properties = ['pinUid', 'timestamp'];
        RongIMClient.registerMessageType(messageName, objectName, messageTag, properties);

        // pin评论阅读状态，多端同步消息
        messageName = 'PinCommentReadMessage';
        objectName = 'RCE:PinCommentRead';
        messageTag = new RongIMLib.MessageTag(false, false);
        properties = ['pinUid', 'timestamp'];
        RongIMClient.registerMessageType(messageName, objectName, messageTag, properties);

        // pin被撤回
        messageName = 'PinRevokeMessage';
        objectName = 'RCE:PinRevoke';
        messageTag = new RongIMLib.MessageTag(false, false);
        properties = ['operatorUid', 'pinUid', 'timestamp'];
        RongIMClient.registerMessageType(messageName, objectName, messageTag, properties);

        //通讯组被删除通知
        messageName = 'PinGroupDeleted';
        objectName = 'RCE:PinGroupDeleted';
        messageTag = new RongIMLib.MessageTag(false, false);
        properties = ['pinGroupUid', 'timestamp', 'operatorUid'];
        RongIMClient.registerMessageType(messageName, objectName, messageTag, properties);

        //通讯组被修改通知
        messageName = 'PinGroupSet';
        objectName = 'RCE:PinGroupSet';
        messageTag = new RongIMLib.MessageTag(false, false);
        properties = ['pinGroupUid', 'timestamp', 'operatorUid'];
        RongIMClient.registerMessageType(messageName, objectName, messageTag, properties);

        //通讯组被修改通知
        messageName = 'StaffPinGroupSet';
        objectName = 'RCE:StaffPinGroupSet';
        messageTag = new RongIMLib.MessageTag(false, false);
        properties = ['pinGroupUid', 'timestamp', 'operatorUid'];
        RongIMClient.registerMessageType(messageName, objectName, messageTag, properties);

        //待办通知
        messageName = 'UnDoProcess';
        objectName = 'RCE:UnDoProcess';
        messageTag = new RongIMLib.MessageTag(false, false);
        properties = ['timestamp', 'operatorUid'];
        RongIMClient.registerMessageType(messageName, objectName, messageTag, properties);

    };

    function notifyPin(message) {
        pinObserverList.notify(message);
    }

    Pin.messageCtrol = {
        PinNotifyMessage: function (message) {
            notifyPin(message);
        },
        PinCommentMessage: function (message) {
            notifyPin(message);
        },
        PinRevokeMessage: function (message) {
            notifyPin(message);
        },
        PinConfirmMessage: function (message) {
            if (message.content && Cache.auth && message.content.operatorUid !== Cache.auth.id) {
                notifyPin(message);
            }
            Pin.notifyUnReadCount(message.content.pinUid);
        },
        PinNewReciverMessage: function (message) {
            notifyPin(message);
        },
        PinDeletedMessage: function (message) {
            notifyPin(message);
        },
        PinCommentReadMessage: function (message) {
            notifyPin(message);
            // Pin.notifyUnReadCount(message.content.pinUid);
        },
        PinGroupDeleted: function (message) {
            notifyPin(message);
        },
        PinGroupSet: function (message) {
            notifyPin(message);
        },
        StaffPinGroupSet: function (message) {
            notifyPin(message);
        },
        UnDoProcess: function (message) {
            notifyPin(message);
        }
    };

    Pin.create = function (params, callback) {
        Http.post('/pins', params)
            .then(function (result) {
                callback(null, result);
            }).fail(callback);
    };

    function uniquify(result) {
        if (result.data && result.data.length > 0) {
            var objIdx = {};
            result.data.forEach(function (item) {
                if (objIdx[item.uid]) {
                    objIdx[item.uid].attach = [item.attach].concat(
                        objIdx[item.uid].attach
                    );
                } else {
                    objIdx[item.uid] = item;
                }
            });
            result.data = Object.values(objIdx);
        }
    }
    Pin.allPins = function (timestamp, callback) {

        var url = '/pins?limit=20&start=0';
        url += timestamp ? '&end=' + timestamp : '';
        Http.get(url)
            .then(function (result) {
                $.when(addUserToList(result.data, 'creator_uid'))
                    .done(function () {
                        uniquify(result);
                        callback(null, result);
                    });
            }).fail(callback);
    };
    //模糊搜索全部
    Pin.allMobileSearch = function (keyword, timestamp, callback) {
        var url = '/pins/allMobileSearch?limit=20&keyword=' + keyword;
        url += timestamp ? '&pageEnd=' + timestamp : '';
        Http.get(url)
            .then(function (result) {
                $.when(addUserToList(result.data, 'creator_uid'))
                    .done(function () {
                        // uniquify(result);
                        callback(null, result);
                    });
            }).fail(callback);
    };
    //模糊搜索全部
    Pin.allPcAccurateSearch = function (params, callback) {
        let paStr = "?attachedName=" + params.attachedName + "&&contacts=" + params.contacts + "&&title=" + params.title + "&&content=" + params.content + "&start=" + params.start + "&&end=" + params.end + '&&limit=20'
        paStr += params.timestamp ? '&pageEnd=' + params.timestamp : '';
        Http.get('/pins/allPcAccurateSearch' + paStr)
            .then(function (result) {
                $.when(addUserToList(result.data, 'creator_uid'))
                    .done(function () {
                        // uniquify(result);
                        callback(null, result);
                    });
            }).fail(callback);
    };
    Pin.getInbox = function (timestamp, callback) {
        var url = '/pins/inboxAll?limit=20&start=0';
        url += timestamp ? '&end=' + timestamp : '';
        Http.get(url)
            .then(function (result) {
                $.when(addUserToList(result.data, 'creator_uid'))
                    .done(function () {
                        uniquify(result);
                        callback(null, result);
                    });
            }).fail(callback);
    };

    Pin.getOutbox = function (timestamp, callback) {
        var url = '/pins/outboxAll?limit=20&start=0';
        url += timestamp ? '&end=' + timestamp : '';
        Http.get(url)
            .then(function (result) {
                $.when(addUserToList(result.data, 'creator_uid'))
                    .done(function () {
                        uniquify(result);
                        callback(null, result);
                    });
            }).fail(callback);
    };

    Pin.getInboxUnRead = function (callback) {
        var url = '/pins/inbox/unread';
        Http.get(url)
            .then(function (result) {
                $.when(addUserToList(result, 'creator_uid'))
                    .done(function () {
                        callback(null, result);
                    });
            }).fail(callback);
    };

    Pin.getOutboxUnRead = function (callback) {
        var url = '/pins/outbox/unread';
        Http.get(url)
            .then(function (result) {
                $.when(addUserToList(result, 'creator_uid'))
                    .done(function () {
                        callback(null, result);
                    });
            }).fail(callback);
    };
    // 获取为确认的
    Pin.getInboxUnconfirm = function (callback) {
        var url = '/pins/inbox/unconfirm';
        Http.get(url)
            .then(function (result) {
                $.when(addUserToList(result, 'creator_uid'))
                    .done(function () {
                        uniquify(result);
                        callback(null, result);
                    });
            }).fail(callback);
    };
    //回去新回复
    Pin.getUnread = function (callback) {
        var url = '/pins/unread';
        Http.get(url)
            .then(function (result) {
                $.when(addUserToList(result, 'creator_uid'))
                    .done(function () {
                        callback(null, result);
                    });
            }).fail(callback);
    };

    Pin.getPinDetail = function (id, callback) {
        var url = '/pins/' + id;
        Http.get(url)
            .then(function (result) {
                // callback(null, result);
                $.when(addUserToList([result], 'creator_uid'))
                    .done(function () {
                        callback(null, result);
                    });
            }).fail(callback);
    };
    Pin.getReceiverList = function (uid, callback) {
        var url = '/pins/' + uid + '/receivers';
        Http.get(url)
            .then(function (result) {
                result.forEach(function (item) {
                    item.user = {
                        id: item.receiver_uid,
                        name: item.name,
                        avatar: item.portrait_url
                    };
                });
                var notUserInfo = result.filter(function (item) {
                    return !item.name;
                });
                $.when(addUserToList(notUserInfo, 'receiver_uid'))
                    .done(function () {
                        callback(null, result);
                    });
            }).fail(callback);
    };
    Pin.getCommentList = function (uid, callback) {
        var url = '/pins/' + uid + '/comments';
        Http.get(url)
            .then(function (result) {
                $.when(addUserToList(result, 'publisher_uid'))
                    .done(function () {
                        callback(null, result);
                    });
            }).fail(callback);
    };

    Pin.deletePin = function (uid, callback) {
        var url = '/pins/' + uid;
        Http.del(url)
            .then(function (result) {
                callback(null, result);
            }).fail(callback);
    };

    Pin.comment = function (uid, comment, parentCommentUid, callback) {
        var params = {
            comment: comment
        };
        if (parentCommentUid) {
            params.parent_comment_uid = parentCommentUid;
        }
        var url = '/pins/' + uid + '/comments';
        Http.post(url, params)
            .then(function (result) {
                callback(null, result);
            }).fail(callback);
    };
    // 一键确认
    Pin.confirmAllOnce = function (params, callback) {
        var url = '/pins/confirm';
        Http.post(url, params).then(function (result) {
            callback(null, result);
        });
        // .then(function (result) {
        //      
        //     callback(null, result);
        // }).fail(callback);
    };
    Pin.confirm = function (uid, callback) {
        var url = '/pins/' + uid + '/confirm';
        Http.post(url)
            .then(function (result) {
                callback(null, result);
            }).fail(callback);
    };

    Pin.resend = function (uid, targetType, callback) {
        Http.post('/pins/remind', {
            pin_uid: uid,
            type: targetType
        }).then(function (resp) {
            callback(null, resp);
        }).fail(callback);
    };

    Pin.getUnReadCount = function (callback) {
        var url = '/pins/unreadcommentcount';
        Http.get(url)
            .then(function (result) {
                callback(null, result);
            }).fail(callback);
    };

    Pin.getUnConfirmCount = function (callback) {
        var url = '/pins/unconfirmedcount';
        Http.get(url)
            .then(function (result) {
                callback(null, result);
            }).fail(callback);
    };

    Pin.getAttachments = function (uid, callback) {
        var url = '/pins/' + uid + '/attachments';
        Http.get(url)
            .then(function (result) {
                callback(null, result);
            }).fail(callback);
    };

    Pin.addReceivers = function (uid, ids, callback) {
        var url = '/pins/' + uid + '/receivers';
        var params = {
            ids: ids
        };
        Http.post(url, params)
            .then(function (result) {
                callback(null, result);
            });
    };

    Pin.addPinLocalAttach = function (name, path) {
        var key = 'pin-attachs';
        var local = store.get(key) || {};
        local[name] = path;
        store.set(key, local);
    };

    Pin.getToken = function (callback) {
        var url = '/user/media_token/1';
        Http.get(url)
            .then(function (result) {
                callback(null, result);
            }).fail(callback);
    };

    Pin.uploadAttach = function (type, fileData, attach, callback) {
        var config = RongIM.config.upload[type] || RongIM.config.upload.file;
        config.timeout = RongIM.config.upload.timeout;
        config.chunk_size = RongIM.config.upload.file.chunkSize;
        var domain = '';
        if (type === 'base64') {
            config.data = UploadClient.dataType.data;
        }
        config.getToken = function (done) {
            var fileType = type === 'image' ? RongIMLib.FileType.IMAGE : RongIMLib.FileType.FILE;
            fileApi.getFileToken(done, fileType);
            // Pin.getToken(function(errorCode, result) {
            //     if (errorCode) {
            //         return  utils.console.warn('获取上传 token 失败');
            //     }
            //     domain = result.domain;
            //     done(result.token);
            // });
        };
        var actionMap = {
            file: 'initFile',
            image: 'initImage',
            base64: 'initImgBase64'
        };
        var action = actionMap[type];
        var uploadCallback = {
            onBeforeUpload: function () {},
            onProgress: function (loaded, total) {
                var percent = Math.floor(loaded / total * 100);
                attach.progress = percent;
            },
            onCompleted: function (data) {
                var url = common.getDownloadUrl(RongIM.config, data);
                url = url || location.protocol + '//' + domain + '/' + data.key;
                attach.progress = 100;
                attach.uploadStatus = utils.uploadStatus.SUCCESS;
                attach.url = url;
                if (callback) callback(null);
            },
            onError: function (errorCode) {
                if (callback) callback('upload-' + errorCode);
            }
        };

        UploadClient[action](config, function (uploadFile) {
            expendUploadAttach(attach, uploadFile, uploadCallback);
            attach.upload();
        });
    };

    function expendUploadAttach(attach, uploadFile, uploadCallback) {
        // 标识上传id,用于断点续传
        attach.data.uploadId = attach.uploadId;
        attach.cancel = function (callback) {
            callback = callback || $.noop;
            attach.uploadStatus = RongIM.utils.uploadStatus.CANCELLED;
            uploadFile.cancel();
            callback();
        };
        attach.upload = function () {
            if (attach.uploadStatus === RongIM.utils.uploadStatus.READY || attach.uploadStatus === RongIM.utils.uploadStatus.CANCELLED) {
                attach.uploadStatus = RongIM.utils.uploadStatus.UPLOADING;
                uploadFile.upload(attach.data, uploadCallback);
            }
        };
    }

    Pin.getPinLocalAttach = function (name) {
        var key = 'pin-attachs';
        var local = store.get(key) || {};
        return local[name];
    };

    Pin.removeLocalAttach = function (name) {
        var key = 'pin-attachs';
        var local = store.get(key) || {};
        delete local[name];
        store.set(key, local);
    };

    Pin.watch = function (listener) {
        pinObserverList.add(listener);
    };

    Pin.unwatch = function (listener) {
        pinObserverList.remove(listener);
    };

    Pin.MessageType = {
        PinNotifyMessage: 'PinNotifyMessage',
        PinCommentMessage: 'PinCommentMessage',
        PinConfirmMessage: 'PinConfirmMessage',
        PinNewReciverMessage: 'PinNewReciverMessage',
        PinDeletedMessage: 'PinDeletedMessage',
        PinCommentReadMessage: 'PinCommentReadMessage',
        PinRevokeMessage: 'PinRevokeMessage',
        PinGroupDeleted: 'PinGroupDeleted',
        PinGroupSet: "PinGroupSet",
        StaffPinGroupSet: 'RCE:StaffPinGroupSet',
        UnDoProcess: 'UnDoProcess',
    };

    Pin.notifyUnReadCount = function (pinUid) {
        pinUid = pinUid || '';
        var message = {
            messageType: Pin.MessageType.PinCommentReadMessage,
            content: {
                pinUid: pinUid
            }
        };
        pinObserverList.notify(message);
    };
    //高级搜索----我收到的
    Pin.pcAccurateSearchInbox = function (params, callback) {
        let paStr = "?limit=20&attachedName=" + params.attachedName + "&&contacts=" + params.contacts + "&&title=" + params.title + "&&content=" + params.content + "&start=" + params.start + "&&end=" + params.end
        paStr += params.timestamp ? '&pageEnd=' + params.timestamp : '';
        Http.get('/pins/pcAccurateSearchInbox' + paStr)
            .then(function (result) {
                $.when(addUserToList(result.data, 'creator_uid'))
                    .done(function () {
                        // uniquify(result);
                        callback(null, result);
                    });
            }).fail(callback);
    };
    //模糊搜索----我收到的
    Pin.mobileSearchInbox = function (keyword, timestamp, callback) {
        let paStr = "?limit=20&keyword=" + keyword;
        paStr += timestamp ? '&pageEnd=' + timestamp : '';
        Http.get('/pins/mobileSearchInbox' + paStr)
            .then(function (result) {
                $.when(addUserToList(result.data, 'creator_uid'))
                    .done(function () {
                        // uniquify(result);
                        callback(null, result);
                    });
            }).fail(callback);
    };
    //高级搜索----我发出的
    Pin.pcAccurateSearchOutbox = function (params, callback) {
        let paStr = "?limit=20&attachedName=" + params.attachedName + "&&contacts=" + params.contacts + "&&title=" + params.title + "&&content=" + params.content + "&start=" + params.start + "&&end=" + params.end
        paStr += params.timestamp ? '&pageEnd=' + params.timestamp : '';
        Http.get('/pins/pcAccurateSearchOutbox' + paStr)
            .then(function (result) {
                $.when(addUserToList(result.data, 'creator_uid'))
                    .done(function () {
                        uniquify(result);
                        callback(null, result);
                    });
            }).fail(callback);
    };
    //模糊搜索----我发出的
    Pin.mobileSearchOutbox = function (keyword, timestamp, callback) {
        let paStr = "?limit=20&keyword=" + keyword;
        paStr += timestamp ? '&pageEnd=' + timestamp : '';
        Http.get('/pins/mobileSearchOutbox' + paStr)
            .then(function (result) {
                $.when(addUserToList(result.data, 'creator_uid'))
                    .done(function () {
                        uniquify(result);
                        callback(null, result);
                    });
            }).fail(callback);
    };
    // 撤回寻呼
    Pin.revokePin = function (params, callback) {

        Http.post('/pins/revokePin', params)
            .then(function (result) {
                callback(null, result);
            }).fail(callback);
    };
    //获取当前要转发的收到的寻呼
    Pin.getSelfForward = function (uid, callback) {
        var url = '/pins/' + uid + '/getSelfForward';
        Http.get(url)
            .then(function (result) {
                callback(null, result);
            }).fail(callback);
    };
    // 取消寻呼
    Pin.cancelPin = function (uid, callback) {

        Http.del('/pins/'+uid+'/cancel')
            .then(function (result) {
                callback(null, result);
            }).fail(callback);
    };
    // 获取待办数量
    Pin.getUndoCount = function (callback) {
        var url = '/pins/undo';
        Http.get(url)
            .then(function (result) {
                callback(null, result);
            }).fail(callback);
    };

    RongIM.dataModel.Pin = Pin;
}(RongIM, {
    win: window,
    jQuery: jQuery,
    UploadClient: UploadClient,
    RongIMClient: RongIMClient,
    RongIMLib: RongIMLib
}));