/*
    公众号
 */
(function (RongIM) {
'use strict';

var Http = RongIM.dataModel._Http;
var Cache = RongIM.dataModel._Cache;

var Public = {};

Cache.public = {};

Public.cleanCache = function () {
    Cache.public = {};
};

// 获取公众号信息
Public.getPublicInfo = function (app_id, callback) {
    Http.get('/apps/' + app_id, function (errorCode, result) {
        if (errorCode) {
            callback(errorCode);
            return;
        }
        callback(result);
    });
};

Public.getPublicMenu = function (app_id, callback) {
    Http.get('/apps/' + app_id + '/menu', function (errorCode, result) {
        if (errorCode) {
            callback(errorCode);
            return;
        }
        callback(result);
    });
};

Public.search = function (name, callback) {
    Http.get('/apps/search?name=' + name + '&states=' + 0, function (errorCode, result) {
        if (errorCode) {
            callback(errorCode);
            return;
        }
        result.apps = result.apps.map(function (item) {
            item.avatar = item.logo_url;
            return item;
        });
        callback(null, result.apps);
    });
};

RongIM.dataModel.Public = Public;
}(RongIM));
