/* 星标联系人 */
(function (RongIM, dependencies) {
'use strict';

var $ = dependencies.jQuery;
var Http = RongIM.dataModel._Http;
var Cache = RongIM.dataModel._Cache;
var ObserverList = RongIM.dataModel._ObserverList;
var request = RongIM.dataModel._request;

var userApi = RongIM.dataModel.User;

var Star = {
    observerList: new ObserverList()
};
var starObserverList = Star.observerList;

Cache.starList = [];
Star.cleanCache = function () {
    Cache.starList = [];
};

Star.getList = function (callback) {
    callback = callback || $.noop;
    Http.get('/userrelation/starcontacts', function (errorCode, result) {
        if (errorCode) {
            callback(errorCode);
            return;
        }
        var idList = result.data.map(function (item) {
            return item.id;
        }).filter(function (id) {
            return id !== Cache.auth.id;
        });
        // 同步本地缓存信息
        Cache.starList = idList;
        // getUsers(idList, callback);
        userApi.getBatch(idList, callback);
    });
};

Star.star = function (targetId, callback) {
    callback = callback || $.noop;
    Http.post('/userrelation/starcontacts', {
        ids: [targetId]
    }, function (errorCode) {
        if (errorCode) {
            callback(errorCode);
            return;
        }
        callback();
        var index = Cache.starList.indexOf(targetId);
        if (index < 0) {
            Cache.starList.push(targetId);
        }
        starObserverList.notify();
    });
};

Star.unstar = function (targetId, callback) {
    callback = callback || $.noop;
    Http.del('/userrelation/starcontacts', {
        ids: [targetId]
    }, function (errorCode) {
        if (errorCode) {
            callback(errorCode);
            return;
        }
        callback();
        var index = Cache.starList.indexOf(targetId);
        if (index >= 0) {
            Cache.starList.splice(index, 1);
        }
        starObserverList.notify();
    });
};

Star.watch = function (listener) {
    starObserverList.add(listener);
};

Star.unwatch = function (listener) {
    starObserverList.remove(listener);
};

Star.getStarList = function () {
    function callback(result) {
        return result.data.map(function (user) {
            return user.id;
        });
    }

    return request('/userrelation/starcontacts', 'GET').then(callback);
};

RongIM.dataModel.Star = Star;
}(RongIM, {
    jQuery: jQuery
}));
