/* eslint-disable global-require */
(function (RongIM, win, Fingerprint) {
'use strict';

function noop() {}

var request = require('request');
request = request.defaults({
    rejectUnauthorized: false
});
var nw = require('nw.gui');
var app = nw.App;
var fs = require('fs');

var downloader = (function () {
    var Path = require('path');
    var Url = require('url');
    var Utils = require('./src/utils');
    var Downloader = require('./src/modules/download_extra/range_download').Downloader;
    var rangeConf = require('./src/cachePath').download.rangeConf;

    function showSaveDialog(options, callback) {
        var a = document.createElement('input');
        a.type = 'file';
        a.nwsaveas = options.defaultPath;
        a.onchange = function (event) {
            var selectPath = (event.target.files[0]).path;
            callback(selectPath);
            document.body.removeChild(a);
        };
        a.style = 'position: fixed;top: -100px;left: -100px;';
        document.body.appendChild(a);
        a.click();
    }

    /*
    file: {url: 文件下载链接, name: 保存后的别名, prefix: 前缀名, path:保存路径, chunkSize: 分片大小, size 总大小, uId: id}
    config: {timeout: timeout 连接超时, retries: 重试次数}
    */
    function Download(file, config) {
        config = config || {};
        var parsed = Url.parse(file.url);
        var filename = Path.basename(parsed.pathname);
        var ext = Path.extname(parsed.pathname);
        try {
            filename = decodeURI(decodeURI(filename));
        } catch (ex) {
            console.warn('decodeURI filename error', ex);
        }
        filename = file.name || filename;
        if (file.prefix) {
            filename = file.prefix + filename;
        }

        var downloadPath = file.path || app.dataPath;
        if (!Utils.dirExists(downloadPath)) {
            Utils.makeDir(downloadPath);
        }
        this.default = {
            url: encodeURI(file.url),
            path: downloadPath,
            name: filename,
            ext: ext,
            chunkSize: file.chunkSize,
            size: file.size,
            uId: file.uId
        };
        config.timeout = config.timeout || 100000;
        config.retries = config.retries || 10;
        this.config = config;
    }
    Download.prototype.save = function (name) {
        var me = this;
        var _name = name || me.default.name;
        var path = Path.join(me.default.path, _name);
        var file = {
            url: me.default.url,
            path: path,
            name: _name
        };
        me.start(file);
    };
    Download.prototype.continue = function () {
        var me = this;
        var fileRange = rangeConf[me.default.uId] || {};
        var path = fileRange.dist;
        var name = Path.basename(path);
        var file = {
            url: me.default.url,
            path: path,
            name: name
        };
        me.start(file);
    };
    /* file {
        path: path, 另存为的默认路径
        name: 保存的别名
    } */
    Download.prototype.saveAs = function (file) {
        file = file || {};
        var me = this;
        var path = Path.join(file.path || me.default.path, file.name || me.default.name);
        var dialogOptions = {
            title: file.name || me.default.name,
            defaultPath: path
        };

        showSaveDialog(dialogOptions, function (result) {
            if (result) {
                // 如果没有扩展名,自动保留原扩展名
                var savePath = result;
                var ext = Path.extname(savePath);
                var name = Path.basename(savePath);
                if (!ext) {
                    savePath += me.default.ext;
                }
                me.start({
                    url: me.default.url,
                    path: savePath,
                    name: name
                });
            }
        });
    };
    Download.prototype.start = function (file) {
        var me = this;
        var chunkSize = me.default.chunkSize;
        var size = me.default.size;
        var totalBytes = size;
        var savePath = Path.resolve(file.path);
        var downloadMap = {
            chunk: function () {
                var data = {
                    total: totalBytes,
                    path: savePath
                };
                if (me.onReady) me.onReady(data);
                var params = {
                    instance: me,
                    file: {
                        name: file.name,
                        dist: savePath,
                        url: file.url,
                        size: size,
                        chunkSize: chunkSize,
                        uId: me.default.uId
                    },
                    callbacks: {
                        onsuccess: function () {
                            data = {
                                loaded: totalBytes,
                                total: totalBytes,
                                path: savePath
                            };
                            var instance = params.instance;
                            if (instance.onComplete) instance.onComplete(data);
                        },
                        onprogress: function (ret) {
                            data = {
                                loaded: ret.loaded,
                                total: totalBytes,
                                path: savePath
                            };
                            var instance = params.instance;
                            if (instance.onProgress) instance.onProgress(data);
                        },
                        onchunkloaded: function () {
                        },
                        onbeforechunkloaded: function (ret) {
                            var instance = params.instance;
                            instance.request = ret.req;
                        },
                        onerror: function (error) {
                            var instance = params.instance;
                            if (instance.onError) instance.onError(error);
                        },
                        oncancel: function (ret) {
                            var instance = params.instance;
                            if (instance.onCancel) instance.onCancel(ret);
                        }
                    }
                };

                var loader = new Downloader(params);
                loader.downloadChunk();
            },
            full: function () {
                me.downloadFullFile(file);
            }
        };
        var type = 'full';
        if (size > chunkSize) {
            type = 'chunk';
        }
        downloadMap[type]();
    };
    Download.prototype.downloadFullFile = function (file) {
        var me = this;
        var receivedBytes = 0;
        var totalBytes = 0;
        var savePath = Path.resolve(file.path);
        var stream = fs.createWriteStream(savePath);
        var options = {
            method: 'GET',
            uri: file.url,
            timeout: me.config.timeout
        };
        var _error = null;

        var req = null;
        try {
            req = request(options);
        } catch (error) {
            if (me.onError) me.onError(error);
            return;
        }

        me.request = req || [];
        req.pipe(stream);

        var data = {
            state: '',
            loaded: '',
            total: '',
            path: ''
        };
        req.on('response', function (_data) {
            if (_data.statusCode !== 200) {
                _error = { code: _data.statusCode, description: _data.statusMessage };
                me.abort();
                return;
            }
            receivedBytes = 0;
            totalBytes = parseInt(_data.headers['content-length']);
            data = {
                total: totalBytes,
                path: savePath
            };
            if (me.onReady) me.onReady(data);
        });

        req.on('data', function (chunk) {
            receivedBytes += chunk.length;
            data = {
                loaded: receivedBytes,
                total: totalBytes,
                path: savePath
            };
            if (me.onProgress) me.onProgress(data);
        });

        req.on('end', function () {
            data = {
                loaded: receivedBytes,
                total: totalBytes,
                path: savePath
            };
            if (_error) {
                if (me.onError) me.onError(_error);
                // delete downloaded file
                fs.unlinkSync(data.path);
                return;
            }
            // 取消也会触发 end
            if (data.loaded >= data.total) {
                if (me.onComplete) me.onComplete(data);
            } else {
                // delete downloaded file
                fs.unlinkSync(data.path);
                if (me.onCancel) me.onCancel(data);
            }
        });

        req.on('error', function (error) {
            if (error.code === 'ETIMEDOUT' && me.onTimeout) {
                me.onTimeout(error);
                return;
            }
            switch (error.code) {
                case 'ENOTFOUND':
                    error.description = 'dns 找不到域名导致。请检查 1. 域名是否写错 2. 网络连接是否正常';
                    break;
                case 'ECONNREFUSED':
                    error.description = '这可能是因为防火墙或代理程序无法访问网络。请检查防火墙或者代理设置';
                    break;
                case 'ECONNRESET':
                    error.description = '请尝试在 options 中加入 {originalHostHeaderName: "Host"}';
                    break;
                case 'EPIPE':
                    error.description = '请检查您的 node 版本是否过低';
                    break;
                default:
                    error.description = '请参考官方文档 https://nodejs.org/api/errors.html';
                    break;
            }
            if (me.onError) me.onError(error);

            if (error.code === 'ESOCKETTIMEDOUT') {
                try {
                    stream.end(function () {
                        fs.unlinkSync(savePath);
                    });
                } catch (e) {
                    console.warn(e.message);
                }
            }
        });
    };
    Download.prototype.pause = function () {
        if (this.request) this.request.pause();
        if (this.onCancel) this.onCancel();
    };
    Download.prototype.resume = function () {
        if (this.request) this.request.resume();
    };
    Download.prototype.abort = function () {
        if (this.request) this.request.abort();
        if (this.onCancel) this.onCancel();
        // console.log('todo: 删除 RangeConf 中记录;删除下载碎片');
    };

    return {
        load: function (file, config) {
            return new Download(file, config);
        },
        getProgress: function (uId) {
            return rangeConf[uId] || {};
        },
        clearInvalid: function () {
        }
    };
}());

var stringFormat = function (temp, data, regexp) {
    if (!(Object.prototype.toString.call(data) === '[object Array]')) { data = [data]; }
    var ret = [];
    for (var i = 0, j = data.length; i < j; i += 1) {
        ret.push(replaceAction(data[i]));
    }
    return ret.join('');

    function replaceAction(object) {
        var undef;
        return temp.replace(regexp || (/{([^}]+)}/g), function (match, name) {
            if (match.charAt(0) === '\\') { return match.slice(1); }
            return (object[name] !== undef) ? object[name] : '{' + name + '}';
        });
    }
};

function regSearch() {
}

function unregSearch() {
}

function regLogout() {
}

function unregLogout() {
}

function regAccount() {
}

function unregAccount() {
}

function regBalloon() {
}

function unregBalloon() {
}
function unregOpenCoversation() {
}
function getVersion() {
    return '';
}

function getUserStatusTitle() {
    return 'Login_Status_Web';
}
// function getEmojiUrl() {
// }
function regDockClick() {
}

function unregDockClick() {
}
var client = {
    regSearch: regSearch,
    unregSearch: unregSearch,
    regLogout: regLogout,
    unregLogout: unregLogout,
    regAccount: regAccount,
    unregAccount: unregAccount,
    regBalloon: regBalloon,
    unregOpenCoversation: unregOpenCoversation,
    unregBalloon: unregBalloon,
    getVersion: getVersion,
    // showMessageBox: showMessageBox,
    getUserStatusTitle: getUserStatusTitle,
    regDockClick: regDockClick,
    unregDockClick: unregDockClick
};

var _download = function (url) {
    var a = document.createElement('A');
    a.href = url;
    a.download = url.substr(url.lastIndexOf('/') + 1);
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
};

var download = function (file) {
    return {
        start: function () {
            _download(file.url);
        },
        pause: noop,
        resume: noop,
        abort: noop,
        save: function () {
            _download(file.url);
        },
        saveAs: function () {
            _download(file.url);
        },
        onError: noop,
        onReady: noop,
        onProgress: noop,
        onComplete: noop,
        onCancel: noop
    };
};
/*
    params.type
    params.method
    params.data
*/
function set() {

}
/*
    params.type
    callback = function(error, result){
        // result.version ＝> 版本号，用来更新信息
        // result.data => 数据
    }
*/
function get(params, callback) {
    var result = {
        version: 0
    };
    var error = null;
    callback(error, result);
}

var dataProvider = {
    get: get,
    set: set
};

var nwwin = nw.Window.get();

var tray = new nw.Tray({
    title: '托盘图标',
    icon: 'res/app.png'
});
var menu = new nw.Menu();
menu.append(new nw.MenuItem({
    label: '打开',
    click: function () {
        nwwin.show();
    }
}));
menu.append(new nw.MenuItem({
    label: '退出',
    click: function () {
        tray.remove();
        tray = null;
        nwwin.close(true);
        app.quit();
    }
}));
tray.menu = menu;
tray.on('click', function () {
    nwwin.show();
});
nwwin.on('close', function () {
    this.hide();
});
nw.Window.get().on('new-win-policy', function (frame, url, policy) {
    // do not open the window
    policy.ignore();
    // and open it in external browser
    openExternal(url);
});

window.openExternal = function(url) {
    if (nw.Shell) {
        nw.Shell.openExternal(url);
    } else {
        var a = document.createElement('A');
        a.target = '_blank';
        a.href = url;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
    }
}

function maxWin() {
    nwwin.maximize();
}

function minWin() {
    nwwin.minimize();
}

function restoreWin() {
    nwwin.restore();
}

function closeWin() {
    nwwin.close();
}

function hideWin() {
}

function showWin() {
}

function flashFrame() {
}
function shakeWindow() {
}
function displayBalloon() {
}
function updateBadgeNumber() {
}
var remoteWindowHandler = {
    extend: noop,
    restore: noop,
    extendWidth: noop,
    getWindowSize: noop,
    setMinWidth: noop,
    setDefaultMinWidth: noop
};

var browserWindow = {
    max: maxWin,
    min: minWin,
    restore: restoreWin,
    close: closeWin,
    hide: hideWin,
    show: showWin,
    flashFrame: flashFrame,
    shakeWindow: shakeWindow,
    isFocused: noop,
    isVisible: noop,
    displayBalloon: displayBalloon,
    updateBadgeNumber: updateBadgeNumber,
    remoteWindowHandler: remoteWindowHandler,
    openPSArticle: openExternal,
    openVersions: function () {
        openExternal('./modules/appversion/index.html');
    },
    closeAll: noop,
    enterPublic: noop,
    sendPublicMessage: noop,
    sendPublicNotify: noop,
    openRemoteControl: noop,
    closeRemoteControl: noop,
    onRemoteControlAccept: noop,
    onRemoteControlReject: noop
};
// end region
var file = {
    checkExist: function (path) {
        return fs.existsSync(path);
    },
    open: function (path) {
        nw.Shell.openItem(path);
    },
    openDir: function (path) {
        nw.Shell.showItemInFolder(path);
    },
    getBlobs: function () { return null; },
    getPaths: function () { return ''; },
    getImgByPath: function () { return null; },
    getFiles: function () { return null; },
    zipFolders: noop,
    unzip: noop,
    delZip: noop,
    getFileStat: function () { return null; }
};
// @return 'web-darwin' or 'web-win32' or 'darwin' or 'win32'
function getPlatform() {
    return process.platform;
    // var platform = navigator.platform.toLowerCase();
    // if(platform.indexOf('mac') === 0){
    //     platform = 'darwin';
    // } else if(platform.indexOf('win') === 0){
    //     platform = 'win32';
    // } else if(platform.indexOf('linux') === 0){
    //     platform = 'linux';
    // }
    // return 'web-' + platform;
}

function getDeviceId() {
    var fp = new Fingerprint({
        canvas: true,
        ie_activex: true,
        screen_resolution: true
    });
    return fp.get();
}

var system = {
    setShowVersion: noop,
    setLanguage: noop,
    clearCache: noop,
    relaunch: noop,
    logout: noop,
    setConnectStatus: noop,
    locale: navigator.language || navigator.systemLanguage,
    getDeviceId: getDeviceId,
    messageNotification: noop,
    dbPath: '',
    platform: getPlatform(),
    version: '',
    userDataPath: '',
    login: noop,
    setAutoLaunch: noop,
    getAutoLaunch: function () { return false; },
    reload: noop,
    reloadIgnoringCache: noop,
    openByBrowser: openExternal,
    appLogger: noop,
    processLogger: noop
};

function isAvailableData() {
    // Web 连接成功时才可操作数据
    var CONNECTED = 0;
    var status = RongIMClient.getInstance().getCurrentConnectionStatus();
    return status === CONNECTED;
}

var lib = {
    getDataProvider: function () {
        return require('./src/modules/rongimlib/RongIMLib.node');
    },
    clearUnreadCountByTimestamp: function (params, callback) {
        RongIMClient.getInstance().clearUnreadCount(params.conversationType, params.targetId, {
            onSuccess: function () {
                callback();
            },
            onError: function (errorCode) {
                callback(errorCode);
            }
        });
    }
};
var screenshot = {
    start: noop,
    captureScreen: noop,
    // params(callback: function)
    setShortcut: noop,
    setHideWindow: noop,
    // params(enabled:boolean)
    setEnabled: noop
};

RongIM.remoteControl = {
    accept: noop,
    hangup: noop,
    join: noop
};

var getNavi = function (config, callback) {
    // var userId = config.userId;
    var appkey = config.appkey;
    var token = config.token;
    var version = config.version;
    var url = config.url;

    if (!url) {
        callback('url is undefined!');
        return;
    }
    // 判断是否走缓存
    // var navi = Cache.get(userId);
    // if (navi) {
    //     callback(null, navi);
    //     return;
    // }
    token = encodeURIComponent(token);
    var reqBody = 'token={token}&v={v}';
    reqBody = stringFormat(reqBody, { token: token, v: version });
    request({
        url: url,
        method: 'POST',
        headers: {
            appId: appkey
        },
        body: reqBody
    }, function (error, resp, body) {
        console.warn(error, resp, body);
        if (error) {
            callback(error);
            return;
        }
        try {
            body = JSON.parse(body);
        } catch (err) {
            callback(err);
            return;
        }
        if (!body.server) {
            callback('navi is invalid! server: ' + body.server);
            return;
        }
        var tpl = '{server}';
        if (body.bs) {
            tpl += ',{bs}';
        }
        body.serverList = stringFormat(tpl, {
            server: body.server,
            bs: body.bs
        });
        // Cache.set(userId, body);

        body.version = version;
        callback(null, body);
    });
};
var imageViewer = {
    openWin: function (options) {
        console.debug(options);
        ImageViewer.dialog.viewerWeb(options);
        /* common.mountDialog(options, function (instance) {
            RongIM._user = instance;
        }); */
    },
    close: noop,
    logout: noop,
    recall: function (messageUId) {
        var im = RongIM.instance;
        im.$emit('recallMsg', messageUId);
    }
};
RongIM.getNavi = getNavi;
RongIM.imageViewer = imageViewer;
RongIM.download = download;
RongIM.downloader = downloader;
RongIM.browserWindow = browserWindow;
RongIM.file = file;
RongIM.dataProvider = dataProvider;
RongIM.system = system;
RongIM.isAvailableData = isAvailableData;
RongIM.lib = lib;
RongIM.client = client;
RongIM.screenshot = screenshot;
}(RongIM, window, Fingerprint));
